/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auto.login.basic.auth.header;

import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.security.configuration.BasicAuthHeaderSupportConfiguration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"private.auto.login=true", "type=basic.auth.header"}, service={AutoLogin.class})
public class BasicAuthHeaderAutoLoginSupport
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(BasicAuthHeaderAutoLoginSupport.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this.isEnabled(this._portal.getCompanyId(httpServletRequest))) {
            return null;
        }
        HttpAuthorizationHeader httpAuthorizationHeader = HttpAuthManagerUtil.parse((HttpServletRequest)httpServletRequest);
        if (httpAuthorizationHeader == null) {
            return null;
        }
        String scheme = httpAuthorizationHeader.getScheme();
        if (!StringUtil.equalsIgnoreCase((String)scheme, (String)"Basic")) {
            return null;
        }
        long userId = HttpAuthManagerUtil.getUserId((HttpServletRequest)httpServletRequest, (HttpAuthorizationHeader)httpAuthorizationHeader);
        if (userId <= 0L) {
            throw new AuthException();
        }
        String[] credentials = new String[]{String.valueOf(userId), httpAuthorizationHeader.getAuthParameter("password"), Boolean.TRUE.toString()};
        return credentials;
    }

    protected boolean isEnabled(long companyId) {
        try {
            BasicAuthHeaderSupportConfiguration basicAuthHeaderSupportConfiguration = (BasicAuthHeaderSupportConfiguration)this._configurationProvider.getCompanyConfiguration(BasicAuthHeaderSupportConfiguration.class, companyId);
            return basicAuthHeaderSupportConfiguration.enabled();
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to get basic auth protocol support configuration", (Throwable)configurationException);
            return false;
        }
    }
}

