/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auto.login.remember.me;

import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.RememberMeToken;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.AutoLoginException;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.RememberMeTokenLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AutoLogin.class})
public class RememberMeAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(RememberMeAutoLogin.class);
    @Reference
    private Portal _portal;
    @Reference
    private RememberMeTokenLocalService _rememberMeTokenLocalService;
    @Reference
    private UserLocalService _userLocalService;

    protected String[] doHandleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws AutoLoginException {
        if (_log.isDebugEnabled()) {
            _log.debug((Throwable)exception);
        }
        this.removeCookies(httpServletRequest, httpServletResponse);
        throw new AutoLoginException((Throwable)exception);
    }

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String contextPath;
        RememberMeToken rememberMeToken = null;
        String rememberMeTokenId = CookiesManagerUtil.getCookieValue((String)"REMEMBER_ME_TOKEN_ID", (HttpServletRequest)httpServletRequest, (boolean)false);
        String rememberMeTokenValue = CookiesManagerUtil.getCookieValue((String)"REMEMBER_ME_TOKEN_VALUE", (HttpServletRequest)httpServletRequest, (boolean)false);
        if (Validator.isNotNull((String)rememberMeTokenId) && Validator.isNotNull((String)rememberMeTokenValue)) {
            rememberMeToken = this._rememberMeTokenLocalService.fetchRememberMeToken(GetterUtil.getLong((String)rememberMeTokenId), rememberMeTokenValue);
        }
        if (rememberMeToken == null) {
            this.removeCookies(httpServletRequest, httpServletResponse);
            return null;
        }
        User user = this._userLocalService.fetchUserById(rememberMeToken.getUserId());
        Company company = this._portal.getCompany(httpServletRequest);
        User guestUser = this._userLocalService.getGuestUser(company.getCompanyId());
        boolean rememberMe = GetterUtil.getBoolean((String)CookiesManagerUtil.getCookieValue((String)"REMEMBER_ME", (HttpServletRequest)httpServletRequest, (boolean)false));
        String proxyPath = this._portal.getPathProxy();
        if (proxyPath.equals(contextPath = this._portal.getPathContext())) {
            if (Validator.isNotNull((String)httpServletRequest.getContextPath())) {
                rememberMe = true;
            }
        } else if (!contextPath.equals(httpServletRequest.getContextPath())) {
            rememberMe = false;
        }
        if (!company.isAutoLogin() || user == null || guestUser.getUserId() == user.getUserId() || !user.isActive() || !rememberMe || rememberMeToken.isExpired()) {
            this.removeCookies(httpServletRequest, httpServletResponse);
            this._rememberMeTokenLocalService.deleteRememberMeToken(rememberMeToken.getRememberMeTokenId());
            return null;
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), String.valueOf(user.isPasswordEncrypted())};
        return credentials;
    }

    protected void removeCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String domain = CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest);
        CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"REMEMBER_ME_TOKEN_ID"});
        CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"REMEMBER_ME_TOKEN_VALUE"});
    }
}

