/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.content.security.policy.internal;

import com.liferay.portal.kernel.security.SecureRandom;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.content.security.policy.internal.configuration.ContentSecurityPolicyConfiguration;
import com.liferay.portal.security.content.security.policy.internal.configuration.ContentSecurityPolicyConfigurationUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ContentSecurityPolicyNonceManager.class})
public class ContentSecurityPolicyNonceManager {
    private static final String _NONCE = ContentSecurityPolicyNonceManager.class.getName() + "#NONCE";
    @Reference
    private Portal _portal;
    private final ThreadLocal<String> _threadLocal = new ThreadLocal();

    public void cleanUpNonce(HttpServletRequest httpServletRequest) {
        httpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        httpServletRequest.removeAttribute(_NONCE);
        this._threadLocal.remove();
    }

    public String getNonce(HttpServletRequest httpServletRequest) {
        String nonce = this._threadLocal.get();
        if (nonce != null) {
            return nonce;
        }
        if (httpServletRequest == null) {
            return "";
        }
        return GetterUtil.getString((Object)httpServletRequest.getAttribute(_NONCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setNonce(HttpServletRequest httpServletRequest) {
        String nonce = null;
        ContentSecurityPolicyConfiguration contentSecurityPolicyConfiguration = ContentSecurityPolicyConfigurationUtil.getContentSecurityPolicyConfiguration(httpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest));
        if (!contentSecurityPolicyConfiguration.enabled()) {
            nonce = "";
        } else if (PropsValues.JAVASCRIPT_SINGLE_PAGE_APPLICATION_ENABLED) {
            HttpSession httpSession = httpServletRequest.getSession();
            nonce = (String)httpSession.getAttribute(_NONCE);
            if (nonce == null) {
                HttpSession httpSession2 = httpSession;
                synchronized (httpSession2) {
                    nonce = (String)httpSession.getAttribute(_NONCE);
                    if (nonce == null) {
                        nonce = this._generateNonce();
                        httpSession.setAttribute(_NONCE, (Object)nonce);
                    }
                }
            }
        } else {
            nonce = this._generateNonce();
        }
        httpServletRequest.setAttribute(_NONCE, (Object)nonce);
        this._threadLocal.set(nonce);
        return nonce;
    }

    private String _generateNonce() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[16];
        secureRandom.nextBytes(bytes);
        return Base64.encode((byte[])bytes);
    }
}

