/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.content.security.policy.internal.configuration;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.content.security.policy.internal.configuration.ContentSecurityPolicyConfiguration;
import javax.servlet.http.HttpServletRequest;

public class ContentSecurityPolicyConfigurationUtil {
    private static final ContentSecurityPolicyConfiguration _CONTENT_SECURITY_POLICY_CONFIGURATION = new ContentSecurityPolicyConfiguration(){
        private final String[] _excludedPaths = new String[0];

        @Override
        public boolean enabled() {
            return false;
        }

        @Override
        public String[] excludedPaths() {
            return this._excludedPaths;
        }

        @Override
        public String policy() {
            return "";
        }
    };

    public static ContentSecurityPolicyConfiguration getContentSecurityPolicyConfiguration(HttpServletRequest httpServletRequest) {
        return (ContentSecurityPolicyConfiguration)httpServletRequest.getAttribute(ContentSecurityPolicyConfigurationUtil.class.getName());
    }

    public static ContentSecurityPolicyConfiguration setContentSecurityPolicyConfiguration(ConfigurationProvider configurationProvider, HttpServletRequest httpServletRequest, Portal portal) {
        ContentSecurityPolicyConfiguration contentSecurityPolicyConfiguration;
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-134060")) {
            contentSecurityPolicyConfiguration = _CONTENT_SECURITY_POLICY_CONFIGURATION;
        } else {
            try {
                long groupId = portal.getScopeGroupId(httpServletRequest);
                contentSecurityPolicyConfiguration = groupId > 0L ? (ContentSecurityPolicyConfiguration)configurationProvider.getGroupConfiguration(ContentSecurityPolicyConfiguration.class, groupId) : (ContentSecurityPolicyConfiguration)configurationProvider.getCompanyConfiguration(ContentSecurityPolicyConfiguration.class, portal.getCompanyId(httpServletRequest));
            }
            catch (PortalException portalException) {
                return (ContentSecurityPolicyConfiguration)ReflectionUtil.throwException((Throwable)portalException);
            }
        }
        httpServletRequest.setAttribute(ContentSecurityPolicyConfigurationUtil.class.getName(), (Object)contentSecurityPolicyConfiguration);
        return contentSecurityPolicyConfiguration;
    }
}

