/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.content.security.policy.internal.servlet.filter;

import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.content.security.policy.internal.ContentSecurityPolicyNonceManager;
import com.liferay.portal.security.content.security.policy.internal.configuration.ContentSecurityPolicyConfiguration;
import com.liferay.portal.security.content.security.policy.internal.configuration.ContentSecurityPolicyConfigurationUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"after-filter=Portal CORS Servlet Filter", "dispatcher=FORWARD", "dispatcher=REQUEST", "servlet-context-name=", "servlet-filter-name=Content Security Policy Filter", "url-pattern=/*"}, service={Filter.class})
public class ContentSecurityPolicyFilter
extends BasePortalFilter {
    private static final String[] _INTERNALLY_EXCLUDED_PATHS = new String[]{"/group/", "/user/", "/web/"};
    private static final Log _log = LogFactoryUtil.getLog(ContentSecurityPolicyFilter.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private ContentSecurityPolicyNonceManager _contentSecurityPolicyNonceManager;
    @Reference
    private Portal _portal;

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (CompanyThreadLocal.getCompanyId() == 0L) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Content security policy will not be applied to this request for company ID 0");
            }
            return false;
        }
        ContentSecurityPolicyConfiguration contentSecurityPolicyConfiguration = ContentSecurityPolicyConfigurationUtil.setContentSecurityPolicyConfiguration(this._configurationProvider, httpServletRequest, this._portal);
        return contentSecurityPolicyConfiguration.enabled() && !Validator.isNull((String)contentSecurityPolicyConfiguration.policy()) && !this._isExcludedURIPath(contentSecurityPolicyConfiguration, httpServletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        String nonce = this._contentSecurityPolicyNonceManager.setNonce(httpServletRequest);
        try {
            httpServletResponse.setContentType("text/html; charset=UTF-8");
            ContentSecurityPolicyConfiguration contentSecurityPolicyConfiguration = ContentSecurityPolicyConfigurationUtil.getContentSecurityPolicyConfiguration(httpServletRequest);
            String policy = contentSecurityPolicyConfiguration.policy();
            policy = StringUtil.replace((String)policy, (String)"[$NONCE$]", (String)("nonce-" + nonce));
            httpServletResponse.setHeader("Content-Security-Policy", policy);
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            this._contentSecurityPolicyNonceManager.cleanUpNonce(httpServletRequest);
        }
    }

    private boolean _isExcludedURIPath(ContentSecurityPolicyConfiguration contentSecurityPolicyConfiguration, HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        if (Validator.isNull((String)requestURI)) {
            return false;
        }
        for (String internallyExcludedPath : _INTERNALLY_EXCLUDED_PATHS) {
            if (!Validator.isNotNull((String)internallyExcludedPath) || !requestURI.startsWith(StringUtil.toLowerCase((String)internallyExcludedPath))) continue;
            return true;
        }
        requestURI = StringUtil.toLowerCase((String)requestURI);
        for (String excludedPath : contentSecurityPolicyConfiguration.excludedPaths()) {
            if (!Validator.isNotNull((String)excludedPath) || !requestURI.startsWith(StringUtil.toLowerCase((String)excludedPath))) continue;
            return true;
        }
        return false;
    }

    private static class ContentSecurityPolicyHttpServletResponse
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream _byteArrayOutputStream;
        private PrintWriter _printWriter;
        private ServletOutputStream _servletOutputStream;

        public ContentSecurityPolicyHttpServletResponse(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
            this._byteArrayOutputStream = new ByteArrayOutputStream(httpServletResponse.getBufferSize());
        }

        public void flushBuffer() throws IOException {
            super.flushBuffer();
            if (this._printWriter != null) {
                this._printWriter.flush();
            } else if (this._servletOutputStream != null) {
                this._servletOutputStream.flush();
            }
        }

        public String getContent() throws IOException {
            if (this._printWriter != null) {
                this._printWriter.close();
            } else if (this._servletOutputStream != null) {
                this._servletOutputStream.close();
            }
            return this._byteArrayOutputStream.toString(this.getCharacterEncoding());
        }

        public ServletOutputStream getOutputStream() {
            if (this._printWriter != null) {
                throw new IllegalStateException("Get writer has already been called");
            }
            if (this._servletOutputStream == null) {
                this._servletOutputStream = new ServletOutputStream(){

                    public void close() throws IOException {
                        _byteArrayOutputStream.close();
                    }

                    public void flush() throws IOException {
                        _byteArrayOutputStream.flush();
                    }

                    public boolean isReady() {
                        return _servletOutputStream.isReady();
                    }

                    public void setWriteListener(WriteListener writeListener) {
                        _servletOutputStream.setWriteListener(writeListener);
                    }

                    public void write(int b) {
                        _byteArrayOutputStream.write(b);
                    }
                };
            }
            return this._servletOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this._servletOutputStream != null) {
                throw new IllegalStateException("Get output stream has already been called");
            }
            if (this._printWriter == null) {
                this._printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this._byteArrayOutputStream, this.getCharacterEncoding()));
            }
            return this._printWriter;
        }
    }
}

