/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.iframe.sanitizer.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.sanitizer.Sanitizer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.iframe.sanitizer.configuration.IFrameConfiguration;
import com.liferay.portal.security.iframe.sanitizer.internal.configuration.helper.IFrameConfigurationHelper;
import java.util.Map;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.iframe.sanitizer.configuration.IFrameConfiguration"}, service={Sanitizer.class})
public class IFrameSanitizerImpl
implements Sanitizer {
    @Reference
    private IFrameConfigurationHelper _iFrameConfigurationHelper;

    public String sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, String content, Map<String, Object> options) {
        IFrameConfiguration companyIFrameConfiguration = this._iFrameConfigurationHelper.getCompanyIFrameConfiguration(companyId);
        if (!companyIFrameConfiguration.enabled() || Validator.isNull((String)content) || Validator.isNull((String)contentType) || !contentType.equals("text/html") || this._isWhitelisted(this._iFrameConfigurationHelper.getCompanyBlacklist(companyId), className, classPK, this._iFrameConfigurationHelper.getCompanyWhitelist(companyId))) {
            return content;
        }
        Document document = this._getDocument(content);
        for (Element iFrameElement : document.getElementsByTag("iframe")) {
            if (companyIFrameConfiguration.removeIFrameTags()) {
                iFrameElement.remove();
                continue;
            }
            iFrameElement.attr("sandbox", StringUtil.merge((Object[])companyIFrameConfiguration.sandboxAttributeValues(), (String)" "));
        }
        Element bodyElement = document.body();
        StringBundler sb = new StringBundler(bodyElement.childNodeSize());
        for (Node childNode : bodyElement.childNodes()) {
            sb.append(childNode.toString());
        }
        return sb.toString();
    }

    private Document _getDocument(String content) {
        Document document = Jsoup.parseBodyFragment((String)content);
        document.outputSettings(new Document.OutputSettings(){
            {
                this.prettyPrint(false);
            }
        });
        return document;
    }

    private boolean _isWhitelisted(Set<String> blacklist, String className, long classPK, Set<String> whitelist) {
        String classNameAndClassPK = className + "#" + classPK;
        for (String blacklistItem : blacklist) {
            if (!blacklistItem.equals("*") && !classNameAndClassPK.startsWith(blacklistItem)) continue;
            return false;
        }
        for (String whitelistItem : whitelist) {
            if (!whitelistItem.equals("*") && !classNameAndClassPK.startsWith(whitelistItem)) continue;
            return true;
        }
        return false;
    }
}

