/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.iframe.sanitizer.internal.configuration.helper;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.security.iframe.sanitizer.configuration.IFrameConfiguration;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.security.iframe.sanitizer.configuration.IFrameConfiguration"}, service={IFrameConfigurationHelper.class})
public class IFrameConfigurationHelper {
    private final Map<Long, Set<String>> _companyBlacklist = new ConcurrentHashMap<Long, Set<String>>();
    private final Map<Long, IFrameConfiguration> _companyConfigurationBeans = new ConcurrentHashMap<Long, IFrameConfiguration>();
    private final Map<String, Long> _companyIds = new ConcurrentHashMap<String, Long>();
    private final Map<Long, Set<String>> _companyWhitelist = new ConcurrentHashMap<Long, Set<String>>();
    private volatile Set<String> _defaultBlacklist = new HashSet<String>();
    private volatile IFrameConfiguration _defaultIFrameConfiguration;
    private volatile Set<String> _defaultWhitelist = new HashSet<String>();
    private ServiceRegistration<ManagedServiceFactory> _serviceRegistration;

    public Set<String> getCompanyBlacklist(long companyId) {
        return this._companyBlacklist.getOrDefault(companyId, this._defaultBlacklist);
    }

    public IFrameConfiguration getCompanyIFrameConfiguration(long companyId) {
        return this._companyConfigurationBeans.getOrDefault(companyId, this._defaultIFrameConfiguration);
    }

    public Set<String> getCompanyWhitelist(long companyId) {
        return this._companyWhitelist.getOrDefault(companyId, this._defaultWhitelist);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        this._serviceRegistration = bundleContext.registerService(ManagedServiceFactory.class, (Object)new IFrameConfigurationManagedServiceFactory(), MapUtil.singletonDictionary((Object)"service.pid", (Object)"com.liferay.portal.security.iframe.sanitizer.configuration.IFrameConfiguration.scoped"));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._defaultIFrameConfiguration = (IFrameConfiguration)ConfigurableUtil.createConfigurable(IFrameConfiguration.class, properties);
        this._defaultBlacklist = SetUtil.fromArray((Object[])this._defaultIFrameConfiguration.blacklist());
        this._defaultWhitelist = SetUtil.fromArray((Object[])this._defaultIFrameConfiguration.whitelist());
    }

    private Set<String> _getBlacklist(long companyId) {
        IFrameConfiguration iFrameConfiguration = this.getCompanyIFrameConfiguration(companyId);
        if (iFrameConfiguration == null) {
            return Collections.emptySet();
        }
        return this._getClassNames(SetUtil.fromArray((Object[])iFrameConfiguration.blacklist()));
    }

    private Set<String> _getClassNames(Set<String> classNames) {
        if (SetUtil.isEmpty(classNames)) {
            return Collections.emptySet();
        }
        for (String className : classNames) {
            if ((className = className.trim()).isEmpty()) continue;
            className = this._stripTrailingStar(className);
            classNames.add(className);
        }
        return classNames;
    }

    private Set<String> _getWhitelist(long companyId) {
        IFrameConfiguration iFrameConfiguration = this.getCompanyIFrameConfiguration(companyId);
        if (iFrameConfiguration == null) {
            return Collections.emptySet();
        }
        return this._getClassNames(SetUtil.fromArray((Object[])iFrameConfiguration.whitelist()));
    }

    private String _stripTrailingStar(String item) {
        if (item.equals("*")) {
            return item;
        }
        char c = item.charAt(item.length() - 1);
        if (c == '*') {
            return item.substring(0, item.length() - 1);
        }
        return item;
    }

    private class IFrameConfigurationManagedServiceFactory
    implements ManagedServiceFactory {
        private IFrameConfigurationManagedServiceFactory() {
        }

        public void deleted(String pid) {
            this._unmapPid(pid);
        }

        public String getName() {
            return "com.liferay.portal.security.iframe.sanitizer.configuration.IFrameConfiguration.scoped";
        }

        public void updated(String pid, Dictionary<String, ?> dictionary) throws ConfigurationException {
            this._unmapPid(pid);
            long companyId = GetterUtil.getLong(dictionary.get("companyId"), (long)0L);
            if (companyId != 0L) {
                IFrameConfigurationHelper.this._companyConfigurationBeans.put(companyId, ConfigurableUtil.createConfigurable(IFrameConfiguration.class, dictionary));
                IFrameConfigurationHelper.this._companyIds.put(pid, companyId);
                IFrameConfigurationHelper.this._companyBlacklist.put(companyId, IFrameConfigurationHelper.this._getBlacklist(companyId));
                IFrameConfigurationHelper.this._companyWhitelist.put(companyId, IFrameConfigurationHelper.this._getWhitelist(companyId));
            }
        }

        private void _unmapPid(String pid) {
            Long companyId = (Long)IFrameConfigurationHelper.this._companyIds.remove(pid);
            if (companyId != null) {
                IFrameConfigurationHelper.this._companyConfigurationBeans.remove(companyId);
                IFrameConfigurationHelper.this._companyBlacklist.remove(companyId);
                IFrameConfigurationHelper.this._companyWhitelist.remove(companyId);
            }
        }
    }
}

