/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.ldap.SafeLdapFilter;
import com.liferay.portal.security.ldap.validator.LDAPFilterException;
import com.liferay.portal.security.ldap.validator.LDAPFilterValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

public class SafeLdapFilterTemplate
extends SafeLdapFilter {
    private final LDAPFilterValidator _ldapFilterValidator;
    private final String[] _replaceKeys;

    public SafeLdapFilterTemplate(String template, String[] replaceKeys, LDAPFilterValidator ldapFilterValidator) throws LDAPFilterException {
        super(new StringBundler(template), Collections.emptyList());
        if (replaceKeys == null) {
            replaceKeys = new String[]{};
        }
        this._replaceKeys = replaceKeys;
        this._ldapFilterValidator = ldapFilterValidator;
        this._ldapFilterValidator.validate(template);
        this._validateReplaceKeyInObject(template);
    }

    public String[] getReplaceKeys() {
        return Arrays.copyOf(this._replaceKeys, this._replaceKeys.length);
    }

    public SafeLdapFilterTemplate replace(String[] keys, String[] values) throws LDAPFilterException {
        if (keys == null) {
            throw new IllegalArgumentException("Parameter keys array is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Parameter values array is null");
        }
        if (keys.length > values.length) {
            throw new IllegalArgumentException("Parameters keys and values must have the same length");
        }
        for (String key : keys) {
            boolean found = false;
            for (String replaceKey : this._replaceKeys) {
                if (!replaceKey.equals(key)) continue;
                found = true;
            }
            if (found) continue;
            throw new IllegalArgumentException("Parameter key " + key + " is not supported by the template");
        }
        Object[] placeholderValues = new String[values.length];
        Arrays.fill(placeholderValues, "{PLACEHOLDER}");
        StringBundler oldFilterSB = this.getFilterStringBundler();
        StringBundler newFilterSB = new StringBundler();
        ArrayList<Object> newArguments = new ArrayList<Object>();
        Object[] oldArguments = this.getArguments();
        int argumentsPos = 0;
        for (int i = 0; i < oldFilterSB.index(); ++i) {
            String filterString = oldFilterSB.stringAt(i);
            if (filterString == null) continue;
            if (Objects.equals(filterString, "{PLACEHOLDER}")) {
                newFilterSB.append("{PLACEHOLDER}");
                newArguments.add(oldArguments[argumentsPos]);
                ++argumentsPos;
                continue;
            }
            TreeMap<Integer, String> valuesTreeMap = new TreeMap<Integer, String>();
            for (int j = 0; j < keys.length; ++j) {
                String key = keys[j];
                int pos = filterString.indexOf(key);
                while (pos > -1) {
                    valuesTreeMap.put(pos, values[j]);
                    pos = filterString.indexOf(key, pos + key.length());
                }
            }
            if (valuesTreeMap.isEmpty()) {
                newFilterSB.append(filterString);
                continue;
            }
            newArguments.addAll(valuesTreeMap.values());
            String replacedKeys = StringUtil.replace((String)filterString, (String[])keys, (String[])placeholderValues);
            int pos = replacedKeys.indexOf("{PLACEHOLDER}");
            int lastPos = 0;
            while (pos > -1) {
                newFilterSB.append(replacedKeys.substring(lastPos, pos));
                newFilterSB.append("{PLACEHOLDER}");
                lastPos = pos + "{PLACEHOLDER}".length();
                pos = replacedKeys.indexOf("{PLACEHOLDER}", lastPos);
            }
            if (lastPos >= replacedKeys.length()) continue;
            newFilterSB.append(replacedKeys.substring(lastPos));
        }
        this._ldapFilterValidator.validate(newFilterSB.toString());
        return new SafeLdapFilterTemplate(newFilterSB, newArguments, this._replaceKeys, this._ldapFilterValidator);
    }

    protected SafeLdapFilterTemplate(StringBundler filterSB, List<Object> arguments, String[] replaceKeys, LDAPFilterValidator ldapFilterValidator) {
        super(filterSB, arguments);
        this._replaceKeys = replaceKeys;
        this._ldapFilterValidator = ldapFilterValidator;
    }

    private void _validateReplaceKeyInObject(String template) throws LDAPFilterException {
        int pos = template.lastIndexOf("=");
        while (pos > -1) {
            String expression = template.substring(template.lastIndexOf("(", pos), pos);
            if (expression.contains("=")) {
                pos = template.lastIndexOf("=", pos - 1);
                continue;
            }
            for (String replaceKey : this._replaceKeys) {
                if (!expression.contains(replaceKey)) continue;
                throw new LDAPFilterException(StringBundler.concat((String[])new String[]{"Expression '", expression, "' cannot contain '", replaceKey, "' inside template '", template, "'"}));
            }
            pos = template.lastIndexOf("=", pos - 1);
        }
    }
}

