/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.model.listener;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.exportimport.UserOperation;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import com.liferay.portal.security.ldap.internal.model.listener.CallableUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ModelListener.class})
public class UserGroupModelListener
extends BaseModelListener<UserGroup> {
    private static final Log _log = LogFactoryUtil.getLog(UserGroupModelListener.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile UserExporter _userExporter;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterAddAssociation(Object userGroupId, String associationClassName, Object associationClassPK) {
        try {
            if (associationClassName.equals(User.class.getName())) {
                this.exportToLDAP((Long)associationClassPK, (Long)userGroupId, UserOperation.ADD);
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to export user group with user ID " + associationClassPK + " to LDAP on after add association"), (Throwable)exception);
        }
    }

    public void onAfterRemoveAssociation(Object userGroupId, String associationClassName, Object associationClassPK) {
        try {
            if (associationClassName.equals(User.class.getName())) {
                this.exportToLDAP((Long)associationClassPK, (Long)userGroupId, UserOperation.REMOVE);
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to export user group with user ID " + associationClassPK + " to LDAP on after remove association"), (Throwable)exception);
        }
    }

    protected void exportToLDAP(long userId, long userGroupId, UserOperation userOperation) {
        if (UserImportTransactionThreadLocal.isOriginatesFromImport()) {
            return;
        }
        TransactionCommitCallbackUtil.registerCallback(CallableUtil.getCallable(expandoBridgeAttributes -> {
            block4: {
                if (this._userLocalService.fetchUser(userId) == null || this._userGroupLocalService.fetchUserGroup(userGroupId) == null) {
                    return;
                }
                try {
                    this._userExporter.exportUser(userId, userGroupId, userOperation);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Throwable)exception);
                }
            }
            if (_log.isDebugEnabled() && _log.isDebugEnabled()) {
                StringBundler.concat((Object[])new Object[]{"Exporting user ", userId, " to user group ", userGroupId, " with user operation ", userOperation.name()});
            }
        }));
    }
}

