/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.authenticator;

import com.liferay.admin.kernel.util.Omniadmin;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PasswordExpiredException;
import com.liferay.portal.kernel.exception.UserLockoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.Authenticator;
import com.liferay.portal.kernel.security.auth.PasswordModificationThreadLocal;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.SafeLdapContext;
import com.liferay.portal.security.ldap.SafeLdapFilter;
import com.liferay.portal.security.ldap.SafeLdapFilterTemplate;
import com.liferay.portal.security.ldap.SafeLdapNameFactory;
import com.liferay.portal.security.ldap.SafePortalLDAP;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import com.liferay.portal.security.ldap.internal.authenticator.LDAPAuthResult;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import com.liferay.portal.security.ldap.validator.LDAPFilterValidator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"key=auth.pipeline.pre"}, service={Authenticator.class})
public class LDAPAuth
implements Authenticator {
    public static final String RESULT_PASSWORD_EXP_WARNING = "2.16.840.1.113730.3.4.5";
    public static final String RESULT_PASSWORD_RESET = "2.16.840.1.113730.3.4.4";
    private static final Log _log = LogFactoryUtil.getLog(LDAPAuth.class);
    private boolean _authPipelineEnableLiferayCheck;
    private final ThreadLocal<Map<String, LDAPAuthResult>> _failedLDAPAuthResults = new CentralizedThreadLocal(LDAPAuth.class + "._failedLDAPAuthResultCache", HashMap::new);
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)")
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile LDAPFilterValidator _ldapFilterValidator;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)")
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)")
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    @Reference
    private LDAPSettings _ldapSettings;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile LDAPUserImporter _ldapUserImporter;
    @Reference
    private Omniadmin _omniadmin;
    @Reference
    private PasswordEncryptor _passwordEncryptor;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile SafePortalLDAP _portalLDAP;
    @Reference
    private Props _props;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration)")
    private ConfigurationProvider<SystemLDAPConfiguration> _systemLDAPConfigurationProvider;
    @Reference
    private UserLocalService _userLocalService;

    public int authenticateByEmailAddress(long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this._authenticate(companyId, emailAddress, "", 0L, password);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new AuthException((Throwable)exception);
        }
    }

    public int authenticateByScreenName(long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this._authenticate(companyId, "", screenName, 0L, password);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new AuthException((Throwable)exception);
        }
    }

    public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this._authenticate(companyId, "", "", userId, password);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new AuthException((Throwable)exception);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._authPipelineEnableLiferayCheck = GetterUtil.getBoolean((String)this._props.get("auth.pipeline.enable.liferay.check"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPAuthResult _authenticate(LdapContext ctx, long companyId, Attributes attributes, String userDN, String password) throws Exception {
        LDAPAuthResult ldapAuthResult = null;
        LDAPAuthConfiguration ldapAuthConfiguration = (LDAPAuthConfiguration)this._ldapAuthConfigurationProvider.getConfiguration(companyId);
        String authMethod = ldapAuthConfiguration.method();
        if (authMethod.equals("bind")) {
            Hashtable<String, Object> env = ctx.getEnvironment();
            SystemLDAPConfiguration systemLDAPConfiguration = (SystemLDAPConfiguration)this._systemLDAPConfigurationProvider.getConfiguration(companyId);
            env.put("java.naming.referral", systemLDAPConfiguration.referral());
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.security.principal", userDN);
            env.put("com.sun.jndi.ldap.connect.pool", "false");
            ldapAuthResult = this._getFailedLDAPAuthResult(env);
            if (ldapAuthResult != null) {
                return ldapAuthResult;
            }
            ldapAuthResult = new LDAPAuthResult();
            try (InitialLdapContext initialLdapContext = null;){
                initialLdapContext = new InitialLdapContext(env, null);
                ldapAuthResult.setAuthenticated(true);
                ldapAuthResult.setResponseControl(initialLdapContext.getResponseControls());
            }
        } else if (authMethod.equals("password-compare")) {
            ldapAuthResult = new LDAPAuthResult();
            Attribute userPassword = attributes.get("userPassword");
            if (userPassword != null) {
                String encryptedPassword = password;
                String ldapPassword = new String((byte[])userPassword.get());
                if (Validator.isNotNull((String)ldapAuthConfiguration.passwordEncryptionAlgorithm()) && !Objects.equals(ldapAuthConfiguration.passwordEncryptionAlgorithm(), "NONE")) {
                    ldapPassword = this._removeEncryptionAlgorithm(ldapPassword);
                    encryptedPassword = this._passwordEncryptor.encrypt(ldapAuthConfiguration.passwordEncryptionAlgorithm(), password, ldapPassword);
                }
                if (ldapPassword.equals(encryptedPassword)) {
                    ldapAuthResult.setAuthenticated(true);
                } else {
                    ldapAuthResult.setAuthenticated(false);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Passwords do not match for userDN " + userDN));
                    }
                }
            }
        }
        return ldapAuthResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _authenticate(long ldapServerId, long companyId, String emailAddress, String screenName, long userId, String password) throws Exception {
        SafeLdapContext safeLdapContext = this._portalLDAP.getSafeLdapContext(ldapServerId, companyId);
        if (safeLdapContext == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"No LDAP server configuration available for LDAP ", "server ", ldapServerId, " and company ", companyId}));
            }
            return -1;
        }
        NamingEnumeration enumeration = null;
        try {
            String errorMessage;
            String fullUserDN;
            SearchResult searchResult;
            Attributes attributes;
            LDAPAuthResult ldapAuthResult;
            LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
            if (ldapServerConfiguration.ldapServerId() != ldapServerId) {
                int n = 0;
                return n;
            }
            SafeLdapFilterTemplate authSearchSafeLdapFilterTemplate = LDAPUtil.getAuthSearchSafeLdapFilterTemplate((LDAPServerConfiguration)ldapServerConfiguration, (LDAPFilterValidator)this._ldapFilterValidator);
            if (authSearchSafeLdapFilterTemplate == null) {
                _log.error((Object)"Missing authSearchFilter");
                int n = -1;
                return n;
            }
            authSearchSafeLdapFilterTemplate = authSearchSafeLdapFilterTemplate.replace(new String[]{"@company_id@", "@email_address@", "@screen_name@", "@user_id@"}, new String[]{String.valueOf(companyId), emailAddress, screenName, String.valueOf(userId)});
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty("screenName"));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            enumeration = safeLdapContext.search(LDAPUtil.getBaseDNSafeLdapName((LDAPServerConfiguration)ldapServerConfiguration), (SafeLdapFilter)authSearchSafeLdapFilterTemplate, searchControls);
            if (!enumeration.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No results found with search filter: " + authSearchSafeLdapFilterTemplate));
                }
                int n = 0;
                return n;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Found results with search filter: " + authSearchSafeLdapFilterTemplate));
            }
            if (!(ldapAuthResult = this._authenticate((LdapContext)safeLdapContext, companyId, attributes = this._portalLDAP.getUserAttributes(ldapServerId, companyId, safeLdapContext, SafeLdapNameFactory.from((Binding)(searchResult = (SearchResult)enumeration.nextElement()))), fullUserDN = searchResult.getNameInNamespace(), password)).isAuthenticated()) {
                password = null;
            }
            User user = this._ldapUserImporter.importUser(ldapServerId, companyId, safeLdapContext, attributes, password);
            if (!ldapAuthResult.isAuthenticated()) {
                PasswordModificationThreadLocal.setPasswordModified((boolean)false);
            }
            if ((errorMessage = ldapAuthResult.getErrorMessage()) != null) {
                SystemLDAPConfiguration systemLDAPConfiguration = (SystemLDAPConfiguration)this._systemLDAPConfigurationProvider.getConfiguration(companyId);
                for (String errorUserLockoutKeyword : systemLDAPConfiguration.errorUserLockoutKeywords()) {
                    if (!errorMessage.contains(errorUserLockoutKeyword)) continue;
                    throw new UserLockoutException.LDAPLockout(fullUserDN, errorMessage);
                }
                for (String errorPasswordExpiredKeyword : systemLDAPConfiguration.errorPasswordExpiredKeywords()) {
                    if (!errorMessage.contains(errorPasswordExpiredKeyword)) continue;
                    throw new PasswordExpiredException();
                }
            }
            if (!ldapAuthResult.isAuthenticated()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to authenticate with ", fullUserDN, " on LDAP server ", ldapServerId, ", company ", companyId, ", and LDAP context ", safeLdapContext, ": ", errorMessage}));
                }
                int systemLDAPConfiguration = -1;
                return systemLDAPConfiguration;
            }
            String resultCode = ldapAuthResult.getResponseControl();
            if (resultCode.equals(RESULT_PASSWORD_RESET)) {
                this._userLocalService.updatePasswordReset(user.getUserId(), true);
            }
        }
        catch (Exception exception) {
            if (exception instanceof PasswordExpiredException || exception instanceof UserLockoutException) {
                throw exception;
            }
            _log.error((Object)"Problem accessing LDAP server", (Throwable)exception);
            int n = -1;
            return n;
        }
        finally {
            if (enumeration != null) {
                enumeration.close();
            }
            safeLdapContext.close();
        }
        return 1;
    }

    private int _authenticate(long companyId, String emailAddress, String screenName, long userId, String password) throws Exception {
        LDAPAuthConfiguration ldapAuthConfiguration = (LDAPAuthConfiguration)this._ldapAuthConfigurationProvider.getConfiguration(companyId);
        if (!ldapAuthConfiguration.enabled()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Authenticator is not enabled");
            }
            return 1;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Authenticator is enabled");
        }
        long preferredLDAPServerId = this._getPreferredLDAPServer(companyId, emailAddress, screenName, userId);
        int preferredLDAPServerResult = this._authenticateAgainstPreferredLDAPServer(companyId, preferredLDAPServerId, emailAddress, screenName, userId, password);
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        if (preferredLDAPServerResult == 1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Found preferred LDAP server");
            }
            if (ldapImportConfiguration.importUserPasswordEnabled()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Import user password enabled");
                }
                return preferredLDAPServerResult;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Import user password disabled");
            }
            return 2;
        }
        List ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
        for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
            if (preferredLDAPServerId == ldapServerConfiguration.ldapServerId()) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Bypassing preferred LDAP server");
                continue;
            }
            int result = this._authenticate(ldapServerConfiguration.ldapServerId(), companyId, emailAddress, screenName, userId, password);
            if (result != 1) continue;
            if (ldapImportConfiguration.importUserPasswordEnabled()) {
                return result;
            }
            return 2;
        }
        return this._authenticateRequired(companyId, userId, emailAddress, screenName, true, -1);
    }

    private int _authenticateAgainstPreferredLDAPServer(long companyId, long ldapServerId, String emailAddress, String screenName, long userId, String password) throws Exception {
        if (ldapServerId < 0L) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"No preferred LDAP server ID provided");
            }
            return 0;
        }
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        if (Validator.isNull((String)ldapServerConfiguration.baseProviderURL())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Base provider URL is not set");
            }
            return 0;
        }
        if (ldapServerConfiguration.ldapServerId() != ldapServerId) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"LDAP server ", ldapServerId, " is invalid because company ", companyId, " uses ", ldapServerConfiguration.ldapServerId()}));
            }
            return 0;
        }
        return this._authenticate(ldapServerId, companyId, emailAddress, screenName, userId, password);
    }

    private int _authenticateOmniadmin(long companyId, String emailAddress, String screenName, long userId) throws Exception {
        User user;
        if (!this._authPipelineEnableLiferayCheck) {
            return -1;
        }
        if (userId > 0L ? this._omniadmin.isOmniadmin(userId) : (Validator.isNotNull((String)emailAddress) ? (user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress)) != null && this._omniadmin.isOmniadmin(user) : Validator.isNotNull((String)screenName) && (user = this._userLocalService.fetchUserByScreenName(companyId, screenName)) != null && this._omniadmin.isOmniadmin(user))) {
            return 1;
        }
        return -1;
    }

    private int _authenticateRequired(long companyId, long userId, String emailAddress, String screenName, boolean allowOmniadmin, int failureCode) throws Exception {
        int code;
        if (allowOmniadmin && (code = this._authenticateOmniadmin(companyId, emailAddress, screenName, userId)) == 1) {
            return 1;
        }
        LDAPAuthConfiguration ldapAuthConfiguration = (LDAPAuthConfiguration)this._ldapAuthConfigurationProvider.getConfiguration(companyId);
        if (ldapAuthConfiguration.required()) {
            return failureCode;
        }
        return 1;
    }

    private LDAPAuthResult _getFailedLDAPAuthResult(Map<String, Object> env) {
        Map<String, LDAPAuthResult> failedLDAPAuthResults = this._failedLDAPAuthResults.get();
        String cacheKey = this._getKey(env);
        return failedLDAPAuthResults.get(cacheKey);
    }

    private String _getKey(Map<String, Object> env) {
        return StringBundler.concat((String[])new String[]{MapUtil.getString(env, (String)"java.naming.provider.url"), "#", MapUtil.getString(env, (String)"java.naming.security.principal"), "#", MapUtil.getString(env, (String)"java.naming.security.credentials")});
    }

    private long _getPreferredLDAPServer(long companyId, String emailAddress, String screenName, long userId) throws Exception {
        User user = null;
        if (userId > 0L) {
            user = this._userLocalService.fetchUserById(userId);
        } else if (Validator.isNotNull((String)emailAddress)) {
            user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress);
        } else if (Validator.isNotNull((String)screenName)) {
            user = this._userLocalService.fetchUserByScreenName(companyId, screenName);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get preferred LDAP server");
            }
            return -1L;
        }
        if (user == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get user " + userId));
            }
            return -1L;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Using LDAP server ", user.getLdapServerId(), " to authenticate user ", userId}));
        }
        return user.getLdapServerId();
    }

    private String _removeEncryptionAlgorithm(String ldapPassword) {
        int x;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Removing encryption algorithm");
        }
        if ((x = ldapPassword.indexOf("{")) == -1) {
            return ldapPassword;
        }
        int y = ldapPassword.indexOf("}", x);
        if (y == -1) {
            return ldapPassword;
        }
        return ldapPassword.substring(y + 1);
    }

    private void _setFailedLDAPAuthResult(Map<String, Object> env, LDAPAuthResult ldapAuthResult) {
        String cacheKey;
        Map<String, LDAPAuthResult> failedLDAPAuthResults = this._failedLDAPAuthResults.get();
        if (failedLDAPAuthResults.containsKey(cacheKey = this._getKey(env))) {
            return;
        }
        failedLDAPAuthResults.put(cacheKey, ldapAuthResult);
    }
}

