/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.configuration.persistence.listener;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import java.util.Dictionary;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"model.class.name=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration"}, service={ConfigurationModelListener.class, UserImportConfigurationModelListener.class})
public class UserImportConfigurationModelListener
extends BaseMessageListener
implements ConfigurationModelListener {
    private static final Log _log = LogFactoryUtil.getLog(UserImportConfigurationModelListener.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(destination.name=liferay/scheduled_user_ldap_import)")
    private Destination _destination;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)")
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile LDAPUserImporter _ldapUserImporter;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    public void onAfterSave(String pid, Dictionary<String, Object> properties) {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)ConfigurableUtil.createConfigurable(LDAPImportConfiguration.class, properties);
        if (ldapImportConfiguration.companyId() == 0L) {
            this._updateDefaultImportInterval(ldapImportConfiguration.importInterval());
        }
    }

    @Activate
    protected void activate() {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(0L);
        this._updateDefaultImportInterval(ldapImportConfiguration.importInterval());
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        long time = this._getLastImportTime();
        this._companyLocalService.forEachCompanyId(companyId -> this._importUsers((long)companyId, time));
    }

    protected void doReceive(Message message, long companyId) throws Exception {
        this._importUsers(companyId, this._getLastImportTime());
    }

    private long _getLastImportTime() throws Exception {
        long time = System.currentTimeMillis() - this._ldapUserImporter.getLastImportTime();
        return Math.round((double)time / 60000.0);
    }

    private void _importUsers(long companyId, long time) throws Exception {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        if (!ldapImportConfiguration.importEnabled()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping LDAP user import for company " + companyId + " because LDAP import is disabled"));
            }
            return;
        }
        if (ldapImportConfiguration.importInterval() <= 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping LDAP user import for company " + companyId + " because LDAP import interval is less than 1"));
            }
            return;
        }
        if (time < (long)ldapImportConfiguration.importInterval()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping LDAP user import for company ", companyId, " because LDAP import interval has not been ", "reached"}));
            }
            return;
        }
        this._ldapUserImporter.importUsers(companyId);
    }

    private void _updateDefaultImportInterval(int interval) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("LDAP user imports will be attempted every " + interval + " minutes"));
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, interval, TimeUnit.MINUTE);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduled_user_ldap_import");
    }
}

