/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.exportimport;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.expando.kernel.util.ExpandoConverterUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.exception.GroupFriendlyURLException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.NoSuchUserGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.exportimport.UserGroupImportTransactionThreadLocal;
import com.liferay.portal.kernel.security.ldap.AttributesTransformer;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserImporter;
import com.liferay.portal.security.ldap.SafeLdapContext;
import com.liferay.portal.security.ldap.SafeLdapFilter;
import com.liferay.portal.security.ldap.SafeLdapFilterConstraints;
import com.liferay.portal.security.ldap.SafeLdapFilterFactory;
import com.liferay.portal.security.ldap.SafeLdapFilterTemplate;
import com.liferay.portal.security.ldap.SafeLdapName;
import com.liferay.portal.security.ldap.SafeLdapNameFactory;
import com.liferay.portal.security.ldap.SafePortalLDAP;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.exportimport.LDAPGroup;
import com.liferay.portal.security.ldap.exportimport.LDAPToPortalConverter;
import com.liferay.portal.security.ldap.exportimport.LDAPUser;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import com.liferay.portal.security.ldap.internal.exportimport.LDAPImportContext;
import com.liferay.portal.security.ldap.internal.validator.SafeLdapContextImpl;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import com.liferay.portal.security.ldap.validator.LDAPFilterException;
import com.liferay.portal.security.ldap.validator.LDAPFilterValidator;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={LDAPUserImporter.class, UserImporter.class})
public class LDAPUserImporterImpl
implements LDAPUserImporter,
UserImporter {
    private static final String[] _CONTACT_PROPERTY_NAMES = new String[]{"birthday", "employeeNumber", "facebookSn", "jabberSn", "male", "prefixListTypeId", "skypeSn", "smsSn", "suffixListTypeId", "twitterSn"};
    private static final String _IMPORT_BY_GROUP = "group";
    private static final String _IMPORT_BY_USER = "user";
    private static final String _USER_PASSWORD_SCREEN_NAME = "screenName";
    private static final String[] _USER_PROPERTY_NAMES = new String[]{"comments", "emailAddress", "firstName", "greeting", "jobTitle", "languageId", "lastName", "middleName", "openId", "portraitId", "timeZoneId", "status"};
    private static final String _USER_SYNC_STRATEGY_UUID = "uuid";
    private static final Log _log = LogFactoryUtil.getLog(LDAPUserImporterImpl.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile AttributesTransformer _attributesTransformer;
    @Reference
    private BeanProperties _beanProperties;
    @Reference
    private CompanyLocalService _companyLocalService;
    private String _companySecurityAuthType;
    @Reference
    private ExpandoValueLocalService _expandoValueLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private long _lastImportTime;
    @Reference
    private LDAPFilterValidator _ldapFilterValidator;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)")
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)")
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    @Reference
    private LDAPSettings _ldapSettings;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile LDAPToPortalConverter _ldapToPortalConverter;
    @Reference
    private LockManager _lockManager;
    private PortalCache<String, Long> _portalCache;
    @Reference
    private Props _props;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile SafePortalLDAP _safePortalLDAP;
    @Reference
    private SingleVMPool _singleVMPool;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public long getLastImportTime() {
        return this._lastImportTime;
    }

    @Deprecated
    public User importUser(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, String password) throws Exception {
        return this.importUser(ldapServerId, companyId, new SafeLdapContextImpl(ldapContext), attributes, password);
    }

    public User importUser(long ldapServerId, long companyId, SafeLdapContext safeLdapContext, Attributes attributes, String password) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        if (ldapServerConfiguration.ldapServerId() != ldapServerId) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"LDAP server ", ldapServerId, " is invalid because company ", companyId, " uses ", ldapServerConfiguration.ldapServerId()}));
            }
            return null;
        }
        LDAPImportContext ldapImportContext = this._getLDAPImportContext(companyId, this._ldapSettings.getContactExpandoMappings(ldapServerId, companyId), this._ldapSettings.getContactMappings(ldapServerId, companyId), this._ldapSettings.getGroupMappings(ldapServerId, companyId), safeLdapContext, ldapServerId, new HashSet<String>(Arrays.asList(ldapServerConfiguration.userIgnoreAttributes())), this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId), this._ldapSettings.getUserMappings(ldapServerId, companyId));
        User user = this.importUser(ldapImportContext, "", attributes, password);
        this._importGroups(ldapImportContext, attributes, user);
        return user;
    }

    public User importUser(long ldapServerId, long companyId, String emailAddress, String screenName) throws Exception {
        SafeLdapContext safeLdapContext = null;
        NamingEnumeration enumeration = null;
        try {
            LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
            safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapServerId, companyId);
            if (safeLdapContext == null) {
                _log.error((Object)"Unable to bind to the LDAP server");
                User user = null;
                return user;
            }
            if (ldapServerConfiguration.ldapServerId() != ldapServerId) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"LDAP server ID ", ldapServerId, " is no longer valid, company ", companyId, " now uses ", ldapServerConfiguration.ldapServerId()}));
                }
                User user = null;
                return user;
            }
            SafeLdapFilterTemplate authSearchSafeLdapFilterTemplate = LDAPUtil.getAuthSearchSafeLdapFilterTemplate((LDAPServerConfiguration)ldapServerConfiguration, (LDAPFilterValidator)this._ldapFilterValidator);
            if (authSearchSafeLdapFilterTemplate == null) {
                _log.error((Object)"Missing authSearchFilter");
                User user = null;
                return user;
            }
            authSearchSafeLdapFilterTemplate = authSearchSafeLdapFilterTemplate.replace(new String[]{"@company_id@", "@email_address@", "@screen_name@"}, new String[]{String.valueOf(companyId), emailAddress, screenName});
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty(_USER_PASSWORD_SCREEN_NAME));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            enumeration = safeLdapContext.search(LDAPUtil.getBaseDNSafeLdapName((LDAPServerConfiguration)ldapServerConfiguration), (SafeLdapFilter)authSearchSafeLdapFilterTemplate, searchControls);
            if (enumeration.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                Binding binding = (Binding)enumeration.nextElement();
                Attributes attributes = this._safePortalLDAP.getUserAttributes(ldapServerId, companyId, safeLdapContext, SafeLdapNameFactory.from((Binding)binding));
                User user = this.importUser(ldapServerId, companyId, safeLdapContext, attributes, null);
                return user;
            }
            User user = null;
            return user;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Problem accessing LDAP server " + exception.getMessage()));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new SystemException("Problem accessing LDAP server " + exception.getMessage());
        }
        finally {
            if (enumeration != null) {
                enumeration.close();
            }
            if (safeLdapContext != null) {
                safeLdapContext.close();
            }
        }
    }

    public User importUser(long companyId, String emailAddress, String screenName) throws Exception {
        List ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
        for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
            if (Validator.isNull((String)ldapServerConfiguration.baseProviderURL())) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No provider URL defined in " + ldapServerConfiguration));
                continue;
            }
            User user = this.importUser(ldapServerConfiguration.ldapServerId(), companyId, emailAddress, screenName);
            if (user == null) continue;
            return user;
        }
        if (_log.isDebugEnabled()) {
            if (Validator.isNotNull((String)emailAddress)) {
                _log.debug((Object)("User with the email address " + emailAddress + " was not found in any LDAP servers"));
            } else {
                _log.debug((Object)("User with the screen name " + screenName + " was not found in any LDAP servers"));
            }
        }
        return null;
    }

    public User importUserByScreenName(long companyId, String screenName) throws Exception {
        long ldapServerId = this._safePortalLDAP.getLdapServerId(companyId, screenName, "");
        SearchResult result = (SearchResult)this._safePortalLDAP.getUser(ldapServerId, companyId, screenName, "");
        if (result == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user was found in LDAP with screenName " + screenName));
            }
            return null;
        }
        SafeLdapContext safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapServerId, companyId);
        SafeLdapName fullUserDNSafeLdapName = SafeLdapNameFactory.from((Binding)result);
        Attributes attributes = this._safePortalLDAP.getUserAttributes(ldapServerId, companyId, safeLdapContext, fullUserDNSafeLdapName);
        User user = this.importUser(ldapServerId, companyId, safeLdapContext, attributes, null);
        safeLdapContext.close();
        return user;
    }

    public User importUserByUuid(long ldapServerId, long companyId, String uuid) throws Exception {
        Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
        String attributeName = GetterUtil.getString((String)userMappings.getProperty(_USER_SYNC_STRATEGY_UUID));
        if (Validator.isBlank((String)attributeName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("User field UUID is not mapped for LDAP server " + ldapServerId));
            }
            return null;
        }
        return this._importUserByLdapAttribute(ldapServerId, companyId, attributeName, uuid);
    }

    public User importUserByUuid(long companyId, String uuid) throws Exception {
        List ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
        for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
            if (Validator.isNull((String)ldapServerConfiguration.baseProviderURL())) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No provider URL defined in " + ldapServerConfiguration));
                continue;
            }
            User user = this.importUserByUuid(ldapServerConfiguration.ldapServerId(), companyId, uuid);
            if (user == null) continue;
            return user;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("User with UUID " + uuid + " was not found in any LDAP servers"));
        }
        return null;
    }

    public void importUsers() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> this.importUsers((long)companyId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUsers(long companyId) throws Exception {
        if (!this._ldapSettings.isImportEnabled(companyId)) {
            return;
        }
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        try {
            long userId = this._userLocalService.getDefaultUserId(companyId);
            Lock lock = this._lockManager.lock(userId, UserImporter.class.getName(), companyId, LDAPUserImporterImpl.class.getName(), false, ldapImportConfiguration.importLockExpirationTime(), false);
            if (!lock.isNew()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping LDAP import for company ", companyId, " because another LDAP import is in process by ", "the same user ", userId}));
                }
                return;
            }
        }
        catch (DuplicateLockException duplicateLockException) {
            if (_log.isDebugEnabled()) {
                Lock lock = duplicateLockException.getLock();
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping LDAP import for company ", companyId, " because another LDAP import is in process by ", "another user ", lock.getUserId()}));
            }
            return;
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping LDAP import for company " + companyId + " because unable to lock the lock"), throwable);
            }
            return;
        }
        try {
            List ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
            for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
                this.importUsers(ldapServerConfiguration.ldapServerId(), companyId);
            }
        }
        finally {
            this._lockManager.unlock(UserImporter.class.getName(), companyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUsers(long ldapServerId, long companyId) throws Exception {
        if (!this._ldapSettings.isImportEnabled(companyId)) {
            return;
        }
        SafeLdapContext safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapServerId, companyId);
        if (safeLdapContext == null) {
            return;
        }
        this._lastImportTime = System.currentTimeMillis();
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        if (ldapServerConfiguration.ldapServerId() != ldapServerId) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"LDAP server ID ", ldapServerId, " is no longer valid, company ", companyId, " now uses ", ldapServerConfiguration.ldapServerId()}));
            }
            return;
        }
        String[] userIgnoreAttributes = ldapServerConfiguration.userIgnoreAttributes();
        HashSet<String> ldapUserIgnoreAttributes = new HashSet<String>(Arrays.asList(userIgnoreAttributes));
        try {
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            Properties userExpandoMappings = this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId);
            Properties contactMappings = this._ldapSettings.getContactMappings(ldapServerId, companyId);
            Properties contactExpandoMappings = this._ldapSettings.getContactExpandoMappings(ldapServerId, companyId);
            Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, companyId);
            String importMethod = ldapImportConfiguration.importMethod();
            LDAPImportContext ldapImportContext = this._getLDAPImportContext(companyId, contactExpandoMappings, contactMappings, groupMappings, safeLdapContext, ldapServerId, ldapUserIgnoreAttributes, userExpandoMappings, userMappings);
            if (importMethod.equals(_IMPORT_BY_GROUP)) {
                this._importFromLDAPByGroup(ldapImportContext);
            } else if (importMethod.equals(_IMPORT_BY_USER)) {
                this._importFromLDAPByUser(ldapImportContext);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to import LDAP users and groups", (Throwable)exception);
        }
        finally {
            safeLdapContext.close();
        }
    }

    @Activate
    protected void activate() {
        this._companySecurityAuthType = GetterUtil.getString((String)this._props.get("company.security.auth.type"));
        this._portalCache = this._singleVMPool.getPortalCache(UserImporter.class.getName());
    }

    protected User addUser(long companyId, LDAPUser ldapUser, String password) throws Exception {
        byte[] portraitBytes;
        StopWatch stopWatch = new StopWatch();
        if (_log.isDebugEnabled()) {
            stopWatch.start();
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Adding LDAP user ", ldapUser, " to company ", companyId}));
        }
        boolean autoPassword = ldapUser.isAutoPassword();
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        if (!ldapImportConfiguration.importUserPasswordEnabled() && !(autoPassword = ldapImportConfiguration.importUserPasswordAutogenerated())) {
            String defaultPassword = ldapImportConfiguration.importUserPasswordDefault();
            if (StringUtil.equalsIgnoreCase((String)defaultPassword, (String)_USER_PASSWORD_SCREEN_NAME)) {
                defaultPassword = ldapUser.getScreenName();
            }
            password = defaultPassword;
        }
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(ldapUser.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        User user = this._userLocalService.addUser(ldapUser.getCreatorUserId(), companyId, autoPassword, password, password, ldapUser.isAutoScreenName(), ldapUser.getScreenName(), ldapUser.getEmailAddress(), ldapUser.getLocale(), ldapUser.getFirstName(), ldapUser.getMiddleName(), ldapUser.getLastName(), 0L, 0L, ldapUser.isMale(), birthdayMonth, birthdayDay, birthdayYear, "", ldapUser.getGroupIds(), ldapUser.getOrganizationIds(), ldapUser.getRoleIds(), ldapUser.getUserGroupIds(), ldapUser.isSendEmail(), ldapUser.getServiceContext());
        this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        if (ldapUser.isUpdatePortrait() && ArrayUtil.isNotEmpty((byte[])(portraitBytes = ldapUser.getPortraitBytes()))) {
            user = this._userLocalService.updatePortrait(user.getUserId(), portraitBytes);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished adding LDAP user ", ldapUser, " as user ", user, " in ", stopWatch.getTime(), "ms"}));
        }
        return user;
    }

    protected String escapeLDAPName(String ldapName) {
        return StringUtil.replace((String)ldapName, (char)'\\', (String)"\\\\");
    }

    protected User getUser(long companyId, LDAPUser ldapUser) throws Exception {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        if (Objects.equals(ldapImportConfiguration.importUserSyncStrategy(), _USER_SYNC_STRATEGY_UUID)) {
            ServiceContext serviceContext = ldapUser.getServiceContext();
            return this._userLocalService.fetchUserByUuidAndCompanyId(serviceContext.getUuidWithoutReset(), companyId);
        }
        String authType = PrefsPropsUtil.getString((long)companyId, (String)"company.security.auth.type", (String)this._companySecurityAuthType);
        if (authType.equals(_USER_PASSWORD_SCREEN_NAME) && !ldapUser.isAutoScreenName()) {
            return this._userLocalService.fetchUserByScreenName(companyId, ldapUser.getScreenName());
        }
        return this._userLocalService.fetchUserByEmailAddress(companyId, ldapUser.getEmailAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User importUser(LDAPImportContext ldapImportContext, String fullUserDN, Attributes userLdapAttributes, String password) throws Exception {
        UserImportTransactionThreadLocal.setOriginatesFromImport(true);
        try {
            userLdapAttributes = this._attributesTransformer.transformUser(userLdapAttributes);
            LDAPUser ldapUser = this._ldapToPortalConverter.importLDAPUser(ldapImportContext.getCompanyId(), userLdapAttributes, ldapImportContext.getUserMappings(), ldapImportContext.getUserExpandoMappings(), ldapImportContext.getContactMappings(), ldapImportContext.getContactExpandoMappings(), password);
            User user = this.getUser(ldapImportContext.getCompanyId(), ldapUser);
            if (user != null && user.isDefaultUser()) {
                User user2 = user;
                return user2;
            }
            ServiceContext serviceContext = ldapUser.getServiceContext();
            serviceContext.setAttribute("ldapServerId", (Serializable)Long.valueOf(ldapImportContext.getLdapServerId()));
            boolean isNew = false;
            if (user == null) {
                user = this.addUser(ldapImportContext.getCompanyId(), ldapUser, password);
                isNew = true;
            }
            String modifyTimestamp = LDAPUtil.getAttributeString((Attributes)userLdapAttributes, (String)"modifyTimestamp");
            try {
                user = this._updateUser(ldapImportContext, ldapUser, user, password, modifyTimestamp, isNew);
                ldapImportContext.addImportedUserId(fullUserDN, user.getUserId());
            }
            catch (GroupFriendlyURLException groupFriendlyURLException) {
                int type = groupFriendlyURLException.getType();
                if (type == 6) {
                    _log.error((Object)("Unable to import user " + user.getUserId() + " because of a duplicate group friendly URL"), (Throwable)groupFriendlyURLException);
                } else {
                    _log.error((Object)("Unable to import user " + user.getUserId()), (Throwable)groupFriendlyURLException);
                }
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to import user " + user.getUserId()), (Throwable)exception);
            }
            User user3 = user;
            return user3;
        }
        finally {
            UserImportTransactionThreadLocal.setOriginatesFromImport(false);
        }
    }

    protected void importUsers(LDAPImportContext ldapImportContext, long userGroupId, Attribute usersLdapAttribute) throws Exception {
        int size = 0;
        if (usersLdapAttribute != null) {
            size = usersLdapAttribute.size();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Importing ", size, " users from LDAP server ", ldapImportContext.getLdapServerId(), " to company ", ldapImportContext.getCompanyId()}));
        }
        LinkedHashSet<Long> newUserIds = new LinkedHashSet<Long>();
        for (int i = 0; i < size; ++i) {
            String fullUserDN = (String)usersLdapAttribute.get(i);
            Long userId = ldapImportContext.getImportedUserId(fullUserDN);
            if (userId != null) {
                newUserIds.add(userId);
                continue;
            }
            Attributes userAttributes = null;
            try {
                userAttributes = this._safePortalLDAP.getUserAttributes(ldapImportContext.getLdapServerId(), ldapImportContext.getCompanyId(), ldapImportContext.getSafeLdapContext(), SafeLdapNameFactory.from((Attribute)usersLdapAttribute, (int)i));
            }
            catch (NameNotFoundException nameNotFoundException) {
                _log.error((Object)("LDAP user not found with fullUserDN " + fullUserDN), (Throwable)nameNotFoundException);
                continue;
            }
            try {
                User user = this.importUser(ldapImportContext, fullUserDN, userAttributes, null);
                if (user == null) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Adding user ", user, " to user group ", userGroupId}));
                }
                newUserIds.add(user.getUserId());
                continue;
            }
            catch (GroupFriendlyURLException groupFriendlyURLException) {
                int type = groupFriendlyURLException.getType();
                if (type == 6) {
                    _log.error((Object)("Unable to import user " + userAttributes + " because of a duplicate group friendly URL"), (Throwable)groupFriendlyURLException);
                    continue;
                }
                _log.error((Object)("Unable to import user " + userAttributes), (Throwable)groupFriendlyURLException);
                continue;
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to load user " + userAttributes), (Throwable)exception);
            }
        }
        LinkedHashSet<Long> deletedUserIds = new LinkedHashSet<Long>();
        List userGroupUsers = this._userLocalService.getUserGroupUsers(userGroupId);
        for (User user : userGroupUsers) {
            if (ldapImportContext.getLdapServerId() != user.getLdapServerId() || newUserIds.contains(user.getUserId())) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Removing user ", user, " from user group ", userGroupId}));
            }
            deletedUserIds.add(user.getUserId());
        }
        this._userLocalService.addUserGroupUsers(userGroupId, ArrayUtil.toLongArray(newUserIds));
        this._userLocalService.deleteUserGroupUsers(userGroupId, ArrayUtil.toLongArray(deletedUserIds));
    }

    private void _addRole(long companyId, LDAPGroup ldapGroup, UserGroup userGroup) throws Exception {
        Role role;
        block5: {
            Company company = this._companyLocalService.getCompany(companyId);
            LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
            if (!ldapImportConfiguration.importCreateRolePerGroup()) {
                return;
            }
            role = null;
            try {
                role = this._roleLocalService.getRole(companyId, ldapGroup.getGroupName());
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchRoleException);
                }
                User defaultUser = this._userLocalService.getDefaultUser(companyId);
                role = this._roleLocalService.addRole(defaultUser.getUserId(), null, 0L, ldapGroup.getGroupName(), null, (Map)HashMapBuilder.put((Object)company.getLocale(), (Object)"Autogenerated role from LDAP import").build(), 1, null, null);
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)("Imported autogenerated role from LDAP import: " + role));
            }
        }
        Group group = userGroup.getGroup();
        if (this._groupLocalService.hasRoleGroup(role.getRoleId(), group.getGroupId())) {
            return;
        }
        this._groupLocalService.addRoleGroups(role.getRoleId(), new long[]{group.getGroupId()});
    }

    private void _addUserGroupsNotBelongingToLDAPServer(long userId, Set<Long> ldapServerGroupIds, Set<Long> userGroupIds) throws Exception {
        List userGroups = this._userGroupLocalService.getUserUserGroups(userId);
        for (UserGroup userGroup : userGroups) {
            if (ldapServerGroupIds.contains(userGroup.getUserGroupId())) continue;
            userGroupIds.add(userGroup.getUserGroupId());
        }
    }

    private LDAPImportContext _getLDAPImportContext(long companyId, Properties contactExpandoMappings, Properties contactMappings, Properties groupMappings, SafeLdapContext safeLdapContext, long ldapServerId, Set<String> ldapUserIgnoreAttributes, Properties userExpandoMappings, Properties userMappings) {
        return new LDAPImportContext(companyId, contactExpandoMappings, contactMappings, groupMappings, safeLdapContext, ldapServerId, ldapUserIgnoreAttributes, userExpandoMappings, userMappings);
    }

    private Attribute _getUsers(LDAPImportContext ldapImportContext, Attributes groupAttributes, UserGroup userGroup) throws Exception {
        Properties groupMappings = ldapImportContext.getGroupMappings();
        Attribute attribute = groupAttributes.get(groupMappings.getProperty(_IMPORT_BY_USER));
        if (attribute == null) {
            return null;
        }
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(ldapImportContext.getCompanyId(), ldapImportContext.getLdapServerId());
        if (ldapServerConfiguration.ldapServerId() != ldapImportContext.getLdapServerId()) {
            return null;
        }
        SafeLdapFilter safeLdapFilter = SafeLdapFilterConstraints.eq((String)groupMappings.getProperty("groupName"), (Object)userGroup.getName());
        SafeLdapFilter groupSearchSafeLdapFilter = LDAPUtil.getGroupSearchSafeLdapFilter((LDAPServerConfiguration)ldapServerConfiguration, (LDAPFilterValidator)this._ldapFilterValidator);
        if (groupSearchSafeLdapFilter != null) {
            safeLdapFilter = safeLdapFilter.and(new SafeLdapFilter[]{groupSearchSafeLdapFilter});
        }
        return this._safePortalLDAP.getMultivaluedAttribute(ldapImportContext.getCompanyId(), ldapImportContext.getSafeLdapContext(), LDAPUtil.getBaseDNSafeLdapName((LDAPServerConfiguration)ldapServerConfiguration), safeLdapFilter, attribute);
    }

    private void _importFromLDAPByGroup(LDAPImportContext ldapImportContext) throws Exception {
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList searchResults = new ArrayList();
            Properties groupMappings = ldapImportContext.getGroupMappings();
            String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName"));
            groupMappingsGroupName = StringUtil.toLowerCase((String)groupMappingsGroupName);
            cookie = this._safePortalLDAP.getGroups(ldapImportContext.getLdapServerId(), ldapImportContext.getCompanyId(), ldapImportContext.getSafeLdapContext(), cookie, 0, new String[]{groupMappingsGroupName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                try {
                    Attributes groupAttributes = this._safePortalLDAP.getGroupAttributes(ldapImportContext.getLdapServerId(), ldapImportContext.getCompanyId(), ldapImportContext.getSafeLdapContext(), SafeLdapNameFactory.from((Binding)searchResult), true);
                    UserGroup userGroup = this._importUserGroup(ldapImportContext.getCompanyId(), groupAttributes, groupMappings);
                    Attribute usersAttribute = this._getUsers(ldapImportContext, groupAttributes, userGroup);
                    if (usersAttribute == null && _log.isInfoEnabled()) {
                        _log.info((Object)("No users found in " + userGroup.getName()));
                    }
                    this.importUsers(ldapImportContext, userGroup.getUserGroupId(), usersAttribute);
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to import group " + searchResult), (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _importFromLDAPByUser(LDAPImportContext ldapImportContext) throws Exception {
        try (SafeLdapContext safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapImportContext.getLdapServerId(), ldapImportContext.getCompanyId());){
            byte[] cookie = new byte[]{};
            while (cookie != null) {
                ArrayList searchResults = new ArrayList();
                Properties userMappings = ldapImportContext.getUserMappings();
                String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty(_USER_PASSWORD_SCREEN_NAME));
                userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
                cookie = this._safePortalLDAP.getUsers(ldapImportContext.getLdapServerId(), ldapImportContext.getCompanyId(), safeLdapContext, cookie, 0, new String[]{userMappingsScreenName}, searchResults);
                for (SearchResult searchResult : searchResults) {
                    String fullUserDN = searchResult.getNameInNamespace();
                    if (ldapImportContext.containsImportedUser(fullUserDN)) continue;
                    try {
                        Attributes userAttributes = this._safePortalLDAP.getUserAttributes(ldapImportContext.getLdapServerId(), ldapImportContext.getCompanyId(), ldapImportContext.getSafeLdapContext(), SafeLdapNameFactory.from((Binding)searchResult));
                        User user = this.importUser(ldapImportContext, fullUserDN, userAttributes, null);
                        this._importGroups(ldapImportContext, userAttributes, user);
                    }
                    catch (GroupFriendlyURLException groupFriendlyURLException) {
                        int type = groupFriendlyURLException.getType();
                        if (type == 6) {
                            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to import user ", fullUserDN, " because of a duplicate group friendly ", "URL"}), (Throwable)groupFriendlyURLException);
                            continue;
                        }
                        _log.error((Object)("Unable to import user " + fullUserDN), (Throwable)groupFriendlyURLException);
                    }
                    catch (Exception exception) {
                        _log.error((Object)("Unable to import user " + fullUserDN), (Throwable)exception);
                    }
                }
            }
        }
    }

    private UserGroup _importGroup(LDAPImportContext ldapImportContext, SafeLdapName userGroupDNSafeLdapName) throws Exception {
        Long userGroupId = null;
        String userGroupIdKey = null;
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(ldapImportContext.getCompanyId());
        if (ldapImportConfiguration.importGroupCacheEnabled()) {
            userGroupIdKey = StringBundler.concat((Object[])new Object[]{ldapImportContext.getLdapServerId(), "_", ldapImportContext.getCompanyId(), "_", userGroupDNSafeLdapName});
            userGroupId = (Long)this._portalCache.get((Serializable)((Object)userGroupIdKey));
        }
        if (userGroupId != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping reimport of full group DN " + userGroupDNSafeLdapName));
            }
            return this._userGroupLocalService.fetchUserGroup(userGroupId.longValue());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing full group DN " + userGroupDNSafeLdapName));
        }
        Attributes groupAttributes = null;
        try {
            groupAttributes = this._safePortalLDAP.getGroupAttributes(ldapImportContext.getLdapServerId(), ldapImportContext.getCompanyId(), ldapImportContext.getSafeLdapContext(), userGroupDNSafeLdapName);
        }
        catch (NameNotFoundException nameNotFoundException) {
            _log.error((Object)("LDAP group not found with full group DN " + userGroupDNSafeLdapName), (Throwable)nameNotFoundException);
        }
        UserGroup userGroup = this._importUserGroup(ldapImportContext.getCompanyId(), groupAttributes, ldapImportContext.getGroupMappings());
        if (userGroup == null) {
            return null;
        }
        if (ldapImportConfiguration.importGroupCacheEnabled()) {
            this._portalCache.put((Serializable)((Object)userGroupIdKey), (Object)userGroup.getUserGroupId());
        }
        return userGroup;
    }

    private void _importGroups(LDAPImportContext ldapImportContext, Attributes userAttributes, User user) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(ldapImportContext.getCompanyId(), ldapImportContext.getLdapServerId());
        if (ldapServerConfiguration.ldapServerId() != ldapImportContext.getLdapServerId()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"LDAP server ID ", ldapImportContext.getLdapServerId(), " is no longer valid, company ", ldapImportContext.getCompanyId(), " now uses ", ldapServerConfiguration.ldapServerId()}));
            }
            return;
        }
        Properties userMappings = ldapImportContext.getUserMappings();
        String userMappingsGroup = userMappings.getProperty(_IMPORT_BY_GROUP);
        if (Validator.isNull((String)userMappingsGroup)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Skipping group import because no mappings for LDAP groups were specified in user mappings " + userMappings));
            }
            return;
        }
        List userGroupAttributes = Collections.emptyList();
        Attribute userGroupAttribute = userAttributes.get(userMappingsGroup);
        if (userGroupAttribute != null) {
            userGroupAttributes = new ArrayList(userGroupAttribute.size());
            for (int i = 0; i < userGroupAttribute.size(); ++i) {
                Object object = userGroupAttribute.get(i);
                userGroupAttributes.add(StringUtil.lowerCase((String)object.toString()));
            }
        }
        Properties groupMappings = ldapImportContext.getGroupMappings();
        LinkedHashSet<Long> ldapServerGroupIds = new LinkedHashSet<Long>();
        LinkedHashSet<Long> newUserGroupIds = new LinkedHashSet<Long>();
        String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName"));
        groupMappingsGroupName = StringUtil.toLowerCase((String)groupMappingsGroupName);
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList searchResults = new ArrayList();
            cookie = this._safePortalLDAP.getGroups(ldapImportContext.getLdapServerId(), ldapImportContext.getCompanyId(), ldapImportContext.getSafeLdapContext(), cookie, 0, new String[]{groupMappingsGroupName}, searchResults);
            for (Object searchResult : searchResults) {
                SafeLdapName userGroupSafeLdapName = SafeLdapNameFactory.from((Binding)searchResult);
                UserGroup userGroup = this._importGroup(ldapImportContext, userGroupSafeLdapName);
                if (userGroup == null) continue;
                ldapServerGroupIds.add(userGroup.getUserGroupId());
                if (!userGroupAttributes.contains(StringUtil.lowerCase((String)((NameClassPair)searchResult).getNameInNamespace()))) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Adding user ", user, " to user group ", userGroup.getUserGroupId()}));
                }
                newUserGroupIds.add(userGroup.getUserGroupId());
            }
        }
        this._addUserGroupsNotBelongingToLDAPServer(user.getUserId(), ldapServerGroupIds, newUserGroupIds);
        LinkedHashSet<Long> oldUserGroupIds = new LinkedHashSet<Long>();
        List oldUserGroups = this._userGroupLocalService.getUserUserGroups(user.getUserId());
        for (UserGroup oldUserGroup : oldUserGroups) {
            oldUserGroupIds.add(oldUserGroup.getUserGroupId());
        }
        if (!oldUserGroupIds.equals(newUserGroupIds)) {
            long[] userGroupIds = ArrayUtil.toLongArray(newUserGroupIds);
            this._userGroupLocalService.setUserUserGroups(user.getUserId(), userGroupIds);
        }
    }

    private User _importUserByLdapAttribute(long ldapServerId, long companyId, String attributeName, String attributeValue) throws Exception {
        SafeLdapContext safeLdapContext = null;
        NamingEnumeration enumeration = null;
        try {
            LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
            safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapServerId, companyId);
            if (safeLdapContext == null) {
                _log.error((Object)"Unable to bind to the LDAP server");
                User user = null;
                return user;
            }
            if (ldapServerConfiguration.ldapServerId() != ldapServerId) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"LDAP server ID ", ldapServerId, " is no longer valid, company ", companyId, " now uses ", ldapServerConfiguration.ldapServerId()}));
                }
                User user = null;
                return user;
            }
            SafeLdapFilter safeLdapFilter = null;
            try {
                safeLdapFilter = SafeLdapFilterFactory.fromUnsafeFilter((String)ldapServerConfiguration.userSearchFilter(), (LDAPFilterValidator)this._ldapFilterValidator);
            }
            catch (LDAPFilterException ldapFilterException) {
                throw new LDAPFilterException("Invalid user search filter: ", (Throwable)ldapFilterException);
            }
            safeLdapFilter = safeLdapFilter.and(new SafeLdapFilter[]{SafeLdapFilterConstraints.eq((String)attributeName, (Object)attributeValue)});
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty(_USER_PASSWORD_SCREEN_NAME));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            enumeration = safeLdapContext.search(LDAPUtil.getBaseDNSafeLdapName((LDAPServerConfiguration)ldapServerConfiguration), safeLdapFilter, searchControls);
            if (enumeration.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                Binding binding = (Binding)enumeration.nextElement();
                Attributes attributes = this._safePortalLDAP.getUserAttributes(ldapServerId, companyId, safeLdapContext, SafeLdapNameFactory.from((Binding)binding));
                User user = this.importUser(ldapServerId, companyId, safeLdapContext, attributes, null);
                return user;
            }
            User user = null;
            return user;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Problem accessing LDAP server " + exception.getMessage()));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new SystemException("Problem accessing LDAP server " + exception.getMessage());
        }
        finally {
            if (enumeration != null) {
                enumeration.close();
            }
            if (safeLdapContext != null) {
                safeLdapContext.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserGroup _importUserGroup(long companyId, Attributes groupAttributes, Properties groupMappings) throws Exception {
        groupAttributes = this._attributesTransformer.transformGroup(groupAttributes);
        LDAPGroup ldapGroup = this._ldapToPortalConverter.importLDAPGroup(companyId, groupAttributes, groupMappings);
        UserGroup userGroup = null;
        try {
            userGroup = this._userGroupLocalService.getUserGroup(companyId, ldapGroup.getGroupName());
            if (!Objects.equals(userGroup.getDescription(), ldapGroup.getDescription())) {
                this._userGroupLocalService.updateUserGroup(companyId, userGroup.getUserGroupId(), ldapGroup.getGroupName(), ldapGroup.getDescription(), null);
            }
        }
        catch (NoSuchUserGroupException noSuchUserGroupException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchUserGroupException);
            }
            StopWatch stopWatch = new StopWatch();
            if (_log.isDebugEnabled()) {
                stopWatch.start();
                _log.debug((Object)("Adding LDAP group " + ldapGroup));
            }
            long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
            UserGroupImportTransactionThreadLocal.setOriginatesFromImport((boolean)true);
            try {
                userGroup = this._userGroupLocalService.addUserGroup(defaultUserId, companyId, ldapGroup.getGroupName(), ldapGroup.getDescription(), null);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished adding LDAP group ", ldapGroup, " as user group ", userGroup, " in ", stopWatch.getTime(), "ms"}));
                }
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to create user group " + ldapGroup.getGroupName()));
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
            }
            finally {
                UserGroupImportTransactionThreadLocal.setOriginatesFromImport((boolean)false);
            }
        }
        this._addRole(companyId, ldapGroup, userGroup);
        return userGroup;
    }

    private void _populateExpandoAttributes(ExpandoBridge expandoBridge, Map<String, String[]> expandoAttributes, Properties expandoMappings, Set<String> ldapUserIgnoreAttributes) {
        block5: {
            HashMap<String, Serializable> serializedExpandoAttributes = new HashMap<String, Serializable>();
            for (Map.Entry<String, String[]> expandoAttribute : expandoAttributes.entrySet()) {
                String name = expandoAttribute.getKey();
                if (!expandoBridge.hasAttribute(name) || !expandoMappings.containsKey(name) || ldapUserIgnoreAttributes.contains(name)) continue;
                int type = expandoBridge.getAttributeType(name);
                Serializable value = ExpandoConverterUtil.getAttributeFromStringArray((int)type, (String[])expandoAttribute.getValue());
                serializedExpandoAttributes.put(name, value);
            }
            if (serializedExpandoAttributes.isEmpty()) {
                return;
            }
            try {
                this._expandoValueLocalService.addValues(expandoBridge.getCompanyId(), expandoBridge.getClassName(), "CUSTOM_FIELDS", expandoBridge.getClassPK(), serializedExpandoAttributes);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to populate expando attributes");
                }
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _setProperty(Object bean1, Object bean2, String propertyName) {
        Object value = this._beanProperties.getObject(bean2, propertyName);
        this._beanProperties.setProperty(bean1, propertyName, value);
    }

    private void _updateLDAPUser(User ldapUser, Contact ldapContact, User user, Properties userMappings, Properties contactMappings, Set<String> ldapUserIgnoreAttributes) throws Exception {
        String mappingPropertyName;
        String propertyName;
        int n;
        Contact contact = user.getContact();
        String[] stringArray = _CONTACT_PROPERTY_NAMES;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            mappingPropertyName = propertyName = stringArray[n];
            if (propertyName.equals("male")) {
                mappingPropertyName = "gender";
            } else if (propertyName.equals("prefixListTypeId")) {
                mappingPropertyName = "prefix";
            } else if (propertyName.equals("suffixListTypeId")) {
                mappingPropertyName = "suffix";
            }
            if (contactMappings.containsKey(mappingPropertyName) && !ldapUserIgnoreAttributes.contains(propertyName)) continue;
            this._setProperty(ldapContact, contact, propertyName);
        }
        stringArray = _USER_PROPERTY_NAMES;
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            mappingPropertyName = propertyName = stringArray[n];
            if (propertyName.equals("portraitId")) {
                mappingPropertyName = "portrait";
            }
            if (userMappings.containsKey(mappingPropertyName) && !ldapUserIgnoreAttributes.contains(propertyName)) continue;
            this._setProperty(ldapUser, user, propertyName);
        }
    }

    private User _updateUser(LDAPImportContext ldapImportContext, LDAPUser ldapUser, User user, String password, String modifyTimestamp, boolean isNew) throws Exception {
        Date modifiedDate;
        long ldapServerId;
        long companyId;
        StopWatch stopWatch;
        block18: {
            stopWatch = new StopWatch();
            companyId = ldapImportContext.getCompanyId();
            ldapServerId = ldapImportContext.getLdapServerId();
            if (_log.isDebugEnabled()) {
                stopWatch.start();
                if (isNew) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Updating new user ", user, " from LDAP server ", ldapServerId, " to company ", companyId}));
                } else {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Updating existing user ", user, " from LDAP server ", ldapServerId, " to company ", companyId}));
                }
            }
            modifiedDate = null;
            try {
                modifiedDate = LDAPUtil.parseDate((String)modifyTimestamp);
            }
            catch (ParseException parseException) {
                if (!_log.isDebugEnabled()) break block18;
                _log.debug((Object)("Unable to parse LDAP modify timestamp " + modifyTimestamp), (Throwable)parseException);
            }
        }
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        boolean passwordReset = ldapUser.isPasswordReset();
        if (this._ldapSettings.isExportEnabled(companyId)) {
            passwordReset = user.isPasswordReset();
        }
        if (modifiedDate != null && modifiedDate.equals(user.getModifiedDate())) {
            if (!(!ldapUser.isUpdatePassword() && ldapImportConfiguration.importUserPasswordEnabled() || modifiedDate.equals(user.getPasswordModifiedDate()))) {
                this._updateUserPassword(ldapImportConfiguration, user.getUserId(), user.getScreenName(), password, passwordReset, modifiedDate);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Synchronizing password for ", user.getEmailAddress(), " because it might be out of date"}));
                }
            }
            return user;
        }
        if (modifiedDate == null && !isNew) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Skipping user " + user.getEmailAddress() + " because the LDAP entry was never modified"));
            }
            return user;
        }
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        if (ldapServerConfiguration.ldapServerId() != ldapServerId) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"LDAP server ID ", ldapServerId, " is no longer valid, company ", companyId, " now uses ", ldapServerConfiguration.ldapServerId()}));
            }
            return user;
        }
        String[] userIgnoreAttributes = ldapServerConfiguration.userIgnoreAttributes();
        HashSet<String> ldapUserIgnoreAttributes = new HashSet<String>(Arrays.asList(userIgnoreAttributes));
        if (Validator.isNull((String)ldapUser.getScreenName()) || ldapUser.isAutoScreenName()) {
            ldapUser.setScreenName(user.getScreenName());
        }
        if (ldapUser.isUpdatePassword() || !ldapImportConfiguration.importUserPasswordEnabled()) {
            password = this._updateUserPassword(ldapImportConfiguration, user.getUserId(), ldapUser.getScreenName(), password, passwordReset, modifiedDate);
        }
        Contact ldapContact = ldapUser.getContact();
        ExpandoBridge userExpandoBridge = user.getExpandoBridge();
        this._populateExpandoAttributes(userExpandoBridge, ldapUser.getUserExpandoAttributes(), ldapImportContext.getUserExpandoMappings(), ldapImportContext.getLdapUserIgnoreAttributes());
        Contact contact = user.getContact();
        ExpandoBridge contactExpandoBridge = contact.getExpandoBridge();
        this._populateExpandoAttributes(contactExpandoBridge, ldapUser.getContactExpandoAttributes(), ldapImportContext.getContactExpandoMappings(), ldapImportContext.getLdapUserIgnoreAttributes());
        this._updateLDAPUser(ldapUser.getUser(), ldapContact, user, ldapImportContext.getUserMappings(), ldapImportContext.getContactMappings(), ldapUserIgnoreAttributes);
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(ldapContact.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        ServiceContext serviceContext = ldapUser.getServiceContext();
        if (modifiedDate != null) {
            serviceContext.setModifiedDate(modifiedDate);
        }
        this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        user = this._userLocalService.updateUser(user.getUserId(), password, "", "", passwordReset, ldapUser.getReminderQueryQuestion(), ldapUser.getReminderQueryAnswer(), ldapUser.getScreenName(), ldapUser.getEmailAddress(), ldapUser.isUpdatePortrait(), ldapUser.getPortraitBytes(), ldapUser.getLanguageId(), ldapUser.getTimeZoneId(), ldapUser.getGreeting(), ldapUser.getComments(), ldapUser.getFirstName(), ldapUser.getMiddleName(), ldapUser.getLastName(), ldapUser.getPrefixListTypeId(), ldapUser.getSuffixListTypeId(), ldapUser.isMale(), birthdayMonth, birthdayDay, birthdayYear, ldapUser.getSmsSn(), ldapUser.getFacebookSn(), ldapUser.getJabberSn(), ldapUser.getSkypeSn(), ldapUser.getTwitterSn(), ldapUser.getJobTitle(), ldapUser.getGroupIds(), ldapUser.getOrganizationIds(), ldapUser.getRoleIds(), ldapUser.getUserGroupRoles(), ldapUser.getUserGroupIds(), serviceContext);
        if (user.getStatus() != ldapUser.getStatus()) {
            user = this._userLocalService.updateStatus(user.getUserId(), ldapUser.getStatus(), serviceContext);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished update for user ", user, " in ", stopWatch.getTime(), "ms"}));
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _updateUserPassword(LDAPImportConfiguration ldapImportConfiguration, long userId, String screenName, String password, boolean passwordReset, Date modifiedDate) throws Exception {
        boolean passwordGenerated = false;
        if (!ldapImportConfiguration.importUserPasswordEnabled()) {
            passwordGenerated = true;
            if (ldapImportConfiguration.importUserPasswordAutogenerated()) {
                password = PwdGenerator.getPassword();
            } else {
                password = ldapImportConfiguration.importUserPasswordDefault();
                if (StringUtil.equalsIgnoreCase((String)password, (String)_USER_PASSWORD_SCREEN_NAME)) {
                    password = screenName;
                }
            }
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setModifiedDate(modifiedDate);
        try {
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            User user = this._userLocalService.updatePassword(userId, password, password, passwordReset, true);
            if (passwordGenerated) {
                user.setDigest("");
                this._userLocalService.updateUser(user);
            }
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
        return password;
    }
}

