/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.instance.lifecycle;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.security.exportimport.UserImporter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={PortalInstanceLifecycleListener.class})
public class LDAPPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(LDAPPortalInstanceLifecycleListener.class);
    @Reference
    private LDAPSettings _ldapSettings;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile UserImporter _userImporter;

    public void portalInstanceRegistered(Company company) throws Exception {
        if (this._ldapSettings.isImportOnStartup(company.getCompanyId())) {
            try {
                this._userImporter.importUsers(company.getCompanyId());
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to import users for company " + company.getCompanyId()), (Throwable)exception);
            }
        }
    }

    public void portalInstanceUnregistered(Company company) throws Exception {
    }
}

