/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.configuration;

import com.liferay.osgi.service.tracker.collections.EagerServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import java.io.IOException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={ConfigurationListener.class})
public class LDAPConfigurationListener
implements ConfigurationListener {
    private static final Log _log = LogFactoryUtil.getLog(LDAPConfigurationListener.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    private ServiceTrackerMap<String, ConfigurationProvider<?>> _serviceTrackerMap;

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        ConfigurationProvider configurationProvider;
        String factoryPid = configurationEvent.getFactoryPid();
        if (Validator.isNull((String)factoryPid)) {
            return;
        }
        if (factoryPid.endsWith(".scoped")) {
            factoryPid = StringUtil.replaceLast((String)factoryPid, (String)".scoped", (String)"");
        }
        if ((configurationProvider = (ConfigurationProvider)this._serviceTrackerMap.getService((Object)factoryPid)) == null) {
            return;
        }
        try {
            if (configurationEvent.getType() == 2) {
                configurationProvider.unregisterConfiguration(configurationEvent.getPid());
            } else {
                configurationProvider.registerConfiguration(this._configurationAdmin.getConfiguration(configurationEvent.getPid(), "?"));
            }
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to load configuration " + configurationEvent.getPid(), (Throwable)ioException);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ConfigurationProvider.class, null, (serviceReference, emitter) -> {
            String factoryPid = (String)serviceReference.getProperty("factoryPid");
            if (Validator.isNull((String)factoryPid)) {
                throw new IllegalArgumentException("No factory PID specified for configuration provider " + serviceReference);
            }
            emitter.emit((Object)factoryPid);
        }, (ServiceTrackerCustomizer)new LDAPConfigurationListenerServiceTrackerCustomizer(bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private class LDAPConfigurationListenerServiceTrackerCustomizer
    implements EagerServiceTrackerCustomizer<ConfigurationProvider<?>, ConfigurationProvider<?>> {
        private final BundleContext _bundleContext;

        public LDAPConfigurationListenerServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public ConfigurationProvider<?> addingService(ServiceReference<ConfigurationProvider<?>> serviceReference) {
            ConfigurationProvider configurationProvider;
            block4: {
                configurationProvider = (ConfigurationProvider)this._bundleContext.getService(serviceReference);
                String factoryPid = (String)serviceReference.getProperty("factoryPid");
                try {
                    Configuration[] configurations = LDAPConfigurationListener.this._configurationAdmin.listConfigurations("(service.factoryPid=" + factoryPid + "*)");
                    if (configurations != null) {
                        for (Configuration configuration : configurations) {
                            configurationProvider.registerConfiguration(configuration);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)"Unable to register configurations", (Throwable)exception);
                }
            }
            return configurationProvider;
        }

        public void modifiedService(ServiceReference<ConfigurationProvider<?>> serviceReference, ConfigurationProvider<?> service) {
        }

        public void removedService(ServiceReference<ConfigurationProvider<?>> serviceReference, ConfigurationProvider<?> service) {
            this._bundleContext.ungetService(serviceReference);
        }
    }
}

