/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.exportimport;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ContactConstants;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.FullNameDefinition;
import com.liferay.portal.kernel.security.auth.FullNameDefinitionFactory;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ListTypeService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.ContactPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.exportimport.LDAPGroup;
import com.liferay.portal.security.ldap.exportimport.LDAPToPortalConverter;
import com.liferay.portal.security.ldap.exportimport.LDAPUser;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.directory.Attributes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LDAPToPortalConverter.class})
public class DefaultLDAPToPortalConverter
implements LDAPToPortalConverter {
    private static final Log _log = LogFactoryUtil.getLog(DefaultLDAPToPortalConverter.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ContactPersistence _contactPersistence;
    @Reference
    private ListTypeService _listTypeService;
    @Reference
    private UserPersistence _userPersistence;

    public LDAPGroup importLDAPGroup(long companyId, Attributes attributes, Properties groupMappings) throws Exception {
        LDAPGroup ldapGroup = new LDAPGroup();
        ldapGroup.setCompanyId(companyId);
        ldapGroup.setDescription(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)groupMappings, (String)"description"));
        ldapGroup.setGroupName(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)groupMappings, (String)"groupName"));
        return ldapGroup;
    }

    public LDAPUser importLDAPUser(long companyId, Attributes attributes, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, String password) throws Exception {
        Company company = this._companyLocalService.getCompany(companyId);
        Locale locale = company.getLocale();
        boolean autoScreenName = PrefsPropsUtil.getBoolean((long)companyId, (String)"users.screen.name.always.autogenerate");
        String screenName = StringUtil.toLowerCase((String)LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"screenName"));
        String emailAddress = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"emailAddress");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Screen name ", screenName, " and email address ", emailAddress}));
        }
        String firstName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"firstName");
        String middleName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"middleName");
        String lastName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"lastName");
        FullNameDefinition fullNameDefinition = FullNameDefinitionFactory.getInstance((Locale)locale);
        if (Validator.isNull((String)firstName) || fullNameDefinition.isFieldRequired("last-name") && Validator.isNull((String)lastName)) {
            String fullName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"fullName");
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String[] names = fullNameGenerator.splitFullName(fullName);
            if (Validator.isNull((String)firstName)) {
                firstName = names[0];
            }
            if (Validator.isNull((String)middleName)) {
                middleName = names[1];
            }
            if (Validator.isNull((String)lastName)) {
                lastName = names[2];
            }
        }
        if (!autoScreenName && Validator.isNull((String)screenName)) {
            throw new UserScreenNameException.MustNotBeNull(ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName));
        }
        if (Validator.isNull((String)emailAddress) && PrefsPropsUtil.getBoolean((long)companyId, (String)"users.email.address.required")) {
            throw new UserEmailAddressException.MustNotBeNull(ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName));
        }
        LDAPUser ldapUser = new LDAPUser();
        ldapUser.setAutoPassword(password == null);
        ldapUser.setAutoScreenName(autoScreenName);
        Contact contact = this._contactPersistence.create(0L);
        if (contactExpandoMappings.containsKey("prefix")) {
            String prefix = contactExpandoMappings.getProperty("prefix");
            contactMappings.put("prefix", prefix);
        }
        if (contactExpandoMappings.containsKey("suffix")) {
            String suffix = contactExpandoMappings.getProperty("suffix");
            contactMappings.put("suffix", suffix);
        }
        contact.setPrefixListTypeId(this._getListTypeId(attributes, contactMappings, "prefix", ListTypeConstants.CONTACT_PREFIX));
        contact.setSuffixListTypeId(this._getListTypeId(attributes, contactMappings, "suffix", ListTypeConstants.CONTACT_SUFFIX));
        String gender = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)contactMappings, (String)"gender");
        gender = StringUtil.toLowerCase((String)gender);
        if (Validator.isNull((String)gender) || GetterUtil.getBoolean((String)gender) || gender.equals("m") || gender.equals("male")) {
            contact.setMale(true);
        } else {
            contact.setMale(false);
        }
        try {
            contact.setBirthday(DateUtil.parseDate((String)LDAPUtil.getAttributeString((Attributes)attributes, (Properties)contactMappings, (String)"birthday"), (Locale)locale));
        }
        catch (ParseException parseException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)parseException);
            }
            Calendar birthdayCalendar = CalendarFactoryUtil.getCalendar((int)1970, (int)0, (int)1);
            contact.setBirthday(birthdayCalendar.getTime());
        }
        contact.setSmsSn(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)contactMappings, (String)"smsSn"));
        contact.setFacebookSn(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)contactMappings, (String)"facebookSn"));
        contact.setJabberSn(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)contactMappings, (String)"jabberSn"));
        contact.setSkypeSn(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)contactMappings, (String)"skypeSn"));
        contact.setTwitterSn(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)contactMappings, (String)"twitterSn"));
        contact.setJobTitle(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)contactMappings, (String)"jobTitle"));
        ldapUser.setContact(contact);
        ldapUser.setContactExpandoAttributes(this._getExpandoAttributes(attributes, contactExpandoMappings));
        ldapUser.setCreatorUserId(0L);
        ldapUser.setGroupIds(null);
        ldapUser.setOrganizationIds(null);
        ldapUser.setPasswordReset(false);
        String portrait = userMappings.getProperty("portrait");
        if (Validator.isNotNull((String)portrait)) {
            Object portraitObject = LDAPUtil.getAttributeObject((Attributes)attributes, (String)portrait);
            if (portraitObject != null) {
                byte[] portraitBytes = (byte[])portraitObject;
                if (portraitBytes.length > 0) {
                    ldapUser.setPortraitBytes((byte[])portraitObject);
                }
                ldapUser.setUpdatePortrait(true);
            }
        } else {
            ldapUser.setUpdatePortrait(true);
        }
        ldapUser.setRoleIds(null);
        ldapUser.setSendEmail(false);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUuid(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"uuid"));
        ldapUser.setServiceContext(serviceContext);
        ldapUser.setUpdatePassword(password != null);
        User user = this._userPersistence.create(0L);
        user.setCompanyId(companyId);
        user.setEmailAddress(emailAddress);
        user.setOpenId("");
        user.setLanguageId(locale.toString());
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"jobTitle"));
        user.setPasswordUnencrypted(password);
        user.setScreenName(screenName);
        String status = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"status");
        if (Validator.isNotNull((String)status)) {
            user.setStatus(GetterUtil.getInteger((String)status));
        }
        ldapUser.setUser(user);
        ldapUser.setUserExpandoAttributes(this._getExpandoAttributes(attributes, userExpandoMappings));
        ldapUser.setUserGroupIds(null);
        ldapUser.setUserGroupRoles(null);
        return ldapUser;
    }

    private Map<String, String[]> _getExpandoAttributes(Attributes attributes, Properties expandoMappings) throws Exception {
        HashMap<String, String[]> expandoAttributes = new HashMap<String, String[]>();
        for (Object key : expandoMappings.keySet()) {
            String name = (String)key;
            String[] value = LDAPUtil.getAttributeStringArray((Attributes)attributes, (Properties)expandoMappings, (String)name);
            if (value == null) continue;
            expandoAttributes.put(name, value);
        }
        return expandoAttributes;
    }

    private long _getListTypeId(Attributes attributes, Properties contactMappings, String contactMappingsKey, String listTypeType) throws Exception {
        List contactPrefixListTypes = this._listTypeService.getListTypes(listTypeType);
        String name = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)contactMappings, (String)contactMappingsKey);
        for (ListType listType : contactPrefixListTypes) {
            if (!name.equals(listType.getName())) continue;
            return listType.getListTypeId();
        }
        return 0L;
    }
}

