/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.scheduler;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(factory="com.liferay.portal.security.ldap.internal.scheduler.UserImportSchedulerJobConfiguration", service={SchedulerJobConfiguration.class})
public class UserImportSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private static final Log _log = LogFactoryUtil.getLog(UserImportSchedulerJobConfiguration.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    private LDAPImportConfiguration _ldapImportConfiguration;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)")
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile LDAPUserImporter _ldapUserImporter;

    public UnsafeConsumer<Long, Exception> getCompanyJobExecutorUnsafeConsumer() {
        return companyId -> this._importUsers((long)companyId, this._getLastImportTime());
    }

    public String getDestinationName() {
        return "liferay/scheduled_user_ldap_import";
    }

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            long time = this._getLastImportTime();
            this._companyLocalService.forEachCompanyId(companyId -> this._importUsers((long)companyId, time));
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)this._ldapImportConfiguration.importInterval(), (TimeUnit)TimeUnit.MINUTE);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._ldapImportConfiguration = (LDAPImportConfiguration)properties.get("configuration");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("LDAP user imports will be attempted every " + this._ldapImportConfiguration.importInterval() + " minutes"));
        }
    }

    private long _getLastImportTime() throws Exception {
        long time = System.currentTimeMillis() - this._ldapUserImporter.getLastImportTime();
        return Math.round((double)time / 60000.0);
    }

    private void _importUsers(long companyId, long time) throws Exception {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        if (!ldapImportConfiguration.importEnabled()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping LDAP user import for company " + companyId + " because LDAP import is disabled"));
            }
            return;
        }
        if (ldapImportConfiguration.importInterval() <= 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping LDAP user import for company " + companyId + " because LDAP import interval is less than 1"));
            }
            return;
        }
        if (time < (long)ldapImportConfiguration.importInterval()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping LDAP user import for company ", companyId, " because LDAP import interval has not been ", "reached"}));
            }
            return;
        }
        this._ldapUserImporter.importUsers(companyId);
    }
}

