/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.upgrade.v0_0_2;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration;
import com.liferay.portal.security.ldap.constants.LegacyLDAPPropsKeys;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;

public class LDAPPropertiesUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(LDAPPropertiesUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    private final ConfigurationProvider<LDAPExportConfiguration> _ldapExportConfigurationProvider;
    private final ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    private final ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    private final LDAPSettings _ldapSettings;
    private final PrefsProps _prefsProps;
    private final ConfigurationProvider<SystemLDAPConfiguration> _systemLDAPConfigurationProvider;

    public LDAPPropertiesUpgradeProcess(CompanyLocalService companyLocalService, ConfigurationProvider<LDAPAuthConfiguration> ldapAuthConfigurationProvider, ConfigurationProvider<LDAPExportConfiguration> ldapExportConfigurationProvider, ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider, ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider, LDAPSettings ldapSettings, PrefsProps prefsProps, ConfigurationProvider<SystemLDAPConfiguration> systemLDAPConfigurationProvider) {
        this._companyLocalService = companyLocalService;
        this._ldapAuthConfigurationProvider = ldapAuthConfigurationProvider;
        this._ldapExportConfigurationProvider = ldapExportConfigurationProvider;
        this._ldapImportConfigurationProvider = ldapImportConfigurationProvider;
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
        this._ldapSettings = ldapSettings;
        this._prefsProps = prefsProps;
        this._systemLDAPConfigurationProvider = systemLDAPConfigurationProvider;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeLDAPProperties();
    }

    private void _upgradeLDAPAuthProperties(long companyId) {
        HashMapDictionary dictionary = HashMapDictionaryBuilder.put((Object)"enabled", (Object)this._prefsProps.getBoolean(companyId, "ldap.auth.enabled", false)).put((Object)"method", (Object)this._prefsProps.getString(companyId, "ldap.auth.method", "bind")).put((Object)"required", (Object)this._prefsProps.getBoolean(companyId, "ldap.auth.required", false)).put((Object)"passwordEncryptionAlgorithm", (Object)this._prefsProps.getString(companyId, "ldap.auth.password.encryption.algorithm", "NONE")).put((Object)"passwordPolicyEnabled", (Object)this._prefsProps.getBoolean(companyId, "ldap.password.policy.enabled", false)).build();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding LDAP auth configuration for company ", companyId, " with properties: ", dictionary}));
        }
        this._ldapAuthConfigurationProvider.updateProperties(companyId, (Dictionary)dictionary);
    }

    private void _upgradeLDAPExportProperties(long companyId) {
        HashMapDictionary dictionary = HashMapDictionaryBuilder.put((Object)"exportEnabled", (Object)this._prefsProps.getBoolean(companyId, "ldap.export.enabled", false)).put((Object)"exportGroupEnabled", (Object)this._prefsProps.getBoolean(companyId, "ldap.export.group.enabled", false)).build();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding LDAP export configuration for company ", companyId, " with properties: ", dictionary}));
        }
        this._ldapExportConfigurationProvider.updateProperties(companyId, (Dictionary)dictionary);
    }

    private void _upgradeLDAPImportProperties(long companyId) {
        HashMapDictionary dictionary = HashMapDictionaryBuilder.put((Object)"importCreateRolePerGroup", (Object)this._prefsProps.getBoolean(companyId, "ldap.import.create.role.per.group", false)).put((Object)"importEnabled", (Object)this._prefsProps.getBoolean(companyId, "ldap.import.enabled", false)).put((Object)"importGroupCacheEnabled", (Object)this._prefsProps.getBoolean(companyId, "ldap.import.group.cache.enabled", false)).put((Object)"importInterval", (Object)this._prefsProps.getInteger(companyId, "ldap.import.interval", 10)).put((Object)"importLockExpirationTime", (Object)this._prefsProps.getLong(companyId, "ldap.import.lock.expiration.time", 86400000L)).put((Object)"importMethod", (Object)this._prefsProps.getString(companyId, "ldap.import.method", "user")).put((Object)"importOnStartup", (Object)this._prefsProps.getBoolean(companyId, "ldap.import.on.startup", false)).put((Object)"importUserPasswordAutogenerated", (Object)this._prefsProps.getBoolean(companyId, "ldap.import.user.password.autogenerated", false)).put((Object)"importUserPasswordDefault", (Object)this._prefsProps.getString(companyId, "ldap.import.user.password.default", "test")).put((Object)"importUserPasswordEnabled", (Object)this._prefsProps.getBoolean(companyId, "ldap.import.user.password.enabled", true)).put((Object)"importUserSyncStrategy", (Object)this._prefsProps.getString(companyId, "ldap.import.user.sync.strategy", "auth-type")).build();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding LDAP import configuration for company ", companyId, " with properties: ", dictionary}));
        }
        this._ldapImportConfigurationProvider.updateProperties(companyId, (Dictionary)dictionary);
    }

    private void _upgradeLDAPProperties() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._companyLocalService.forEachCompanyId(companyId -> {
                long[] ldapServerIds = StringUtil.split((String)this._prefsProps.getString(companyId.longValue(), "ldap.server.ids"), (long)0L);
                if (ArrayUtil.isEmpty((long[])ldapServerIds)) {
                    return;
                }
                this._upgradeLDAPAuthProperties((long)companyId);
                this._upgradeLDAPExportProperties((long)companyId);
                this._upgradeLDAPImportProperties((long)companyId);
                this._upgradeSystemLDAPConfiguration((long)companyId);
                HashSet<String> keys = new HashSet<String>();
                Collections.addAll(keys, LegacyLDAPPropsKeys.LDAP_KEYS_NONPOSTFIXED);
                for (long ldapServerId : ldapServerIds) {
                    String postfix = this._ldapSettings.getPropertyPostfix(ldapServerId);
                    this._upgradeLDAPServerConfiguration((long)companyId, ldapServerId, postfix);
                    for (int i = 0; i < LegacyLDAPPropsKeys.LDAP_KEYS_POSTFIXED.length; ++i) {
                        keys.add(LegacyLDAPPropsKeys.LDAP_KEYS_POSTFIXED[i] + postfix);
                    }
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Removing preference keys ", keys, " for ", "company ", companyId}));
                }
                this._companyLocalService.removePreferences(companyId.longValue(), keys.toArray(new String[0]));
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Removing LDAP server IDs ", ListUtil.fromArray((long[])ldapServerIds), " for ", "company ", companyId}));
                }
                this._companyLocalService.updatePreferences(companyId.longValue(), UnicodePropertiesBuilder.put((String)"ldap.server.ids", (String)"").build());
            });
        }
    }

    private void _upgradeLDAPServerConfiguration(long companyId, long ldapServerId, String postfix) {
        HashMapDictionary dictionary = HashMapDictionaryBuilder.put((Object)"authSearchFilter", (Object)this._prefsProps.getString(companyId, "ldap.auth.search.filter" + postfix, "(mail=@email_address@)")).put((Object)"baseDN", (Object)this._prefsProps.getString(companyId, "ldap.base.dn" + postfix, "dc=example,dc=com")).put((Object)"baseProviderURL", (Object)this._prefsProps.getString(companyId, "ldap.base.provider.url" + postfix, "ldap://localhost:10389")).put((Object)"contactCustomMappings", (Object)this._prefsProps.getStringArray(companyId, "ldap.contact.custom.mappings" + postfix, "\n")).put((Object)"contactMappings", (Object)this._prefsProps.getStringArray(companyId, "ldap.contact.mappings" + postfix, "\n")).put((Object)"groupDefaultObjectClasses", (Object)this._prefsProps.getStringArray(companyId, "ldap.group.default.object.classes" + postfix, ",")).put((Object)"groupMappings", (Object)this._prefsProps.getStringArray(companyId, "ldap.group.mappings" + postfix, "\n")).put((Object)"groupSearchFilter", (Object)this._prefsProps.getString(companyId, "ldap.import.group.search.filter" + postfix, "(objectClass=groupOfUniqueNames)")).put((Object)"groupSearchFilterEnabled", (Object)this._prefsProps.getBoolean(companyId, "ldap.import.group.search.filter.enabled" + postfix, true)).put((Object)"groupsDN", (Object)this._prefsProps.getString(companyId, "ldap.groups.dn" + postfix, "ou=groups,dc=example,dc=com")).put((Object)"securityCredential", (Object)this._prefsProps.getString(companyId, "ldap.security.credentials" + postfix, "secret")).put((Object)"securityPrincipal", (Object)this._prefsProps.getString(companyId, "ldap.security.principal" + postfix, "uid=admin,ou=system")).put((Object)"serverName", (Object)this._prefsProps.getString(companyId, "ldap.server.name" + postfix)).put((Object)"userCustomMappings", (Object)this._prefsProps.getStringArray(companyId, "ldap.user.custom.mappings" + postfix, "\n")).put((Object)"userDefaultObjectClasses", (Object)this._prefsProps.getStringArray(companyId, "ldap.user.default.object.classes" + postfix, ",")).put((Object)"userIgnoreAttributes", (Object)this._prefsProps.getStringArray(companyId, "ldap.user.ignore.attributes" + postfix, ",")).put((Object)"userMappings", (Object)this._prefsProps.getStringArray(companyId, "ldap.user.mappings" + postfix, "\n")).put((Object)"userSearchFilter", (Object)this._prefsProps.getString(companyId, "ldap.import.user.search.filter" + postfix, "(objectClass=inetOrgPerson)")).put((Object)"usersDN", (Object)this._prefsProps.getString(companyId, "ldap.users.dn" + postfix, "users,dc=example,dc=com")).build();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding LDAP servier configuration for company ", companyId, " and LDAP server ID ", ldapServerId, " with properties: ", dictionary}));
        }
        this._ldapServerConfigurationProvider.updateProperties(companyId, ldapServerId, (Dictionary)dictionary);
    }

    private void _upgradeSystemLDAPConfiguration(long companyId) {
        HashMapDictionary dictionary = HashMapDictionaryBuilder.put((Object)"errorPasswordAgeKeywords", (Object)new String[]{this._prefsProps.getString(companyId, "ldap.error.password.age", "age")}).put((Object)"errorPasswordExpiredKeywords", (Object)new String[]{this._prefsProps.getString(companyId, "ldap.error.password.expired", "expired")}).put((Object)"errorPasswordHistoryKeywords", (Object)new String[]{this._prefsProps.getString(companyId, "ldap.error.password.history", "history")}).put((Object)"errorPasswordNotChangeableKeywords", (Object)new String[]{this._prefsProps.getString(companyId, "ldap.error.password.not.changeable", "not allowed to change")}).put((Object)"errorPasswordSyntaxKeywords", (Object)new String[]{this._prefsProps.getString(companyId, "ldap.error.password.syntax", "syntax")}).put((Object)"errorPasswordTrivialTextKeywords", (Object)new String[]{this._prefsProps.getString(companyId, "ldap.error.password.trivial", "trivial")}).put((Object)"errorUserLockoutKeywords", (Object)new String[]{this._prefsProps.getString(companyId, "ldap.error.user.lockout", "retry limit")}).put((Object)"factoryInitial", (Object)this._prefsProps.getString(companyId, "ldap.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory")).put((Object)"pageSize", (Object)this._prefsProps.getInteger(companyId, "ldap.page.size", 1000)).put((Object)"rangeSize", (Object)this._prefsProps.getInteger(companyId, "ldap.range.size", 1000)).put((Object)"referral", (Object)this._prefsProps.getString(companyId, "ldap.referral", "follow")).build();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding system LDAP configurations for company ", companyId, " with properties: ", dictionary}));
        }
        this._systemLDAPConfigurationProvider.updateProperties(companyId, (Dictionary)dictionary);
    }
}

