/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import java.util.Properties;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LDAPSettings.class})
public class DefaultLDAPSettings
implements LDAPSettings {
    private static final Log _log = LogFactoryUtil.getLog(DefaultLDAPSettings.class);
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)")
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration)")
    private ConfigurationProvider<LDAPExportConfiguration> _ldapExportConfigurationProvider;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)")
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)")
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration)")
    private ConfigurationProvider<SystemLDAPConfiguration> _systemLDAPConfigurationProvider;
    @Reference
    private UserLocalService _userLocalService;

    public Properties getContactExpandoMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties contactExpandoMappings = this._getProperties(ldapServerConfiguration.contactCustomMappings());
        LogUtil.debug((Log)_log, (Properties)contactExpandoMappings);
        return contactExpandoMappings;
    }

    public Properties getContactMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties contactMappings = this._getProperties(ldapServerConfiguration.contactMappings());
        LogUtil.debug((Log)_log, (Properties)contactMappings);
        return contactMappings;
    }

    public String[] getErrorPasswordHistoryKeywords(long companyId) {
        SystemLDAPConfiguration systemLDAPConfiguration = (SystemLDAPConfiguration)this._systemLDAPConfigurationProvider.getConfiguration(companyId);
        return systemLDAPConfiguration.errorPasswordHistoryKeywords();
    }

    public Properties getGroupMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties groupMappings = this._getProperties(ldapServerConfiguration.groupMappings());
        LogUtil.debug((Log)_log, (Properties)groupMappings);
        return groupMappings;
    }

    public long getPreferredLDAPServerId(long companyId, String screenName) {
        User user = this._userLocalService.fetchUserByScreenName(companyId, screenName);
        if (user == null) {
            return -1L;
        }
        return user.getLdapServerId();
    }

    public String getPropertyPostfix(long ldapServerId) {
        return "." + ldapServerId;
    }

    public Properties getUserExpandoMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties contactExpandoMappings = this._getProperties(ldapServerConfiguration.userCustomMappings());
        LogUtil.debug((Log)_log, (Properties)contactExpandoMappings);
        return contactExpandoMappings;
    }

    public Properties getUserMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties userMappings = this._getProperties(ldapServerConfiguration.userMappings());
        LogUtil.debug((Log)_log, (Properties)userMappings);
        return userMappings;
    }

    public boolean isExportEnabled(long companyId) {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        boolean defaultImportUserPasswordAutogenerated = ldapImportConfiguration.importUserPasswordAutogenerated();
        if (ldapImportConfiguration.importEnabled() && defaultImportUserPasswordAutogenerated) {
            return false;
        }
        LDAPExportConfiguration ldapExportConfiguration = (LDAPExportConfiguration)this._ldapExportConfigurationProvider.getConfiguration(companyId);
        return ldapExportConfiguration.exportEnabled();
    }

    public boolean isExportGroupEnabled(long companyId) {
        LDAPExportConfiguration ldapExportConfiguration = (LDAPExportConfiguration)this._ldapExportConfigurationProvider.getConfiguration(companyId);
        return ldapExportConfiguration.exportGroupEnabled();
    }

    public boolean isImportEnabled(long companyId) {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        return ldapImportConfiguration.importEnabled();
    }

    public boolean isImportOnStartup(long companyId) {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        return ldapImportConfiguration.importOnStartup();
    }

    public boolean isPasswordPolicyEnabled(long companyId) {
        LDAPAuthConfiguration ldapAuthConfiguration = (LDAPAuthConfiguration)this._ldapAuthConfigurationProvider.getConfiguration(companyId);
        return ldapAuthConfiguration.passwordPolicyEnabled();
    }

    public boolean isPasswordPolicyEnabled(long ldapServerId, long companyId) {
        return this.isPasswordPolicyEnabled(companyId) && ldapServerId > 0L;
    }

    private Properties _getProperties(String[] keyValuePairs) {
        Properties properties = new Properties();
        for (String keyValuePair : keyValuePairs) {
            Object[] keyValue = StringUtil.split((String)keyValuePair, (char)'=');
            if (ArrayUtil.isEmpty((Object[])keyValue)) continue;
            Object value = "";
            if (keyValue.length == 2) {
                value = keyValue[1];
            }
            properties.put(keyValue[0], value);
        }
        return properties;
    }
}

