/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.exportimport;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.exportimport.UserOperation;
import com.liferay.portal.security.ldap.SafeLdapContext;
import com.liferay.portal.security.ldap.SafeLdapName;
import com.liferay.portal.security.ldap.SafeLdapNameFactory;
import com.liferay.portal.security.ldap.SafePortalLDAP;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.exportimport.Modifications;
import com.liferay.portal.security.ldap.exportimport.PortalToLDAPConverter;
import com.liferay.portal.security.ldap.internal.PortalLDAPContext;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={UserExporter.class})
public class LDAPUserExporterImpl
implements UserExporter {
    private static final Log _log = LogFactoryUtil.getLog(LDAPUserExporterImpl.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)")
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    @Reference
    private LDAPSettings _ldapSettings;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile PortalToLDAPConverter _portalToLDAPConverter;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile SafePortalLDAP _safePortalLDAP;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUser(Contact contact, Map<String, Serializable> contactExpandoAttributes) throws Exception {
        StopWatch stopWatch;
        block17: {
            Modifications modifications;
            Binding userBinding;
            SafeLdapContext safeLdapContext;
            block15: {
                block16: {
                    long ldapServerId;
                    User user;
                    long companyId;
                    block13: {
                        block14: {
                            companyId = contact.getCompanyId();
                            stopWatch = new StopWatch();
                            if (_log.isDebugEnabled()) {
                                stopWatch.start();
                                _log.debug((Object)("Exporting contact " + contact));
                            }
                            if (!this._ldapSettings.isExportEnabled(companyId)) {
                                return;
                            }
                            user = this._userLocalService.getUserByContactId(contact.getContactId());
                            if (user.isGuestUser() || user.getStatus() != 0 && user.getStatus() != 5 || this._isAnonymousUser(user)) {
                                return;
                            }
                            ldapServerId = this._safePortalLDAP.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
                            safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapServerId, companyId);
                            try {
                                if (safeLdapContext != null) break block13;
                                if (safeLdapContext == null) break block14;
                            }
                            catch (Throwable throwable) {
                                if (safeLdapContext != null) {
                                    safeLdapContext.close();
                                }
                                if (_log.isDebugEnabled()) {
                                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished exporting contact ", contact, " in ", stopWatch.getTime(), "ms"}));
                                }
                                throw throwable;
                            }
                            safeLdapContext.close();
                        }
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished exporting contact ", contact, " in ", stopWatch.getTime(), "ms"}));
                        }
                        return;
                    }
                    Properties contactMappings = this._ldapSettings.getContactMappings(ldapServerId, companyId);
                    Properties contactExpandoMappings = this._ldapSettings.getContactExpandoMappings(ldapServerId, companyId);
                    userBinding = this._safePortalLDAP.getUser(ldapServerId, contact.getCompanyId(), user.getScreenName(), user.getEmailAddress(), false, false);
                    if (userBinding == null) {
                        Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
                        userBinding = this.addUser(ldapServerId, (LdapContext)safeLdapContext, user, userMappings);
                    }
                    if ((modifications = this._portalToLDAPConverter.getLDAPContactModifications(contact, contactExpandoAttributes, contactMappings, contactExpandoMappings)) != null) break block15;
                    if (safeLdapContext == null) break block16;
                    safeLdapContext.close();
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished exporting contact ", contact, " in ", stopWatch.getTime(), "ms"}));
                }
                return;
            }
            ModificationItem[] modificationItems = modifications.getItems();
            safeLdapContext.modifyAttributes((Name)SafeLdapNameFactory.from((Binding)userBinding), modificationItems);
            if (safeLdapContext == null) break block17;
            safeLdapContext.close();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished exporting contact ", contact, " in ", stopWatch.getTime(), "ms"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUser(long userId, long userGroupId, UserOperation userOperation) throws Exception {
        StopWatch stopWatch;
        User user;
        block17: {
            user = this._userLocalService.getUser(userId);
            long companyId = user.getCompanyId();
            stopWatch = new StopWatch();
            if (_log.isDebugEnabled()) {
                stopWatch.start();
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Exporting user ", user, " in user group ", userGroupId}));
            }
            if (!this._ldapSettings.isExportEnabled(companyId) || !this._ldapSettings.isExportGroupEnabled(companyId)) {
                return;
            }
            long ldapServerId = this._safePortalLDAP.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
            SafeLdapContext safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapServerId, companyId);
            if (safeLdapContext == null) {
                return;
            }
            UserGroup userGroup = this._userGroupLocalService.getUserGroup(userGroupId);
            Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, companyId);
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            Binding userGroupBinding = this._safePortalLDAP.getGroup(ldapServerId, companyId, userGroup.getName());
            if (userGroupBinding == null) {
                if (userOperation == UserOperation.ADD) {
                    this._addGroup(ldapServerId, (LdapContext)safeLdapContext, userGroup, user, groupMappings, userMappings);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get or add LDAP bindings for user group " + userGroup.getName()));
                }
                return;
            }
            SafeLdapName userGroupSafeLdapName = SafeLdapNameFactory.from((Binding)userGroupBinding);
            try {
                Modifications modifications = this._portalToLDAPConverter.getLDAPGroupModifications(ldapServerId, userGroup, user, groupMappings, userMappings, userOperation);
                ModificationItem[] modificationItems = modifications.getItems();
                safeLdapContext.modifyAttributes((Name)userGroupSafeLdapName, modificationItems);
                if (safeLdapContext == null) break block17;
            }
            catch (SchemaViolationException schemaViolationException) {
                block18: {
                    try {
                        Attributes attributes;
                        Attribute groupMembers;
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)("Unable to update LDAP bindings for user group " + userGroup.getName()), (Throwable)schemaViolationException);
                        }
                        if ((groupMembers = (attributes = this._safePortalLDAP.getGroupAttributes(ldapServerId, companyId, safeLdapContext, userGroupSafeLdapName, true)).get(groupMappings.getProperty("user"))) != null && groupMembers.size() == 1) {
                            safeLdapContext.unbind((Name)userGroupSafeLdapName);
                        }
                        if (safeLdapContext == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (safeLdapContext != null) {
                            safeLdapContext.close();
                        }
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished exporting user ", user, " in user group ", userGroupId, " in ", stopWatch.getTime(), "ms"}));
                        }
                        throw throwable;
                    }
                    safeLdapContext.close();
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished exporting user ", user, " in user group ", userGroupId, " in ", stopWatch.getTime(), "ms"}));
                }
            }
            safeLdapContext.close();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Finished exporting user ", user, " in user group ", userGroupId, " in ", stopWatch.getTime(), "ms"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUser(User user, Map<String, Serializable> userExpandoAttributes) throws Exception {
        if (user.isGuestUser() || user.getStatus() != 0 && user.getStatus() != 5 || this._isAnonymousUser(user)) {
            return;
        }
        long companyId = user.getCompanyId();
        if (!this._ldapSettings.isExportEnabled(companyId)) {
            return;
        }
        long ldapServerId = this._safePortalLDAP.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
        try (SafeLdapContext safeLdapContext = this._safePortalLDAP.getSafeLdapContext(ldapServerId, companyId);){
            if (safeLdapContext == null) {
                return;
            }
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            Properties userExpandoMappings = this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId);
            Binding userBinding = this._safePortalLDAP.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress(), true, false);
            if (userBinding == null) {
                userBinding = this.addUser(ldapServerId, (LdapContext)safeLdapContext, user, userMappings);
            } else {
                Attributes attributes = this._safePortalLDAP.getUserAttributes(ldapServerId, companyId, safeLdapContext, SafeLdapNameFactory.from((Binding)userBinding));
                String modifyTimestamp = LDAPUtil.getAttributeString((Attributes)attributes, (String)"modifyTimestamp");
                Date modifiedDate = LDAPUtil.parseDate((String)modifyTimestamp);
                if (modifiedDate != null && modifiedDate.equals(user.getModifiedDate())) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Skipping user " + user.getEmailAddress() + " because he is already synchronized"));
                    }
                    return;
                }
            }
            Modifications modifications = this._portalToLDAPConverter.getLDAPUserModifications(user, userExpandoAttributes, userMappings, userExpandoMappings);
            if (modifications == null) {
                return;
            }
            ModificationItem[] modificationItems = modifications.getItems();
            if (userBinding == null) {
                userBinding = this._safePortalLDAP.getUser(ldapServerId, companyId, user.getScreenName(), user.getEmailAddress(), false, false);
            }
            SafeLdapName userSafeLdapName = SafeLdapNameFactory.from((Binding)userBinding);
            safeLdapContext.modifyAttributes((Name)userSafeLdapName, modificationItems);
            if (!this._ldapSettings.isExportGroupEnabled(companyId)) {
                return;
            }
            List userGroups = this._userGroupLocalService.getUserUserGroups(user.getUserId());
            for (UserGroup userGroup : userGroups) {
                this.exportUser(user.getUserId(), userGroup.getUserGroupId(), UserOperation.ADD);
            }
            Modifications groupModifications = this._portalToLDAPConverter.getLDAPUserGroupModifications(ldapServerId, userGroups, user, userMappings);
            ModificationItem[] groupModificationItems = groupModifications.getItems();
            if (groupModificationItems.length > 0) {
                safeLdapContext.modifyAttributes((Name)userSafeLdapName, groupModificationItems);
            }
        }
    }

    protected Binding addUser(long ldapServerId, LdapContext ldapContext, User user, Properties userMappings) throws Exception {
        SafeLdapName userSafeLdapName = this._portalToLDAPConverter.getUserSafeLdapName(ldapServerId, user, userMappings);
        Attributes attributes = this._portalToLDAPConverter.getLDAPUserAttributes(ldapServerId, user, userMappings);
        ldapContext.bind((Name)userSafeLdapName, (Object)new PortalLDAPContext(attributes));
        return this._safePortalLDAP.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress());
    }

    private Binding _addGroup(long ldapServerId, LdapContext ldapContext, UserGroup userGroup, User user, Properties groupMappings, Properties userMappings) throws Exception {
        SafeLdapName userGroupSafeLdapName = this._portalToLDAPConverter.getGroupSafeLdapName(ldapServerId, userGroup, groupMappings);
        Attributes attributes = this._portalToLDAPConverter.getLDAPGroupAttributes(ldapServerId, userGroup, user, groupMappings, userMappings);
        ldapContext.bind((Name)userGroupSafeLdapName, (Object)new PortalLDAPContext(attributes));
        return this._safePortalLDAP.getGroup(ldapServerId, userGroup.getCompanyId(), userGroup.getName());
    }

    private User _getAnonymousUser(long companyId) throws Exception {
        Configuration[] configurations = this._configurationAdmin.listConfigurations(String.format("(&(companyId=%s)(service.factoryPid=%s))", companyId, "com.liferay.user.associated.data.web.internal.configuration.AnonymousUserConfiguration.scoped"));
        if (configurations == null) {
            return null;
        }
        Configuration configuration = configurations[0];
        if (configuration == null) {
            return null;
        }
        Dictionary properties = configuration.getProperties();
        long anonymousUserId = (Long)properties.get("userId");
        return this._userLocalService.fetchUser(anonymousUserId);
    }

    private boolean _isAnonymousUser(User user) {
        try {
            User anonymousUser = this._getAnonymousUser(user.getCompanyId());
            return anonymousUser != null && user.getUserId() == anonymousUser.getUserId();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }
}

