/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.model.listener;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PasswordModificationThreadLocal;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

public abstract class BaseLDAPExportModelListener<T extends BaseModel<T>>
extends BaseModelListener<T> {
    private static final CentralizedThreadLocal<String> _lastPasswordUnencrypted = new CentralizedThreadLocal(BaseLDAPExportModelListener.class.getName() + "._lastPasswordUnencrypted");

    protected void exportToLDAP(User user, UserExporter userExporter, LDAPSettings ldapSettings) throws Exception {
        if (user == null || user.isGuestUser() || UserImportTransactionThreadLocal.isOriginatesFromImport()) {
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Callable<Void> callable = () -> {
            boolean oldPasswordModified;
            Map expandoBridgeAttributes = null;
            if (serviceContext != null) {
                expandoBridgeAttributes = serviceContext.getExpandoBridgeAttributes();
            }
            if (oldPasswordModified = PasswordModificationThreadLocal.isPasswordModified()) {
                String newPasswordUnencrypted;
                String lastPasswordUnencrypted = (String)_lastPasswordUnencrypted.get();
                boolean newPasswordModified = !Objects.equals(lastPasswordUnencrypted, newPasswordUnencrypted = PasswordModificationThreadLocal.getPasswordUnencrypted());
                _lastPasswordUnencrypted.set((Object)newPasswordUnencrypted);
                PasswordModificationThreadLocal.setPasswordModified((boolean)newPasswordModified);
            }
            try {
                userExporter.exportUser(user, expandoBridgeAttributes);
            }
            finally {
                PasswordModificationThreadLocal.setPasswordModified((boolean)oldPasswordModified);
            }
            return null;
        };
        if (ldapSettings.isPasswordPolicyEnabled(user.getCompanyId()) && PasswordModificationThreadLocal.isPasswordModified() && user.getLdapServerId() > 0L) {
            callable.call();
        } else {
            TransactionCommitCallbackUtil.registerCallback(callable);
        }
    }
}

