/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.validator;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.ldap.SafeLdapContext;
import com.liferay.portal.security.ldap.SafeLdapFilter;
import com.liferay.portal.security.ldap.SafeLdapName;
import com.liferay.portal.security.ldap.SafeLdapNameFactory;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;

public class SafeLdapContextImpl
implements SafeLdapContext {
    private static final Log _log = LogFactoryUtil.getLog(SafeLdapContextImpl.class);
    private final LdapContext _ldapContext;

    public SafeLdapContextImpl(LdapContext ldapContext) {
        this._ldapContext = ldapContext;
    }

    public Object addToEnvironment(String propertyName, Object propertyValue) throws NamingException {
        return this._ldapContext.addToEnvironment(propertyName, propertyValue);
    }

    public void bind(Name name, Object object) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        this._ldapContext.bind(name, object);
    }

    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        this._ldapContext.bind(name, object, attributes);
    }

    public void bind(String name, Object object) throws NamingException {
        this._logUnsafeMethod();
        this._ldapContext.bind((Name)SafeLdapNameFactory.fromUnsafe((String)name), object);
    }

    public void bind(String name, Object object, Attributes attributes) throws NamingException {
        this._logUnsafeMethod();
        this._ldapContext.bind((Name)SafeLdapNameFactory.fromUnsafe((String)name), object, attributes);
    }

    public void close() throws NamingException {
        this._ldapContext.close();
    }

    public Name composeName(Name name, Name prefixName) throws NamingException {
        if (!(name instanceof SafeLdapName) || !(prefixName instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.composeName(name, prefixName);
    }

    public String composeName(String name, String prefix) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.composeName(name, prefix);
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.createSubcontext(name);
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.createSubcontext(name, attributes);
    }

    public Context createSubcontext(String name) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.createSubcontext((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public DirContext createSubcontext(String name, Attributes attributes) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.createSubcontext((Name)SafeLdapNameFactory.fromUnsafe((String)name), attributes);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        this._ldapContext.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this._logUnsafeMethod();
        this._ldapContext.destroySubcontext((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public ExtendedResponse extendedOperation(ExtendedRequest request) throws NamingException {
        return this._ldapContext.extendedOperation(request);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.getAttributes(name);
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.getAttributes(name, attrIds);
    }

    public Attributes getAttributes(String name) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.getAttributes((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.getAttributes((Name)SafeLdapNameFactory.fromUnsafe((String)name), attrIds);
    }

    public Control[] getConnectControls() throws NamingException {
        return this._ldapContext.getConnectControls();
    }

    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this._ldapContext.getEnvironment();
    }

    public String getNameInNamespace() throws NamingException {
        return this._ldapContext.getNameInNamespace();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.getNameParser((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public Control[] getRequestControls() throws NamingException {
        return this._ldapContext.getRequestControls();
    }

    public Control[] getResponseControls() throws NamingException {
        return this._ldapContext.getResponseControls();
    }

    public DirContext getSchema(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.getSchema(name);
    }

    public DirContext getSchema(String name) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.getSchema((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.getSchemaClassDefinition(name);
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.getSchemaClassDefinition((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.list(name);
    }

    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.list((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.listBindings(name);
    }

    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.listBindings((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public Object lookup(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.lookup(name);
    }

    public Object lookup(String name) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.lookup((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public Object lookupLink(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.lookupLink(name);
    }

    public Object lookupLink(String name) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.lookupLink((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    public void modifyAttributes(Name name, int modOp, Attributes attributes) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        this._ldapContext.modifyAttributes(name, modOp, attributes);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        this._ldapContext.modifyAttributes(name, mods);
    }

    public void modifyAttributes(String name, int modOp, Attributes attributes) throws NamingException {
        this._logUnsafeMethod();
        this._ldapContext.modifyAttributes((Name)SafeLdapNameFactory.fromUnsafe((String)name), modOp, attributes);
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this._logUnsafeMethod();
        this._ldapContext.modifyAttributes((Name)SafeLdapNameFactory.fromUnsafe((String)name), mods);
    }

    public LdapContext newInstance(Control[] requestControls) throws NamingException {
        return this._ldapContext.newInstance(requestControls);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        this._ldapContext.rebind(name, object);
    }

    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        this._ldapContext.rebind(name, object, attributes);
    }

    public void rebind(String name, Object object) throws NamingException {
        this._logUnsafeMethod();
        this._ldapContext.rebind((Name)SafeLdapNameFactory.fromUnsafe((String)name), object);
    }

    public void rebind(String name, Object object, Attributes attributes) throws NamingException {
        this._logUnsafeMethod();
        this._ldapContext.rebind((Name)SafeLdapNameFactory.fromUnsafe((String)name), object, attributes);
    }

    public void reconnect(Control[] connCtls) throws NamingException {
        this._ldapContext.reconnect(connCtls);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this._ldapContext.removeFromEnvironment(propName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (!(oldName instanceof SafeLdapName) || !(newName instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        this._ldapContext.rename(oldName, newName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this._logUnsafeMethod();
        this._ldapContext.rename((Name)SafeLdapNameFactory.fromUnsafe((String)oldName), (Name)SafeLdapNameFactory.fromUnsafe((String)newName));
    }

    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.search(name, matchingAttributes);
    }

    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        return this._ldapContext.search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.search(name, filterExpr, filterArgs, cons);
    }

    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.search(name, filter, cons);
    }

    public NamingEnumeration<SearchResult> search(SafeLdapName safeLdapName, SafeLdapFilter safeLdapFilter, SearchControls searchControls) throws NamingException {
        return this._ldapContext.search((Name)safeLdapName, safeLdapFilter.getFilterString(), safeLdapFilter.getArguments(), searchControls);
    }

    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.search((Name)SafeLdapNameFactory.fromUnsafe((String)name), matchingAttributes);
    }

    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.search((Name)SafeLdapNameFactory.fromUnsafe((String)name), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, Object[] filterArgs, SearchControls cons) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.search((Name)SafeLdapNameFactory.fromUnsafe((String)name), filter, filterArgs, cons);
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        this._logUnsafeMethod();
        return this._ldapContext.search((Name)SafeLdapNameFactory.fromUnsafe((String)name), filter, cons);
    }

    public void setRequestControls(Control[] requestControls) throws NamingException {
        this._ldapContext.setRequestControls(requestControls);
    }

    public String toString() {
        return "{_ldapContext=" + this._ldapContext + "}";
    }

    public void unbind(Name name) throws NamingException {
        if (!(name instanceof SafeLdapName)) {
            this._logUnsafeParameter();
        }
        this._ldapContext.unbind(name);
    }

    public void unbind(String name) throws NamingException {
        this._logUnsafeMethod();
        this._ldapContext.unbind((Name)SafeLdapNameFactory.fromUnsafe((String)name));
    }

    private void _log(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)s, (Throwable)new Exception());
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)s);
        }
    }

    private void _logUnsafeMethod() {
        this._log("Unsafe LDAP method used");
    }

    private void _logUnsafeParameter() {
        this._log("Unsafe LDAP parameter used");
    }
}

