/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.AbstractList;
import org.antlr.misc.Utils;

public class IntArrayList
extends AbstractList
implements Cloneable {
    private static final int DEFAULT_CAPACITY = 10;
    protected int n = 0;
    protected int[] elements = null;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int n) {
        this.elements = new int[n];
    }

    public int set(int n, int n2) {
        if (n >= this.n) {
            this.setSize(n);
        }
        int n3 = this.elements[n];
        this.elements[n] = n2;
        return n3;
    }

    public boolean add(int n) {
        if (this.n >= this.elements.length) {
            this.grow();
        }
        this.elements[this.n] = n;
        ++this.n;
        return true;
    }

    public void setSize(int n) {
        if (n >= this.elements.length) {
            this.ensureCapacity(n);
        }
        this.n = n;
    }

    protected void grow() {
        this.ensureCapacity(this.elements.length * 3 / 2 + 1);
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.n; ++i) {
            int n2 = this.elements[i];
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public void ensureCapacity(int n) {
        int n2 = this.elements.length;
        if (this.n >= n2) {
            int[] nArray = this.elements;
            this.elements = new int[n];
            System.arraycopy(nArray, 0, this.elements, 0, this.n);
        }
    }

    public Object get(int n) {
        return Utils.integer(this.element(n));
    }

    public int element(int n) {
        return this.elements[n];
    }

    public int[] elements() {
        int[] nArray = new int[this.n];
        System.arraycopy(this.elements, 0, nArray, 0, this.n);
        return nArray;
    }

    public int size() {
        return this.n;
    }

    public int capacity() {
        return this.elements.length;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        IntArrayList intArrayList = (IntArrayList)object;
        if (this.size() != intArrayList.size()) {
            return false;
        }
        for (int i = 0; i < this.n; ++i) {
            if (this.elements[i] == intArrayList.elements[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        IntArrayList intArrayList = (IntArrayList)super.clone();
        intArrayList.n = this.n;
        System.arraycopy(this.elements, 0, intArrayList.elements, 0, this.elements.length);
        return intArrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.toString();
    }
}

