/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.analysis.DFA;
import org.antlr.misc.Utils;
import org.antlr.runtime.misc.Stats;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

public class GrammarReport {
    public static final String Version = "4";
    public static final String GRAMMAR_STATS_FILENAME = "grammar.stats";
    public static final int NUM_GRAMMAR_STATS = 41;
    public static final String newline = System.getProperty("line.separator");
    public Grammar grammar;

    public GrammarReport(Grammar grammar) {
        this.grammar = grammar;
    }

    public String toNotifyString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Version);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.name);
        stringBuffer.append('\t');
        stringBuffer.append(Grammar.grammarTypeToString[this.grammar.type]);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.getOption("language"));
        int n = 0;
        int n2 = 0;
        Collection collection = this.grammar.getRules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (Rule)iterator.next();
            if (((Rule)object).name.toUpperCase().startsWith("synpred".toUpperCase())) continue;
            n += ((Rule)object).numberOfAlts;
            ++n2;
        }
        stringBuffer.append('\t');
        stringBuffer.append(n2);
        stringBuffer.append('\t');
        stringBuffer.append(n);
        int n3 = this.grammar.getNumberOfDecisions() - this.grammar.getNumberOfCyclicDecisions();
        object = new int[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[this.grammar.getNumberOfCyclicDecisions()];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 1; i <= this.grammar.getNumberOfDecisions(); ++i) {
            Grammar.Decision decision = this.grammar.getDecision(i);
            if (decision.dfa == null) continue;
            ++n7;
            if (!decision.dfa.isCyclic()) {
                int n8 = decision.dfa.getMaxLookaheadDepth();
                if (n8 == 1) {
                    ++n6;
                }
                object[n4] = n8;
                nArray[n4] = decision.dfa.getNumberOfStates();
                ++n4;
                continue;
            }
            nArray2[n5] = decision.dfa.getNumberOfStates();
            ++n5;
        }
        stringBuffer.append('\t');
        stringBuffer.append(n7);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.getNumberOfCyclicDecisions());
        stringBuffer.append('\t');
        stringBuffer.append(n6);
        stringBuffer.append('\t');
        stringBuffer.append(Stats.min((int[])object));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.max((int[])object));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.avg((int[])object));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.stddev((int[])object));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.min(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.max(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.avg(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.stddev(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.sum(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.min(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.max(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.avg(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.stddev(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.sum(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.getTokenTypes().size());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.DFACreationWallClockTimeInMS);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.numberOfSemanticPredicates);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.numberOfManualLookaheadOptions);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.setOfNondeterministicDecisionNumbers.size());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.setOfNondeterministicDecisionNumbersResolvedWithPredicates.size());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.setOfDFAWhoseConversionTerminatedEarly.size());
        stringBuffer.append('\t');
        stringBuffer.append(ErrorManager.getErrorState().errors);
        stringBuffer.append('\t');
        stringBuffer.append(ErrorManager.getErrorState().warnings);
        stringBuffer.append('\t');
        stringBuffer.append(ErrorManager.getErrorState().infos);
        stringBuffer.append('\t');
        LinkedHashMap linkedHashMap = this.grammar.getSyntacticPredicates();
        int n9 = linkedHashMap != null ? linkedHashMap.size() : 0;
        stringBuffer.append(n9);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.blocksWithSynPreds.size());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.decisionsWhoseDFAsUsesSynPreds.size());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.blocksWithSemPreds.size());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.decisionsWhoseDFAsUsesSemPreds.size());
        stringBuffer.append('\t');
        String string = (String)this.grammar.getOption("output");
        if (string == null) {
            string = "none";
        }
        stringBuffer.append(string);
        stringBuffer.append('\t');
        Object object2 = this.grammar.getOption("k");
        if (object2 == null) {
            object2 = "none";
        }
        stringBuffer.append(object2);
        stringBuffer.append('\t');
        String string2 = (String)this.grammar.getOption("backtrack");
        if (string2 == null) {
            string2 = "false";
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String getBacktrackingReport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Backtracking report:");
        stringBuffer.append(newline);
        stringBuffer.append("Number of decisions that backtrack: ");
        stringBuffer.append(this.grammar.decisionsWhoseDFAsUsesSynPreds.size());
        stringBuffer.append(newline);
        stringBuffer.append(this.getDFALocations(this.grammar.decisionsWhoseDFAsUsesSynPreds));
        return stringBuffer.toString();
    }

    public String getEarlyTerminationReport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NFA conversion early termination report:");
        stringBuffer.append(newline);
        stringBuffer.append("Number of NFA conversions that terminated early: ");
        stringBuffer.append(this.grammar.setOfDFAWhoseConversionTerminatedEarly.size());
        stringBuffer.append(newline);
        stringBuffer.append(this.getDFALocations(this.grammar.setOfDFAWhoseConversionTerminatedEarly));
        return stringBuffer.toString();
    }

    protected String getDFALocations(Set set) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DFA dFA = (DFA)iterator.next();
            if (hashSet.contains(Utils.integer(dFA.decisionNumber))) continue;
            hashSet.add(Utils.integer(dFA.decisionNumber));
            stringBuffer.append("Rule ");
            stringBuffer.append(dFA.decisionNFAStartState.getEnclosingRule());
            stringBuffer.append(" decision ");
            stringBuffer.append(dFA.decisionNumber);
            stringBuffer.append(" location ");
            GrammarAST grammarAST = dFA.decisionNFAStartState.getAssociatedASTNode();
            stringBuffer.append(grammarAST.getLine());
            stringBuffer.append(":");
            stringBuffer.append(grammarAST.getColumn());
            stringBuffer.append(newline);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return GrammarReport.toString(this.toNotifyString());
    }

    protected static String[] decodeReportData(String string) {
        String[] stringArray = new String[41];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        if (n != 41) {
            return null;
        }
        return stringArray;
    }

    public static String toString(String string) {
        String[] stringArray = GrammarReport.decodeReportData(string);
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ANTLR Grammar Report; Stats Version ");
        stringBuffer.append(stringArray[0]);
        stringBuffer.append('\n');
        stringBuffer.append("Grammar: ");
        stringBuffer.append(stringArray[1]);
        stringBuffer.append('\n');
        stringBuffer.append("Type: ");
        stringBuffer.append(stringArray[2]);
        stringBuffer.append('\n');
        stringBuffer.append("Target language: ");
        stringBuffer.append(stringArray[3]);
        stringBuffer.append('\n');
        stringBuffer.append("Output: ");
        stringBuffer.append(stringArray[38]);
        stringBuffer.append('\n');
        stringBuffer.append("Grammar option k: ");
        stringBuffer.append(stringArray[39]);
        stringBuffer.append('\n');
        stringBuffer.append("Grammar option backtrack: ");
        stringBuffer.append(stringArray[40]);
        stringBuffer.append('\n');
        stringBuffer.append("Rules: ");
        stringBuffer.append(stringArray[4]);
        stringBuffer.append('\n');
        stringBuffer.append("Productions: ");
        stringBuffer.append(stringArray[5]);
        stringBuffer.append('\n');
        stringBuffer.append("Decisions: ");
        stringBuffer.append(stringArray[6]);
        stringBuffer.append('\n');
        stringBuffer.append("Cyclic DFA decisions: ");
        stringBuffer.append(stringArray[7]);
        stringBuffer.append('\n');
        stringBuffer.append("LL(1) decisions: ");
        stringBuffer.append(stringArray[8]);
        stringBuffer.append('\n');
        stringBuffer.append("Min fixed k: ");
        stringBuffer.append(stringArray[9]);
        stringBuffer.append('\n');
        stringBuffer.append("Max fixed k: ");
        stringBuffer.append(stringArray[10]);
        stringBuffer.append('\n');
        stringBuffer.append("Average fixed k: ");
        stringBuffer.append(stringArray[11]);
        stringBuffer.append('\n');
        stringBuffer.append("Standard deviation of fixed k: ");
        stringBuffer.append(stringArray[12]);
        stringBuffer.append('\n');
        stringBuffer.append("Min acyclic DFA states: ");
        stringBuffer.append(stringArray[13]);
        stringBuffer.append('\n');
        stringBuffer.append("Max acyclic DFA states: ");
        stringBuffer.append(stringArray[14]);
        stringBuffer.append('\n');
        stringBuffer.append("Average acyclic DFA states: ");
        stringBuffer.append(stringArray[15]);
        stringBuffer.append('\n');
        stringBuffer.append("Standard deviation of acyclic DFA states: ");
        stringBuffer.append(stringArray[16]);
        stringBuffer.append('\n');
        stringBuffer.append("Total acyclic DFA states: ");
        stringBuffer.append(stringArray[17]);
        stringBuffer.append('\n');
        stringBuffer.append("Min cyclic DFA states: ");
        stringBuffer.append(stringArray[18]);
        stringBuffer.append('\n');
        stringBuffer.append("Max cyclic DFA states: ");
        stringBuffer.append(stringArray[19]);
        stringBuffer.append('\n');
        stringBuffer.append("Average cyclic DFA states: ");
        stringBuffer.append(stringArray[20]);
        stringBuffer.append('\n');
        stringBuffer.append("Standard deviation of cyclic DFA states: ");
        stringBuffer.append(stringArray[21]);
        stringBuffer.append('\n');
        stringBuffer.append("Total cyclic DFA states: ");
        stringBuffer.append(stringArray[22]);
        stringBuffer.append('\n');
        stringBuffer.append("Vocabulary size: ");
        stringBuffer.append(stringArray[23]);
        stringBuffer.append('\n');
        stringBuffer.append("DFA creation time in ms: ");
        stringBuffer.append(stringArray[24]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of semantic predicates found: ");
        stringBuffer.append(stringArray[25]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of manual fixed lookahead k=value options: ");
        stringBuffer.append(stringArray[26]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of nondeterministic decisions: ");
        stringBuffer.append(stringArray[27]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of nondeterministic decisions resolved with predicates: ");
        stringBuffer.append(stringArray[28]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of DFA conversions terminated early: ");
        stringBuffer.append(stringArray[29]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of errors: ");
        stringBuffer.append(stringArray[30]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of warnings: ");
        stringBuffer.append(stringArray[31]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of infos: ");
        stringBuffer.append(stringArray[32]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of syntactic predicates found: ");
        stringBuffer.append(stringArray[33]);
        stringBuffer.append('\n');
        stringBuffer.append("Decisions with syntactic predicates: ");
        stringBuffer.append(stringArray[34]);
        stringBuffer.append('\n');
        stringBuffer.append("Decision DFAs using syntactic predicates: ");
        stringBuffer.append(stringArray[35]);
        stringBuffer.append('\n');
        stringBuffer.append("Decisions with semantic predicates: ");
        stringBuffer.append(stringArray[36]);
        stringBuffer.append('\n');
        stringBuffer.append("Decision DFAs using semantic predicates: ");
        stringBuffer.append(stringArray[37]);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

