/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission.internal;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNode;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.WhereStep;
import com.liferay.petra.sql.dsl.spi.ast.BaseASTNode;
import com.liferay.petra.sql.dsl.spi.query.Where;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourcePermissionTable;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.contributor.PermissionSQLContributor;
import com.liferay.portal.security.permission.internal.configuration.InlinePermissionConfiguration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.permission.internal.configuration.InlinePermissionConfiguration"}, service={InlineSQLHelper.class})
public class InlineSQLHelperImpl
implements InlineSQLHelper {
    public static final String FIND_BY_RESOURCE_PERMISSION = InlineSQLHelper.class.getName() + ".findByResourcePermission";
    private static final String _GROUP_BY_CLAUSE = " GROUP BY ";
    private static final String _ORDER_BY_CLAUSE = " ORDER BY ";
    private static final String _WHERE_CLAUSE = " WHERE ";
    private static final Log _log = LogFactoryUtil.getLog(InlineSQLHelperImpl.class);
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private GroupLocalService _groupLocalService;
    private volatile InlinePermissionConfiguration _inlinePermissionConfiguration;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private ServiceTrackerMap<String, List<PermissionSQLContributor>> _serviceTrackerMap;

    public <T extends Table<T>> Predicate getPermissionWherePredicate(Class<?> modelClass, Column<T, Long> classPKColumn, long ... groupIds) {
        return this.getPermissionWherePredicate(modelClass.getName(), classPKColumn, groupIds);
    }

    public <T extends Table<T>> Predicate getPermissionWherePredicate(String modelClassName, Column<T, Long> classPKColumn, long ... groupIds) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            groupIds = new long[]{0L};
        }
        if (this._skipReplace(permissionChecker, modelClassName, classPKColumn, groupIds)) {
            return null;
        }
        return this._getPermissionWherePredicate(permissionChecker, modelClassName, classPKColumn, groupIds);
    }

    public boolean isEnabled() {
        return this.isEnabled(0L);
    }

    public boolean isEnabled(long groupId) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            throw new IllegalStateException("Permission checker is null");
        }
        return this.isEnabled(permissionChecker.getCompanyId(), groupId);
    }

    public boolean isEnabled(long companyId, long groupId) {
        if (!this._inlinePermissionConfiguration.sqlCheckEnabled()) {
            return false;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            throw new IllegalStateException("Permission checker is null");
        }
        return !(groupId > 0L ? permissionChecker.isGroupAdmin(groupId) || permissionChecker.isGroupOwner(groupId) : (companyId > 0L ? permissionChecker.isCompanyAdmin(companyId) : permissionChecker.isOmniadmin()));
    }

    public boolean isEnabled(long[] groupIds) {
        if (!this._inlinePermissionConfiguration.sqlCheckEnabled()) {
            return false;
        }
        for (long groupId : groupIds) {
            if (!this.isEnabled(groupId)) continue;
            return true;
        }
        return false;
    }

    public <T extends Table<T>> DSLQuery replacePermissionCheck(DSLQuery dslQuery, Class<?> modelClass, Column<T, Long> classPKColumn, long ... groupIds) {
        Predicate permissionWherePredicate = this.getPermissionWherePredicate(modelClass, classPKColumn, groupIds);
        if (permissionWherePredicate == null) {
            return dslQuery;
        }
        return this._insertResourcePermissionQuery(dslQuery, permissionWherePredicate);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField) {
        return this.replacePermissionCheck(sql, className, classPKField, null, new long[]{0L}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long groupId) {
        return this.replacePermissionCheck(sql, className, classPKField, null, new long[]{groupId}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long groupId, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, null, new long[]{groupId}, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long[] groupIds) {
        return this.replacePermissionCheck(sql, className, classPKField, null, groupIds, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long[] groupIds, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, null, groupIds, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{0L}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long groupId) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{groupId}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long groupId, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{groupId}, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long[] groupIds) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, groupIds, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long[] groupIds, String bridgeJoin) {
        String groupIdField = classPKField.substring(0, classPKField.lastIndexOf(46));
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, groupIdField.concat(".groupId"), groupIds, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, 0L, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, String groupIdField, long[] groupIds, String bridgeJoin) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (sql == null || this._skipReplace(permissionChecker, className, classPKField, groupIds)) {
            return sql;
        }
        String resourcePermissionSQL = this._getResourcePermissionSQL(permissionChecker, className, userIdField, groupIds, bridgeJoin);
        return this._insertResourcePermissionSQL(sql, className, classPKField, userIdField, groupIdField, groupIds, resourcePermissionSQL);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, PermissionSQLContributor.class, (String)"model.class.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._inlinePermissionConfiguration = (InlinePermissionConfiguration)ConfigurableUtil.createConfigurable(InlinePermissionConfiguration.class, properties);
    }

    private void _appendPermissionSQL(StringBundler sb, String className, String classPKField, String userIdField, String groupIdField, long[] groupIds, String permissionSQL) {
        List permissionSQLContributors = (List)this._serviceTrackerMap.getService((Object)className);
        StringBundler permissionSQLContributorsSQLSB = null;
        if (permissionSQLContributors != null && !permissionSQLContributors.isEmpty()) {
            permissionSQLContributorsSQLSB = new StringBundler(permissionSQLContributors.size() * 3);
            for (PermissionSQLContributor permissionSQLContributor : permissionSQLContributors) {
                String contributorPermissionSQL = permissionSQLContributor.getPermissionSQL(className, classPKField, userIdField, groupIdField, groupIds);
                if (Validator.isNull((String)contributorPermissionSQL)) continue;
                permissionSQLContributorsSQLSB.append("OR (");
                permissionSQLContributorsSQLSB.append(contributorPermissionSQL);
                permissionSQLContributorsSQLSB.append(") ");
            }
        }
        StringBundler groupAdminResourcePermissionSB = null;
        for (long groupId : groupIds) {
            if (this.isEnabled(groupId)) continue;
            if (groupAdminResourcePermissionSB == null) {
                groupAdminResourcePermissionSB = new StringBundler(groupIds.length * 2 - 1);
            } else {
                groupAdminResourcePermissionSB.append(", ");
            }
            groupAdminResourcePermissionSB.append(groupId);
        }
        if (permissionSQLContributorsSQLSB != null || groupAdminResourcePermissionSB != null) {
            sb.append("(");
        }
        sb.append("(");
        sb.append(classPKField);
        sb.append(" IN (");
        sb.append(permissionSQL);
        sb.append(")) ");
        if (permissionSQLContributorsSQLSB != null) {
            sb.append(permissionSQLContributorsSQLSB);
        }
        if (groupAdminResourcePermissionSB != null) {
            sb.append(" OR (");
            sb.append(groupIdField);
            sb.append(" IN (");
            sb.append(groupAdminResourcePermissionSB);
            sb.append(")) ");
        }
        if (permissionSQLContributorsSQLSB != null || groupAdminResourcePermissionSB != null) {
            sb.append(") ");
        }
    }

    private <T extends Table<T>> Predicate _getPermissionWherePredicate(PermissionChecker permissionChecker, String modelClassName, Column<T, Long> classPKColumn, long[] groupIds) {
        DSLQuery resourcePermissionDSLQuery = this._getResourcePermissionQuery(permissionChecker, modelClassName, groupIds);
        Predicate permissionWherePredicate = classPKColumn.in(resourcePermissionDSLQuery);
        List permissionSQLContributors = (List)this._serviceTrackerMap.getService((Object)modelClassName);
        if (permissionSQLContributors != null && !permissionSQLContributors.isEmpty()) {
            for (PermissionSQLContributor permissionSQLContributor : permissionSQLContributors) {
                Predicate contributorPermissionWherePredicate = permissionSQLContributor.getPermissionPredicate(permissionChecker, modelClassName, classPKColumn, groupIds);
                permissionWherePredicate = permissionWherePredicate.or(() -> {
                    if (contributorPermissionWherePredicate != null) {
                        return contributorPermissionWherePredicate.withParentheses();
                    }
                    return null;
                });
            }
        }
        LinkedHashSet<Long> groupIdSet = null;
        for (long groupId : groupIds) {
            if (this.isEnabled(groupId)) continue;
            if (groupIdSet == null) {
                groupIdSet = new LinkedHashSet<Long>();
            }
            groupIdSet.add(groupId);
        }
        if (groupIdSet != null) {
            Table table = classPKColumn.getTable();
            Column groupIdColumn = table.getColumn("groupId", Long.class);
            if (groupIdColumn == null) {
                throw new IllegalArgumentException("No groupId column for table " + table.getTableName());
            }
            permissionWherePredicate = permissionWherePredicate.or((Expression)groupIdColumn.in((Object[])groupIdSet.toArray(new Long[0])));
            permissionWherePredicate = permissionWherePredicate.withParentheses();
        }
        return permissionWherePredicate;
    }

    private DSLQuery _getResourcePermissionQuery(PermissionChecker permissionChecker, String modelClassName, long[] groupIds) {
        Predicate roleIdsOrOwnerIdsPredicate = null;
        long[] roleIds = this._getRoleIds(groupIds);
        if (roleIds.length > 0) {
            roleIdsOrOwnerIdsPredicate = ResourcePermissionTable.INSTANCE.roleId.in((Object[])ArrayUtil.toLongArray((long[])roleIds));
        }
        if (permissionChecker.isSignedIn()) {
            Column ownerIdExpression = ResourcePermissionTable.INSTANCE.ownerId;
            Predicate ownerIdPredicate = ownerIdExpression.eq((Object)permissionChecker.getUserId());
            roleIdsOrOwnerIdsPredicate = roleIdsOrOwnerIdsPredicate == null ? ownerIdPredicate : roleIdsOrOwnerIdsPredicate.or((Expression)ownerIdPredicate);
        }
        Predicate predicate = ResourcePermissionTable.INSTANCE.companyId.eq((Object)permissionChecker.getCompanyId()).and((Expression)ResourcePermissionTable.INSTANCE.name.eq((Object)modelClassName)).and((Expression)ResourcePermissionTable.INSTANCE.scope.eq((Object)4)).and((Expression)ResourcePermissionTable.INSTANCE.viewActionId.eq((Object)true));
        if (roleIdsOrOwnerIdsPredicate != null) {
            predicate = predicate.and((Expression)roleIdsOrOwnerIdsPredicate.withParentheses());
        }
        return DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{ResourcePermissionTable.INSTANCE.primKeyId}).from((Table)ResourcePermissionTable.INSTANCE).where(predicate);
    }

    private String _getResourcePermissionSQL(PermissionChecker permissionChecker, String className, String userIdField, long[] groupIds, String bridgeJoin) {
        String resourcePermissionSQL = this._customSQL.get(this.getClass(), FIND_BY_RESOURCE_PERMISSION);
        if (Validator.isNotNull((String)bridgeJoin)) {
            resourcePermissionSQL = bridgeJoin.concat(resourcePermissionSQL);
        }
        StringBundler sb = new StringBundler(8);
        long[] roleIds = this._getRoleIds(groupIds);
        if (roleIds.length > 0) {
            sb.append("(ResourcePermission.roleId IN (");
            sb.append(StringUtil.merge((long[])roleIds));
            sb.append(")");
        }
        if (permissionChecker.isSignedIn()) {
            if (roleIds.length > 0) {
                sb.append(" OR ");
            } else {
                sb.append("(");
            }
            long userId = permissionChecker.getUserId();
            if (Validator.isNull((String)userIdField)) {
                sb.append("ResourcePermission.ownerId = ");
                sb.append(userId);
            } else {
                sb.append(userIdField);
                sb.append(" = ");
                sb.append(userId);
            }
            sb.append(")");
        } else if (roleIds.length > 0) {
            sb.append(")");
        }
        String roleIdsOrOwnerIdSQL = sb.toString();
        int scope = 4;
        String selectOptimizer = "";
        if (DBManagerUtil.getDBType() == DBType.MYSQL) {
            selectOptimizer = "/*+ SUBQUERY(MATERIALIZATION) */";
        }
        return StringUtil.replace((String)resourcePermissionSQL, (String[])new String[]{"[$CLASS_NAME$]", "[$COMPANY_ID$]", "[$RESOURCE_SCOPE_INDIVIDUAL$]", "[$ROLE_IDS_OR_OWNER_ID$]", "[$SELECT_OPTIMIZER$]"}, (String[])new String[]{className, String.valueOf(permissionChecker.getCompanyId()), String.valueOf(scope), roleIdsOrOwnerIdSQL, selectOptimizer});
    }

    private long[] _getRoleIds(long groupId) {
        long[] roleIds = PermissionChecker.DEFAULT_ROLE_IDS;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            roleIds = permissionChecker.getRoleIds(permissionChecker.getUserId(), groupId);
        }
        return roleIds;
    }

    private long[] _getRoleIds(long[] groupIds) {
        if (groupIds.length == 1) {
            return this._getRoleIds(groupIds[0]);
        }
        HashSet<Long> roleIds = new HashSet<Long>();
        for (long groupId : groupIds) {
            for (long roleId : this._getRoleIds(groupId)) {
                roleIds.add(roleId);
            }
        }
        return ArrayUtil.toLongArray(roleIds);
    }

    private DSLQuery _insertResourcePermissionQuery(DSLQuery dslQuery, Predicate permissionWherePredicate) {
        if (dslQuery instanceof WhereStep) {
            WhereStep whereStep = (WhereStep)dslQuery;
            return whereStep.where(permissionWherePredicate);
        }
        WhereStep whereStep = null;
        Where where = null;
        LinkedList<BaseASTNode> baseASTNodes = new LinkedList<BaseASTNode>();
        DSLQuery astNode = dslQuery;
        while (astNode instanceof BaseASTNode) {
            BaseASTNode baseASTNode = (BaseASTNode)astNode;
            if (baseASTNode instanceof WhereStep) {
                whereStep = (WhereStep)baseASTNode;
                break;
            }
            if (baseASTNode instanceof Where) {
                where = (Where)baseASTNode;
            } else {
                baseASTNodes.push(baseASTNode);
            }
            astNode = baseASTNode.getChild();
        }
        if (whereStep == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to replace permission check for \"", dslQuery, "\", if this is a union pass in the left or right queries ", "separately"}));
        }
        GroupByStep childASTNode = null;
        if (where == null) {
            childASTNode = whereStep.where(permissionWherePredicate);
        } else {
            Predicate predicate = where.getPredicate();
            childASTNode = new Where(whereStep, predicate.and((Expression)permissionWherePredicate));
        }
        for (BaseASTNode baseASTNode : baseASTNodes) {
            childASTNode = baseASTNode.withNewChild((ASTNode)childASTNode);
        }
        return (DSLQuery)childASTNode;
    }

    private String _insertResourcePermissionSQL(String sql, String className, String classPKField, String userIdField, String groupIdField, long[] groupIds, String permissionSQL) {
        StringBundler sb = new StringBundler(11);
        int pos = sql.lastIndexOf(_WHERE_CLAUSE);
        if (pos == -1) {
            pos = sql.indexOf(_GROUP_BY_CLAUSE);
            if (pos == -1) {
                pos = sql.indexOf(_ORDER_BY_CLAUSE);
            }
            if (pos == -1) {
                sb.append(sql);
            } else {
                sb.append(sql.substring(0, pos));
            }
            sb.append(_WHERE_CLAUSE);
            this._appendPermissionSQL(sb, className, classPKField, userIdField, groupIdField, groupIds, permissionSQL);
            if (pos != -1) {
                sb.append(sql.substring(pos));
            }
        } else {
            sb.append(sql.substring(0, pos += _WHERE_CLAUSE.length()));
            this._appendPermissionSQL(sb, className, classPKField, userIdField, groupIdField, groupIds, permissionSQL);
            sb.append("AND ");
            sb.append(sql.substring(pos));
        }
        return sb.toString();
    }

    private boolean _skipReplace(PermissionChecker permissionChecker, String className, Object classPKField, long[] groupIds) {
        block16: {
            if (!this.isEnabled(groupIds)) {
                return true;
            }
            if (Validator.isNull((String)className)) {
                throw new IllegalArgumentException("className is null");
            }
            if (Objects.equals(className, AssetTag.class.getName())) {
                throw new IllegalArgumentException("AssetTag does not support inline permissions. See LPS-82433.");
            }
            if (Validator.isNull((Object)classPKField)) {
                throw new IllegalArgumentException("classPKField is null");
            }
            long companyId = permissionChecker.getCompanyId();
            if (groupIds.length == 1) {
                long groupId = groupIds[0];
                Group group = this._groupLocalService.fetchGroup(groupId);
                if (group != null) {
                    long[] roleIds = this._getRoleIds(groupId);
                    try {
                        if (this._resourcePermissionLocalService.hasResourcePermission(companyId, className, 2, String.valueOf(groupId), roleIds, "VIEW") || this._resourcePermissionLocalService.hasResourcePermission(companyId, className, 3, String.valueOf(0L), roleIds, "VIEW")) {
                            return true;
                        }
                    }
                    catch (PortalException portalException) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to get resource permissions for ", className, " with group ", groupId}), (Throwable)portalException);
                        }
                    }
                }
            } else {
                for (long groupId : groupIds) {
                    Group group = this._groupLocalService.fetchGroup(groupId);
                    if (group == null || group.getCompanyId() == companyId) continue;
                    throw new IllegalArgumentException("Permission queries across multiple portal instances are not supported");
                }
            }
            try {
                if (this._resourcePermissionLocalService.hasResourcePermission(companyId, className, 1, String.valueOf(companyId), this._getRoleIds(ArrayUtil.append((long[])groupIds, (long)0L)), "VIEW")) {
                    return true;
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block16;
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to get resource permissions for ", className, " with company ", companyId}), (Throwable)portalException);
            }
        }
        return false;
    }
}

