/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission.internal.converter;

import com.liferay.portal.kernel.model.Permission;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.PermissionConversionFilter;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.model.impl.PermissionImpl;
import com.liferay.portal.security.permission.converter.PermissionConverter;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PermissionConverter.class})
public class PermissionConverterImpl
implements PermissionConverter {
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;

    public List<Permission> convertPermissions(Role role) {
        return this.convertPermissions(role, null);
    }

    public List<Permission> convertPermissions(Role role, PermissionConversionFilter permissionConversionFilter) {
        int[] scopes = new int[]{};
        if (role.getType() == 1) {
            scopes = new int[]{1, 2};
        } else if (role.getType() == 5 || role.getType() == 3 || role.getType() == 4 || role.getType() == 2) {
            scopes = new int[]{3};
        } else if (role.getType() == 6) {
            scopes = new int[]{1, 2, 3};
        } else if (role.getType() == 7) {
            scopes = new int[]{1, 3};
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        List resourcePermissions = this._resourcePermissionLocalService.getRoleResourcePermissions(role.getRoleId(), scopes, -1, -1);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (permissionConversionFilter != null && !permissionConversionFilter.accept(role, resourcePermission)) continue;
            List resourceActions = this._resourceActionLocalService.getResourceActions(resourcePermission.getName());
            for (ResourceAction resourceAction : resourceActions) {
                if (!this._resourcePermissionLocalService.hasActionId(resourcePermission, resourceAction)) continue;
                PermissionImpl permission = new PermissionImpl();
                permission.setName(resourcePermission.getName());
                permission.setScope(resourcePermission.getScope());
                permission.setPrimKey(resourcePermission.getPrimKey());
                permission.setActionId(resourceAction.getActionId());
                permissions.add((Permission)permission);
            }
        }
        return permissions;
    }
}

