/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.internal;

import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.service.access.policy.ServiceAccessPolicy;
import com.liferay.portal.kernel.security.service.access.policy.ServiceAccessPolicyManager;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.security.service.access.policy.configuration.SAPConfiguration;
import com.liferay.portal.security.service.access.policy.internal.ServiceAccessPolicyImpl;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceAccessPolicyManager.class})
public class ServiceAccessPolicyManagerImpl
implements ServiceAccessPolicyManager {
    private static final Log _log = LogFactoryUtil.getLog(ServiceAccessPolicyManagerImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private SAPEntryService _sapEntryService;

    public String getDefaultApplicationServiceAccessPolicyName(long companyId) {
        SAPConfiguration sapConfiguration = this._getSAPConfiguration(companyId);
        if (sapConfiguration != null) {
            return sapConfiguration.systemDefaultSAPEntryName();
        }
        return null;
    }

    public String getDefaultUserServiceAccessPolicyName(long companyId) {
        SAPConfiguration sapConfiguration = this._getSAPConfiguration(companyId);
        if (sapConfiguration != null) {
            return sapConfiguration.systemUserPasswordSAPEntryName();
        }
        return null;
    }

    public List<ServiceAccessPolicy> getServiceAccessPolicies(long companyId, int start, int end) {
        return this._toServiceAccessPolicies(this._sapEntryService.getCompanySAPEntries(companyId, start, end));
    }

    public int getServiceAccessPoliciesCount(long companyId) {
        return this._sapEntryService.getCompanySAPEntriesCount(companyId);
    }

    public ServiceAccessPolicy getServiceAccessPolicy(long companyId, String name) {
        try {
            return this._toServiceAccessPolicy(this._sapEntryService.getSAPEntry(companyId, name));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private SAPConfiguration _getSAPConfiguration(long companyId) {
        try {
            return (SAPConfiguration)this._configurationProvider.getConfiguration(SAPConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.service.access.policy"));
        }
        catch (ConfigurationException configurationException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get SAP configuration", (Throwable)configurationException);
            }
            return null;
        }
    }

    private List<ServiceAccessPolicy> _toServiceAccessPolicies(List<SAPEntry> sapEntries) {
        if (sapEntries == null) {
            return null;
        }
        ArrayList<ServiceAccessPolicy> serviceAccessPolicies = new ArrayList<ServiceAccessPolicy>(sapEntries.size());
        for (SAPEntry sapEntry : sapEntries) {
            ServiceAccessPolicy serviceAccessPolicy = this._toServiceAccessPolicy(sapEntry);
            serviceAccessPolicies.add(serviceAccessPolicy);
        }
        return serviceAccessPolicies;
    }

    private ServiceAccessPolicy _toServiceAccessPolicy(SAPEntry sapEntry) {
        if (sapEntry != null) {
            return new ServiceAccessPolicyImpl(sapEntry);
        }
        return null;
    }
}

