/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class PasswordPolicyModelListener
extends BaseModelListener<PasswordPolicy> {
    @Reference
    protected SAPEntryLocalService sapEntryLocalService;

    public void onAfterCreate(PasswordPolicy passwordPolicy) throws ModelListenerException {
        if (!passwordPolicy.isDefaultPolicy()) {
            return;
        }
        try {
            this.sapEntryLocalService.checkSystemSAPEntries(passwordPolicy.getCompanyId());
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onBeforeRemove(PasswordPolicy passwordPolicy) throws ModelListenerException {
        if (!passwordPolicy.isDefaultPolicy()) {
            return;
        }
        try {
            List sapEntries = this.sapEntryLocalService.getCompanySAPEntries(passwordPolicy.getCompanyId(), -1, -1);
            for (SAPEntry sapEntry : sapEntries) {
                this.sapEntryLocalService.deleteSAPEntry(sapEntry);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

