/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.internal.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.security.service.access.policy.model.SAPEntry"}, service={ModelResourcePermission.class})
public class SAPEntryModelResourcePermission
implements ModelResourcePermission<SAPEntry> {
    @Reference(target="(resource.name=com.liferay.portal.security.service.access.policy)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;

    public void check(PermissionChecker permissionChecker, long sapEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, sapEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, SAPEntry.class.getName(), sapEntryId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, SAPEntry sapEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, sapEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, SAPEntry.class.getName(), sapEntry.getSapEntryId(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long sapEntryId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._sapEntryLocalService.getSAPEntry(sapEntryId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, SAPEntry sapEntry, String actionId) throws PortalException {
        return permissionChecker.hasPermission(null, SAPEntry.class.getName(), sapEntry.getSapEntryId(), actionId);
    }

    public String getModelName() {
        return SAPEntry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

