/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.internal.upgrade.v3_0_1;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Map;

public class SAPEntryUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from SAPEntry where ", "companyId = ", companyId, " and name = ", "'SYSTEM_REST_CLIENT_TEMPLATE_OBJECT'"}));){
                ResultSet resultSet = preparedStatement1.executeQuery();
                resultSet.next();
                int count = resultSet.getInt(1);
                if (count != 0) {
                    return;
                }
                StringBuilder sb = new StringBuilder(5);
                sb.append("insert into SAPEntry (uuid_, sapEntryId, ");
                sb.append("companyId, userId, createDate, ");
                sb.append("modifiedDate, allowedServiceSignatures, ");
                sb.append("defaultSAPEntry, enabled, name, title) ");
                sb.append("values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                PreparedStatement preparedStatement2 = this.connection.prepareStatement(sb.toString());
                preparedStatement2.setString(1, PortalUUIDUtil.generate());
                long sapEntryId = CounterLocalServiceUtil.increment();
                preparedStatement2.setLong(2, sapEntryId);
                preparedStatement2.setLong(3, (long)companyId);
                preparedStatement2.setLong(4, UserLocalServiceUtil.getGuestUserId((long)companyId));
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                preparedStatement2.setTimestamp(5, timestamp);
                preparedStatement2.setTimestamp(6, timestamp);
                preparedStatement2.setString(7, "*");
                preparedStatement2.setBoolean(8, false);
                preparedStatement2.setBoolean(9, true);
                preparedStatement2.setString(10, "SYSTEM_REST_CLIENT_TEMPLATE_OBJECT");
                String title = "System Service Access Policy for REST Client Template Requests";
                preparedStatement2.setString(11, LocalizationUtil.updateLocalization((Map)HashMapBuilder.put((Object)LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId)), (Object)title).build(), (String)title, (String)"Title", (String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId)));
                preparedStatement2.execute();
                Role guestRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
                ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)SAPEntry.class.getName(), (int)4, (String)String.valueOf(sapEntryId), (long)guestRole.getRoleId(), (String[])new String[]{"VIEW"});
            }
        });
    }
}

