/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.internal.verify;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import com.liferay.portal.verify.VerifyProcess;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"initial.deployment=true"}, service={VerifyProcess.class})
public class SAPServiceVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(SAPServiceVerifyProcess.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;

    public void verifyDefaultSAPEntry() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._companyLocalService.forEachCompanyId(companyId -> {
                try {
                    this._sapEntryLocalService.checkSystemSAPEntries(companyId.longValue());
                }
                catch (PortalException portalException) {
                    _log.error((Object)("Unable to add default service access policy for company " + companyId), (Throwable)portalException);
                }
            });
        }
    }

    protected void doVerify() throws Exception {
        this.verifyDefaultSAPEntry();
    }
}

