/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.model.impl;

import com.liferay.osgi.util.StringPlus;
import com.liferay.portal.configuration.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.service.access.policy.configuration.SAPConfiguration;
import com.liferay.portal.security.service.access.policy.model.impl.SAPEntryBaseImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class SAPEntryImpl
extends SAPEntryBaseImpl {
    public List<String> getAllowedServiceSignaturesList() {
        Object[] allowedServiceSignatures = StringUtil.split((String)this.getAllowedServiceSignatures(), (String)"\n");
        return ListUtil.fromArray((Object[])allowedServiceSignatures);
    }

    public boolean isSystem() throws ConfigurationException {
        SAPConfiguration sapConfiguration = (SAPConfiguration)ConfigurationProviderUtil.getConfiguration(SAPConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(this.getCompanyId(), "com.liferay.portal.security.service.access.policy"));
        return Objects.equals(this.getName(), sapConfiguration.systemDefaultSAPEntryName()) || Objects.equals(this.getName(), sapConfiguration.systemUserPasswordSAPEntryName()) || SAPSystemEntriesHolder.contains(this.getName());
    }

    private static class SAPSystemEntriesHolder {
        private static final Set<String> _sapSystemEntries = Collections.newSetFromMap(new ConcurrentHashMap());

        private SAPSystemEntriesHolder() {
        }

        public static boolean contains(String name) {
            return _sapSystemEntries.contains(name);
        }

        static {
            try {
                Bundle bundle = FrameworkUtil.getBundle(SAPEntryImpl.class);
                BundleContext bundleContext = bundle.getBundleContext();
                ServiceTracker serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter("(sap.system.entry=*)"), (ServiceTrackerCustomizer)new SAPSystemEntryServiceTrackerCustomizer());
                serviceTracker.open();
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw new ExceptionInInitializerError(invalidSyntaxException);
            }
        }

        private static class SAPSystemEntryServiceTrackerCustomizer
        implements ServiceTrackerCustomizer<Object, Set<String>> {
            private static final Map<Object, Set<String>> _serviceReferenceMap = new HashMap<Object, Set<String>>();

            private SAPSystemEntryServiceTrackerCustomizer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set<String> addingService(ServiceReference<Object> serviceReference) {
                HashSet<String> sapSystemEntries = new HashSet<String>(StringPlus.asList((Object)serviceReference.getProperty("sap.system.entry")));
                SAPSystemEntryServiceTrackerCustomizer sAPSystemEntryServiceTrackerCustomizer = this;
                synchronized (sAPSystemEntryServiceTrackerCustomizer) {
                    _serviceReferenceMap.put(serviceReference, sapSystemEntries);
                    _sapSystemEntries.addAll(sapSystemEntries);
                }
                return sapSystemEntries;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifiedService(ServiceReference<Object> serviceReference, Set<String> sapSystemEntries) {
                HashSet newSAPSystemEntries = new HashSet(StringPlus.asList((Object)serviceReference.getProperty("sap.system.entry")));
                if (newSAPSystemEntries.equals(sapSystemEntries)) {
                    return;
                }
                SAPSystemEntryServiceTrackerCustomizer sAPSystemEntryServiceTrackerCustomizer = this;
                synchronized (sAPSystemEntryServiceTrackerCustomizer) {
                    _serviceReferenceMap.put(serviceReference, newSAPSystemEntries);
                    _sapSystemEntries.addAll(newSAPSystemEntries);
                    this._reindexSAPSystemEntries(sapSystemEntries);
                }
                sapSystemEntries.clear();
                sapSystemEntries.addAll(newSAPSystemEntries);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<Object> serviceReference, Set<String> sapSystemEntries) {
                SAPSystemEntryServiceTrackerCustomizer sAPSystemEntryServiceTrackerCustomizer = this;
                synchronized (sAPSystemEntryServiceTrackerCustomizer) {
                    _serviceReferenceMap.remove(serviceReference);
                    this._reindexSAPSystemEntries(sapSystemEntries);
                }
            }

            private void _reindexSAPSystemEntries(Set<String> removedSAPSystemEntries) {
                for (Set<String> sapSystemEntries : _serviceReferenceMap.values()) {
                    removedSAPSystemEntries.removeAll(sapSystemEntries);
                    if (!removedSAPSystemEntries.isEmpty()) continue;
                    return;
                }
                _sapSystemEntries.removeAll(removedSAPSystemEntries);
            }
        }
    }
}

