/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import com.liferay.portal.security.service.access.policy.service.persistence.SAPEntryPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class SAPEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
SAPEntryLocalService {
    protected SAPEntryLocalService sapEntryLocalService;
    @Reference
    protected SAPEntryPersistence sapEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(SAPEntryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public SAPEntry addSAPEntry(SAPEntry sapEntry) {
        sapEntry.setNew(true);
        return (SAPEntry)this.sapEntryPersistence.update((BaseModel)sapEntry);
    }

    @Transactional(enabled=false)
    public SAPEntry createSAPEntry(long sapEntryId) {
        return this.sapEntryPersistence.create(sapEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SAPEntry deleteSAPEntry(long sapEntryId) throws PortalException {
        return this.sapEntryPersistence.remove(sapEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SAPEntry deleteSAPEntry(SAPEntry sapEntry) throws PortalException {
        return (SAPEntry)this.sapEntryPersistence.remove((BaseModel)sapEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.sapEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(SAPEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.sapEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.sapEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.sapEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.sapEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.sapEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public SAPEntry fetchSAPEntry(long sapEntryId) {
        return this.sapEntryPersistence.fetchByPrimaryKey(sapEntryId);
    }

    public SAPEntry fetchSAPEntryByUuidAndCompanyId(String uuid, long companyId) {
        return this.sapEntryPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public SAPEntry getSAPEntry(long sapEntryId) throws PortalException {
        return this.sapEntryPersistence.findByPrimaryKey(sapEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.sapEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SAPEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("sapEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.sapEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(SAPEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("sapEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.sapEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SAPEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("sapEntryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<SAPEntry>(){

            public void performAction(SAPEntry sapEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)sapEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)SAPEntry.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.sapEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement SAPEntryLocalServiceImpl#deleteSAPEntry(SAPEntry) to avoid orphaned data");
        }
        return this.sapEntryLocalService.deleteSAPEntry((SAPEntry)persistedModel);
    }

    public BasePersistence<SAPEntry> getBasePersistence() {
        return this.sapEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.sapEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public SAPEntry getSAPEntryByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.sapEntryPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<SAPEntry> getSAPEntries(int start, int end) {
        return this.sapEntryPersistence.findAll(start, end);
    }

    public int getSAPEntriesCount() {
        return this.sapEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public SAPEntry updateSAPEntry(SAPEntry sapEntry) {
        return (SAPEntry)this.sapEntryPersistence.update((BaseModel)sapEntry);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{SAPEntryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.sapEntryLocalService = (SAPEntryLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return SAPEntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return SAPEntry.class;
    }

    protected String getModelClassName() {
        return SAPEntry.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.sapEntryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

