/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.service.access.policy.configuration.SAPConfiguration;
import com.liferay.portal.security.service.access.policy.exception.DuplicateSAPEntryNameException;
import com.liferay.portal.security.service.access.policy.exception.RequiredSAPEntryException;
import com.liferay.portal.security.service.access.policy.exception.SAPEntryNameException;
import com.liferay.portal.security.service.access.policy.exception.SAPEntryTitleException;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.base.SAPEntryLocalServiceBaseImpl;
import com.liferay.portal.util.PortalInstances;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.service.access.policy.configuration.SAPConfiguration"}, property={"model.class.name=com.liferay.portal.security.service.access.policy.model.SAPEntry"}, service={AopService.class})
public class SAPEntryLocalServiceImpl
extends SAPEntryLocalServiceBaseImpl {
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    private volatile SAPConfiguration _sapConfiguration;
    @Reference
    private UserLocalService _userLocalService;

    public SAPEntry addSAPEntry(long userId, String allowedServiceSignatures, boolean defaultSAPEntry, boolean enabled, String name, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        allowedServiceSignatures = this._normalizeServiceSignatures(allowedServiceSignatures);
        name = StringUtil.trim((String)name);
        this._validate(name, titleMap);
        if (this.sapEntryPersistence.fetchByC_N(user.getCompanyId(), name) != null) {
            throw new DuplicateSAPEntryNameException();
        }
        long sapEntryId = this.counterLocalService.increment();
        SAPEntry sapEntry = this.sapEntryPersistence.create(sapEntryId);
        sapEntry.setUuid(serviceContext.getUuid());
        sapEntry.setCompanyId(user.getCompanyId());
        sapEntry.setUserId(userId);
        sapEntry.setUserName(user.getFullName());
        sapEntry.setAllowedServiceSignatures(allowedServiceSignatures);
        sapEntry.setDefaultSAPEntry(defaultSAPEntry);
        sapEntry.setEnabled(enabled);
        sapEntry.setName(name);
        sapEntry.setTitleMap(titleMap);
        sapEntry = (SAPEntry)this.sapEntryPersistence.update((BaseModel)sapEntry, serviceContext);
        this._resourceLocalService.addResources(sapEntry.getCompanyId(), 0L, userId, SAPEntry.class.getName(), sapEntry.getSapEntryId(), false, false, false);
        return sapEntry;
    }

    public void checkSystemSAPEntries(long companyId) throws PortalException {
        HashMap titleMap;
        SAPEntry systemDefaultSAPEntry = this.sapEntryPersistence.fetchByC_N(companyId, this._sapConfiguration.systemDefaultSAPEntryName());
        SAPEntry systemRESTClientTemplateObjectSAPEntry = this.sapEntryPersistence.fetchByC_N(companyId, this._sapConfiguration.systemRESTClientTemplateObjectSAPEntryName());
        SAPEntry systemUserPasswordSAPEntry = this.sapEntryPersistence.fetchByC_N(companyId, this._sapConfiguration.systemUserPasswordSAPEntryName());
        if (systemDefaultSAPEntry != null && systemRESTClientTemplateObjectSAPEntry != null && systemUserPasswordSAPEntry != null) {
            return;
        }
        long guestUserId = this._userLocalService.getGuestUserId(companyId);
        Role guestRole = this._roleLocalService.getRole(companyId, "Guest");
        if (systemDefaultSAPEntry == null) {
            titleMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)this._sapConfiguration.systemDefaultSAPEntryDescription()).build();
            systemDefaultSAPEntry = this.addSAPEntry(guestUserId, this._sapConfiguration.systemDefaultSAPEntryServiceSignatures(), true, true, this._sapConfiguration.systemDefaultSAPEntryName(), titleMap, new ServiceContext());
            this._resourcePermissionLocalService.setResourcePermissions(systemDefaultSAPEntry.getCompanyId(), SAPEntry.class.getName(), 4, String.valueOf(systemDefaultSAPEntry.getSapEntryId()), guestRole.getRoleId(), new String[]{"VIEW"});
        }
        if (systemRESTClientTemplateObjectSAPEntry == null) {
            titleMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)this._sapConfiguration.systemRESTClientTemplateObjectSAPEntryDescription()).build();
            systemRESTClientTemplateObjectSAPEntry = this.addSAPEntry(guestUserId, this._sapConfiguration.systemRESTClientTemplateObjectSAPEntryServiceSignatures(), false, true, this._sapConfiguration.systemRESTClientTemplateObjectSAPEntryName(), titleMap, new ServiceContext());
            this._resourcePermissionLocalService.setResourcePermissions(systemRESTClientTemplateObjectSAPEntry.getCompanyId(), SAPEntry.class.getName(), 4, String.valueOf(systemRESTClientTemplateObjectSAPEntry.getSapEntryId()), guestRole.getRoleId(), new String[]{"VIEW"});
        }
        if (systemUserPasswordSAPEntry == null) {
            titleMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)this._sapConfiguration.systemUserPasswordSAPEntryDescription()).build();
            systemUserPasswordSAPEntry = this.addSAPEntry(guestUserId, this._sapConfiguration.systemUserPasswordSAPEntryServiceSignatures(), false, true, this._sapConfiguration.systemUserPasswordSAPEntryName(), titleMap, new ServiceContext());
            this._resourcePermissionLocalService.setResourcePermissions(systemUserPasswordSAPEntry.getCompanyId(), SAPEntry.class.getName(), 4, String.valueOf(systemUserPasswordSAPEntry.getSapEntryId()), guestRole.getRoleId(), new String[]{"VIEW"});
        }
    }

    @Override
    public SAPEntry deleteSAPEntry(long sapEntryId) throws PortalException {
        SAPEntry sapEntry = this.sapEntryPersistence.findByPrimaryKey(sapEntryId);
        return this.deleteSAPEntry(sapEntry);
    }

    @Override
    @SystemEvent(type=1)
    public SAPEntry deleteSAPEntry(SAPEntry sapEntry) throws PortalException {
        if (sapEntry.isSystem() && !PortalInstances.isCurrentCompanyInDeletionProcess()) {
            throw new RequiredSAPEntryException();
        }
        sapEntry = super.deleteSAPEntry(sapEntry);
        this._resourceLocalService.deleteResource(sapEntry.getCompanyId(), SAPEntry.class.getName(), 4, sapEntry.getSapEntryId());
        return sapEntry;
    }

    public SAPEntry fetchSAPEntry(long companyId, String name) {
        return this.sapEntryPersistence.fetchByC_N(companyId, name);
    }

    public List<SAPEntry> getCompanySAPEntries(long companyId, int start, int end) {
        return this.sapEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public List<SAPEntry> getCompanySAPEntries(long companyId, int start, int end, OrderByComparator<SAPEntry> orderByComparator) {
        return this.sapEntryPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getCompanySAPEntriesCount(long companyId) {
        return this.sapEntryPersistence.countByCompanyId(companyId);
    }

    public List<SAPEntry> getDefaultSAPEntries(long companyId, boolean defaultSAPEntry) {
        return this.sapEntryPersistence.findByC_D(companyId, defaultSAPEntry);
    }

    public SAPEntry getSAPEntry(long companyId, String name) throws PortalException {
        return this.sapEntryPersistence.findByC_N(companyId, name);
    }

    public SAPEntry updateSAPEntry(long sapEntryId, String allowedServiceSignatures, boolean defaultSAPEntry, boolean enabled, String name, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        SAPEntry sapEntry = this.sapEntryPersistence.findByPrimaryKey(sapEntryId);
        SAPEntry existingSAPEntry = this.sapEntryPersistence.fetchByC_N(sapEntry.getCompanyId(), name);
        if (existingSAPEntry != null && existingSAPEntry.getSapEntryId() != sapEntryId) {
            throw new DuplicateSAPEntryNameException();
        }
        allowedServiceSignatures = this._normalizeServiceSignatures(allowedServiceSignatures);
        if (sapEntry.isSystem()) {
            defaultSAPEntry = sapEntry.isDefaultSAPEntry();
            name = sapEntry.getName();
        }
        name = StringUtil.trim((String)name);
        this._validate(name, titleMap);
        sapEntry.setAllowedServiceSignatures(allowedServiceSignatures);
        sapEntry.setDefaultSAPEntry(defaultSAPEntry);
        sapEntry.setEnabled(enabled);
        sapEntry.setName(name);
        sapEntry.setTitleMap(titleMap);
        return (SAPEntry)this.sapEntryPersistence.update((BaseModel)sapEntry, serviceContext);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._sapConfiguration = (SAPConfiguration)ConfigurableUtil.createConfigurable(SAPConfiguration.class, properties);
    }

    private String _normalizeServiceSignatures(String serviceSignatures) {
        String[] serviceSignaturesArray = serviceSignatures.split("\n");
        TreeSet<String> sortedServiceSignatures = new TreeSet<String>();
        for (String serviceSignature : serviceSignaturesArray) {
            String[] serviceSignatureArray = serviceSignature.split("#");
            StringBundler sb = new StringBundler(serviceSignatureArray.length * 2);
            boolean empty = true;
            for (int i = 0; i < serviceSignatureArray.length; ++i) {
                serviceSignatureArray[i] = StringUtil.trim((String)serviceSignatureArray[i]);
                if (serviceSignatureArray[i].length() > 0) {
                    empty = false;
                }
                sb.append(serviceSignatureArray[i]);
                sb.append("#");
            }
            if (empty) continue;
            sb.setIndex(sb.index() - 1);
            sortedServiceSignatures.add(sb.toString());
        }
        StringBundler sb = new StringBundler(sortedServiceSignatures.size() * 2);
        for (String sortedServiceSignature : sortedServiceSignatures) {
            sb.append(sortedServiceSignature);
            sb.append("\n");
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private void _validate(String name, Map<Locale, String> titleMap) throws PortalException {
        Locale defaultLocale;
        String defaultTitle;
        if (Validator.isNull((String)name)) {
            throw new SAPEntryNameException();
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz#:@./_-".indexOf(c) >= 0) continue;
            throw new SAPEntryNameException("Invalid character " + c);
        }
        boolean titleExists = false;
        if (titleMap != null && Validator.isNotNull((String)(defaultTitle = titleMap.get(defaultLocale = LocaleUtil.getDefault())))) {
            titleExists = true;
        }
        if (!titleExists) {
            throw new SAPEntryTitleException();
        }
    }
}

