/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.facebook.connect.internal.auto.login;

import com.liferay.portal.kernel.facebook.FacebookConnect;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AutoLogin.class})
public class FacebookConnectAutoLogin
extends BaseAutoLogin {
    @Reference
    private FacebookConnect _facebookConnect;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long companyId = this._portal.getCompanyId(httpServletRequest);
        if (!this._facebookConnect.isEnabled(companyId)) {
            return null;
        }
        User user = this._getUser(httpServletRequest, companyId);
        if (user == null) {
            return null;
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.FALSE.toString()};
        return credentials;
    }

    private User _getUser(HttpServletRequest httpServletRequest, long companyId) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession();
        String emailAddress = (String)httpSession.getAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
        if (Validator.isNotNull((String)emailAddress)) {
            httpSession.removeAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
            return this._userLocalService.getUserByEmailAddress(companyId, emailAddress);
        }
        long facebookId = GetterUtil.getLong((String)((String)httpSession.getAttribute("FACEBOOK_USER_ID")));
        if (facebookId > 0L) {
            return this._userLocalService.getUserByFacebookId(companyId, facebookId);
        }
        return null;
    }
}

