/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.facebook.connect.internal.verify;

import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.facebook.connect.constants.LegacyFacebookConnectPropsKeys;
import com.liferay.portal.verify.BaseCompanySettingsVerifyProcess;
import com.liferay.portal.verify.VerifyProcess;
import java.util.Dictionary;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={VerifyProcess.class})
public class FacebookConnectCompanySettingsVerifyProcess
extends BaseCompanySettingsVerifyProcess {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private PrefsProps _prefsProps;
    @Reference
    private SettingsLocatorHelper _settingsLocatorHelper;

    protected CompanyLocalService getCompanyLocalService() {
        return this._companyLocalService;
    }

    protected Set<String> getLegacyPropertyKeys() {
        return SetUtil.fromArray((Object[])LegacyFacebookConnectPropsKeys.FACEBOOK_CONNECT_KEYS);
    }

    protected Dictionary<String, String> getPropertyValues(long companyId) {
        Dictionary dictionary = super.getPropertyValues(companyId);
        String oauthRedirectURL = this._prefsProps.getString(companyId, "facebook.connect.oauth.redirect.url");
        if (oauthRedirectURL != null) {
            dictionary.put("oauthRedirectURL", this._upgradeLegacyRedirectURI(oauthRedirectURL));
        }
        return dictionary;
    }

    protected String[][] getRenamePropertyKeysArray() {
        return new String[][]{{"facebook.auth.enabled", "enabled"}, {"facebook.connect.app.id", "appId"}, {"facebook.connect.app.secret", "appSecret"}, {"facebook.connect.graph.url", "graphURL"}, {"facebook.connect.oauth.auth.url", "oauthAuthURL"}, {"facebook.connect.oauth.token.url", "oauthTokenURL"}, {"facebook.connect.verified.account.required", "verifiedAccountRequired"}};
    }

    protected String getSettingsId() {
        return "com.liferay.portal.security.sso.facebook.connect";
    }

    protected SettingsLocatorHelper getSettingsLocatorHelper() {
        return this._settingsLocatorHelper;
    }

    private String _upgradeLegacyRedirectURI(String legacyRedirectURI) {
        if (Validator.isNull((String)legacyRedirectURI)) {
            return legacyRedirectURI;
        }
        return legacyRedirectURI.replaceFirst("/c/login/facebook_connect_oauth", "/c/portal/facebook_connect_oauth");
    }
}

