/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.facebook.connect.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.facebook.FacebookConnect;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.facebook.connect.configuration.FacebookConnectConfiguration;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.facebook.connect.configuration.FacebookConnectConfiguration"}, immediate=true, service={FacebookConnect.class})
public class FacebookConnectImpl
implements FacebookConnect {
    private static final Log _log = LogFactoryUtil.getLog(FacebookConnectImpl.class);
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;

    public String getAccessToken(long companyId, String redirect, String code) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        String url = facebookConnectConfiguration.oauthTokenURL();
        url = this._http.addParameter(url, "client_id", facebookConnectConfiguration.appId());
        url = this._http.addParameter(url, "client_secret", facebookConnectConfiguration.appSecret());
        url = this._http.addParameter(url, "code", code);
        url = this._http.addParameter(url, "redirect_uri", facebookConnectConfiguration.oauthRedirectURL());
        Http.Options options = new Http.Options();
        options.setLocation(url);
        try {
            String content = this._http.URLtoString(options);
            JSONObject contentJSONObject = JSONFactoryUtil.createJSONObject((String)content);
            String accessToken = contentJSONObject.getString("access_token");
            if (Validator.isNotNull((String)accessToken)) {
                return accessToken;
            }
            if (_log.isDebugEnabled()) {
                String appSecret = facebookConnectConfiguration.appSecret();
                if (!appSecret.isEmpty()) {
                    url = this._http.setParameter(url, "client_secret", StringBundler.concat((Object[])new Object[]{Character.valueOf(appSecret.charAt(0)), "...redacted...", Character.valueOf(appSecret.charAt(appSecret.length() - 1))}));
                }
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to get access token for URL ", url, " because of response:", content}));
            }
        }
        catch (Exception exception) {
            throw new SystemException("Unable to retrieve Facebook access token", (Throwable)exception);
        }
        return null;
    }

    public String getAccessTokenURL(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.oauthTokenURL();
    }

    public String getAppId(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.appId();
    }

    public String getAppSecret(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.appSecret();
    }

    public String getAuthURL(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.oauthAuthURL();
    }

    public JSONObject getGraphResources(long companyId, String path, String accessToken, String fields) {
        try {
            String graphURL = this.getGraphURL(companyId);
            String url = this._http.addParameter(graphURL.concat(path), "access_token", accessToken);
            if (Validator.isNotNull((String)fields)) {
                url = this._http.addParameter(url, "fields", fields);
            }
            Http.Options options = new Http.Options();
            options.setLocation(url);
            String json = this._http.URLtoString(options);
            return JSONFactoryUtil.createJSONObject((String)json);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            return null;
        }
    }

    public String getGraphURL(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.graphURL();
    }

    public String getProfileImageURL(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest(portletRequest);
        HttpSession session = (httpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest)).getSession();
        String facebookId = (String)session.getAttribute("FACEBOOK_USER_ID");
        if (Validator.isNull((String)facebookId)) {
            return null;
        }
        long companyId = this._portal.getCompanyId(httpServletRequest);
        String token = (String)session.getAttribute("FACEBOOK_ACCESS_TOKEN");
        JSONObject jsonObject = this.getGraphResources(companyId, "/me", token, "id,picture");
        return jsonObject.getString("picture");
    }

    public String getRedirectURL(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.oauthRedirectURL();
    }

    public boolean isEnabled(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.enabled();
    }

    public boolean isVerifiedAccountRequired(long companyId) {
        FacebookConnectConfiguration facebookConnectConfiguration = this.getFacebookConnectConfiguration(companyId);
        return facebookConnectConfiguration.verifiedAccountRequired();
    }

    protected FacebookConnectConfiguration getFacebookConnectConfiguration(long companyId) {
        try {
            return (FacebookConnectConfiguration)this._configurationProvider.getConfiguration(FacebookConnectConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.facebook.connect"));
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to get Facebook Connect configuration", (Throwable)configurationException);
            return null;
        }
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }
}

