/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProvider;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProviderRegistry;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectMetadataFactory;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectMetadataFactoryImpl;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectProviderImpl;
import com.liferay.portal.security.sso.openid.connect.internal.configuration.OpenIdConnectProviderConfiguration;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.pid=com.liferay.portal.security.sso.openid.connect.internal.configuration.OpenIdConnectProviderConfiguration"}, service={ManagedServiceFactory.class, OpenIdConnectProviderRegistry.class})
public class OpenIdConnectProviderRegistryImpl
implements ManagedServiceFactory,
OpenIdConnectProviderRegistry<OIDCClientMetadata, OIDCProviderMetadata> {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectProviderRegistryImpl.class);
    private final Map<Long, Map<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>>> _companyIdProviderNameOpenIdConnectProviders = new ConcurrentHashMap<Long, Map<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>>>();
    @Reference
    private CompanyLocalService _companyLocalService;
    private final Map<String, Dictionary<String, ?>> _configurationPidsProperties = new ConcurrentHashMap();

    public void deleted(String pid) {
        Dictionary<String, ?> properties = this._configurationPidsProperties.remove(pid);
        long companyId = GetterUtil.getLong(properties.get("companyId"));
        if (companyId == 0L) {
            this._rebuild();
        } else {
            this._rebuild(companyId);
        }
    }

    public OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> findOpenIdConnectProvider(long companyId, String name) throws OpenIdConnectServiceException.ProviderException {
        OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> openIdConnectProvider = this.getOpenIdConnectProvider(companyId, name);
        if (openIdConnectProvider == null) {
            throw new OpenIdConnectServiceException.ProviderException("Unable to find an OpenId Connect provider with name \"" + name + "\"");
        }
        return openIdConnectProvider;
    }

    public String getName() {
        return "OpenId Connect Provider Factory";
    }

    public OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> getOpenIdConnectProvider(long companyId, String name) {
        Map<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>> openIdConnectProviderMap = this._companyIdProviderNameOpenIdConnectProviders.get(companyId);
        if (openIdConnectProviderMap == null) {
            openIdConnectProviderMap = this._companyIdProviderNameOpenIdConnectProviders.get(0L);
        }
        return openIdConnectProviderMap.get(name);
    }

    public Collection<String> getOpenIdConnectProviderNames(long companyId) {
        Map<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>> openIdConnectProviderMap = this._companyIdProviderNameOpenIdConnectProviders.get(companyId);
        if (openIdConnectProviderMap == null) {
            openIdConnectProviderMap = this._companyIdProviderNameOpenIdConnectProviders.get(0L);
        }
        return Collections.unmodifiableSet(openIdConnectProviderMap.keySet());
    }

    public void updated(String pid, Dictionary<String, ?> properties) {
        Dictionary<String, ?> oldProperties = this._configurationPidsProperties.put(pid, properties);
        long companyId = GetterUtil.getLong(properties.get("companyId"));
        if (companyId == 0L) {
            this._rebuild();
            return;
        }
        if (oldProperties != null) {
            long oldCompanyId = GetterUtil.getLong(oldProperties.get("companyId"));
            if (oldCompanyId == 0L) {
                this._rebuild();
                return;
            }
            if (oldCompanyId != companyId) {
                this._rebuild(oldCompanyId);
            }
        }
        this._rebuild(companyId);
    }

    @Activate
    protected void activate() {
        this._companyIdProviderNameOpenIdConnectProviders.putIfAbsent(0L, Collections.emptyMap());
    }

    protected OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> createOpenIdConnectProvider(OpenIdConnectProviderConfiguration openIdConnectProviderConfiguration) throws ConfigurationException {
        try {
            return new OpenIdConnectProviderImpl(openIdConnectProviderConfiguration.providerName(), openIdConnectProviderConfiguration.openIdConnectClientId(), openIdConnectProviderConfiguration.openIdConnectClientSecret(), openIdConnectProviderConfiguration.scopes(), this.getOpenIdConnectMetadataFactory(openIdConnectProviderConfiguration), openIdConnectProviderConfiguration.tokenConnectionTimeout());
        }
        catch (Exception exception) {
            throw new ConfigurationException(null, StringBundler.concat((String[])new String[]{"Unable to instantiate provider metadata factory for \"", openIdConnectProviderConfiguration.providerName(), "\": ", exception.getMessage()}), (Throwable)exception);
        }
    }

    protected OpenIdConnectMetadataFactory getOpenIdConnectMetadataFactory(OpenIdConnectProviderConfiguration openIdConnectProviderConfiguration) throws MalformedURLException, OpenIdConnectServiceException.ProviderException {
        if (Validator.isNotNull((String)openIdConnectProviderConfiguration.discoveryEndPoint())) {
            return new OpenIdConnectMetadataFactoryImpl(openIdConnectProviderConfiguration.providerName(), new URL(openIdConnectProviderConfiguration.discoveryEndPoint()), openIdConnectProviderConfiguration.discoveryEndPointCacheInMillis());
        }
        return new OpenIdConnectMetadataFactoryImpl(openIdConnectProviderConfiguration.providerName(), openIdConnectProviderConfiguration.idTokenSigningAlgValues(), openIdConnectProviderConfiguration.issuerURL(), openIdConnectProviderConfiguration.subjectTypes(), openIdConnectProviderConfiguration.jwksURI(), openIdConnectProviderConfiguration.authorizationEndPoint(), openIdConnectProviderConfiguration.tokenEndPoint(), openIdConnectProviderConfiguration.userInfoEndPoint());
    }

    private <U, V> void _addDefaults(Map<U, V> map, Map<U, V> defaultsMap) {
        if (defaultsMap != null) {
            defaultsMap.forEach(map::putIfAbsent);
        }
    }

    private void _rebuild() {
        this._rebuild(0L);
        this._companyLocalService.forEachCompanyId(companyId -> {
            if (companyId != 0L) {
                this._rebuild((long)companyId);
            }
        }, ArrayUtil.toLongArray(this._companyIdProviderNameOpenIdConnectProviders.keySet()));
    }

    private void _rebuild(long companyId) {
        TreeMap<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>> openIdConnectProviderMap = new TreeMap<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>>();
        for (Dictionary<String, ?> properties : this._configurationPidsProperties.values()) {
            if (companyId != GetterUtil.getLong(properties.get("companyId"))) continue;
            try {
                OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> openIdConnectProvider = this.createOpenIdConnectProvider((OpenIdConnectProviderConfiguration)ConfigurableUtil.createConfigurable(OpenIdConnectProviderConfiguration.class, properties));
                if (openIdConnectProviderMap.containsKey(openIdConnectProvider.getName())) {
                    _log.error((Object)("Duplicate OpenId Connect provider name \"" + openIdConnectProvider.getName() + "\""));
                    continue;
                }
                openIdConnectProviderMap.put(openIdConnectProvider.getName(), openIdConnectProvider);
            }
            catch (ConfigurationException configurationException) {
                _log.error((Object)configurationException, (Throwable)configurationException);
            }
        }
        if (companyId != 0L) {
            this._addDefaults(openIdConnectProviderMap, this._companyIdProviderNameOpenIdConnectProviders.get(0L));
        }
        this._companyIdProviderNameOpenIdConnectProviders.put(companyId, openIdConnectProviderMap);
    }
}

