/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata;
import com.liferay.oauth.client.persistence.service.OAuthClientASLocalMetadataLocalService;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AuthorizationServerMetadataResolver.class})
public class AuthorizationServerMetadataResolver {
    @Reference
    private OAuthClientASLocalMetadataLocalService _oAuthClientASLocalMetadataLocalService;

    public OIDCProviderMetadata resolveOIDCProviderMetadata(String authServerWellKnownURI) throws Exception {
        if (authServerWellKnownURI.endsWith("local")) {
            OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this._oAuthClientASLocalMetadataLocalService.getOAuthClientASLocalMetadata(authServerWellKnownURI);
            return OIDCProviderMetadata.parse((String)oAuthClientASLocalMetadata.getMetadataJSON());
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, new URL(authServerWellKnownURI));
        HTTPResponse httpResponse = httpRequest.send();
        if (httpResponse.getStatusCode() != 200) {
            throw new OpenIdConnectServiceException.ProviderException(httpResponse.getStatusMessage());
        }
        return OIDCProviderMetadata.parse((String)httpResponse.getContent());
    }
}

