/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.internal.exception.StrangersNotAllowedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OIDCUserInfoProcessor.class})
public class OIDCUserInfoProcessor {
    private static final Log _log = LogFactoryUtil.getLog(OIDCUserInfoProcessor.class);
    @Reference
    private AddressLocalService _addressLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CountryLocalService _countryLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ListTypeLocalService _listTypeLocalService;
    @Reference
    private PhoneLocalService _phoneLocalService;
    @Reference
    private Props _props;
    @Reference
    private RegionLocalService _regionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public long processUserInfo(long companyId, String issuer, ServiceContext serviceContext, String userInfoJSON, String userInfoMapperJSON) throws Exception {
        User user;
        block6: {
            block5: {
                long userId = this._getUserId(companyId, userInfoJSON, userInfoMapperJSON);
                if (userId > 0L) {
                    return userId;
                }
                user = this._addUser(companyId, issuer, serviceContext, userInfoJSON, userInfoMapperJSON);
                try {
                    this._addAddress(serviceContext, user, userInfoJSON, userInfoMapperJSON);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Throwable)exception);
                }
            }
            try {
                this._addPhone(serviceContext, user, userInfoJSON, userInfoMapperJSON);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Throwable)exception);
            }
        }
        return user.getUserId();
    }

    private void _addAddress(ServiceContext serviceContext, User user, String userInfoJSON, String userInfoMapperJSON) throws Exception {
        ListType listType;
        JSONObject userInfoMapperJSONObject = this._jsonFactory.createJSONObject(userInfoMapperJSON);
        JSONObject addressMapperJSONObject = userInfoMapperJSONObject.getJSONObject("address");
        if (addressMapperJSONObject == null) {
            return;
        }
        JSONObject userInfoJSONObject = this._jsonFactory.createJSONObject(userInfoJSON);
        String streetClaimString = this._getClaimString("street", addressMapperJSONObject, userInfoJSONObject);
        if (Validator.isNull((String)streetClaimString)) {
            return;
        }
        String[] streetClaimStringParts = streetClaimString.split("\n");
        Region region = null;
        Country country = null;
        String countryClaimString = this._getClaimString("country", addressMapperJSONObject, userInfoJSONObject);
        if (Validator.isNotNull((String)countryClaimString)) {
            country = countryClaimString.charAt(0) >= '0' && countryClaimString.charAt(0) <= '9' ? this._countryLocalService.getCountryByNumber(user.getCompanyId(), countryClaimString) : (countryClaimString.length() == 2 ? this._countryLocalService.fetchCountryByA2(user.getCompanyId(), StringUtil.toUpperCase((String)countryClaimString)) : (countryClaimString.length() == 3 ? this._countryLocalService.fetchCountryByA3(user.getCompanyId(), StringUtil.toUpperCase((String)countryClaimString)) : this._countryLocalService.fetchCountryByName(user.getCompanyId(), StringUtil.toLowerCase((String)countryClaimString))));
            String regionCode = this._getClaimString("region", addressMapperJSONObject, userInfoJSONObject);
            if (country != null && Validator.isNotNull((String)regionCode)) {
                region = this._regionLocalService.fetchRegion(country.getCountryId(), StringUtil.toUpperCase((String)regionCode));
            }
        }
        if ((listType = this._listTypeLocalService.getListType(user.getCompanyId(), this._getClaimString("addressType", addressMapperJSONObject, userInfoJSONObject), Contact.class.getName() + ".address")) == null) {
            List listTypes = this._listTypeLocalService.getListTypes(user.getCompanyId(), Contact.class.getName() + ".address");
            listType = (ListType)listTypes.get(0);
        }
        this._addressLocalService.addAddress(null, user.getUserId(), Contact.class.getName(), user.getContactId(), null, null, streetClaimStringParts.length > 0 ? streetClaimStringParts[0] : null, streetClaimStringParts.length > 1 ? streetClaimStringParts[1] : null, streetClaimStringParts.length > 2 ? streetClaimStringParts[2] : null, this._getClaimString("city", addressMapperJSONObject, userInfoJSONObject), this._getClaimString("zip", addressMapperJSONObject, userInfoJSONObject), region == null ? 0L : region.getRegionId(), country == null ? 0L : country.getCountryId(), listType.getListTypeId(), false, false, null, serviceContext);
    }

    private void _addPhone(ServiceContext serviceContext, User user, String userInfoJSON, String userInfoMapperJSON) throws Exception {
        JSONObject userInfoMapperJSONObject = this._jsonFactory.createJSONObject(userInfoMapperJSON);
        JSONObject phoneMapperJSONObject = userInfoMapperJSONObject.getJSONObject("phone");
        if (phoneMapperJSONObject == null) {
            return;
        }
        JSONObject userInfoJSONObject = this._jsonFactory.createJSONObject(userInfoJSON);
        String phoneClaimString = this._getClaimString("phone", phoneMapperJSONObject, userInfoJSONObject);
        if (Validator.isNull((String)phoneClaimString)) {
            return;
        }
        ListType listType = this._listTypeLocalService.getListType(user.getCompanyId(), this._getClaimString("phoneType", phoneMapperJSONObject, userInfoJSONObject), Contact.class.getName() + ".phone");
        if (listType == null) {
            List listTypes = this._listTypeLocalService.getListTypes(user.getCompanyId(), Contact.class.getName() + ".phone");
            listType = (ListType)listTypes.get(0);
        }
        this._phoneLocalService.addPhone(null, user.getUserId(), Contact.class.getName(), user.getContactId(), phoneClaimString, null, listType.getListTypeId(), false, serviceContext);
    }

    private User _addUser(long companyId, String issuer, ServiceContext serviceContext, String userInfoJSON, String userInfoMapperJSON) throws Exception {
        JSONObject userInfoJSONObject;
        JSONObject userInfoMapperJSONObject = this._jsonFactory.createJSONObject(userInfoMapperJSON);
        JSONObject userMapperJSONObject = userInfoMapperJSONObject.getJSONObject("user");
        String emailAddress = this._getClaimString("emailAddress", userMapperJSONObject, userInfoJSONObject = this._jsonFactory.createJSONObject(userInfoJSON));
        if (Validator.isNull((String)emailAddress)) {
            throw new OpenIdConnectServiceException.UserMappingException("Email address is null");
        }
        String firstName = this._getClaimString("firstName", userMapperJSONObject, userInfoJSONObject);
        if (Validator.isNull((String)firstName)) {
            throw new OpenIdConnectServiceException.UserMappingException("First name is null");
        }
        String lastName = this._getClaimString("lastName", userMapperJSONObject, userInfoJSONObject);
        if (Validator.isNull((String)lastName)) {
            throw new OpenIdConnectServiceException.UserMappingException("Last name is null");
        }
        this._checkAddUser(companyId, emailAddress);
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        String screenName = this._getClaimString("screenName", userMapperJSONObject, userInfoJSONObject);
        long prefixListTypeId = 0L;
        long suffixListTypeId = 0L;
        JSONObject contactMapperJSONObject = userInfoMapperJSONObject.getJSONObject("contact");
        int[] birthday = this._getBirthday(contactMapperJSONObject, userInfoJSONObject);
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = this._getRoleIds(companyId, userInfoJSONObject, userInfoMapperJSONObject.getJSONObject("users_roles"));
        if (ArrayUtil.isEmpty((long[])roleIds)) {
            roleIds = this._getRoleIds(companyId, issuer);
        }
        long[] userGroupIds = null;
        boolean sendEmail = false;
        User user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, Validator.isNull((String)screenName), screenName, emailAddress, this._getLocale(companyId, userInfoJSONObject, userMapperJSONObject), firstName, this._getClaimString("middleName", userMapperJSONObject, userInfoJSONObject), lastName, prefixListTypeId, suffixListTypeId, this._isMale(contactMapperJSONObject, userInfoJSONObject), birthday[1], birthday[2], birthday[0], this._getClaimString("jobTitle", userMapperJSONObject, userInfoJSONObject), 1, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        return this._userLocalService.updatePasswordReset(user.getUserId(), false);
    }

    private void _checkAddUser(long companyId, String emailAddress) throws Exception {
        Company company = this._companyLocalService.getCompany(companyId);
        if (!company.isStrangers()) {
            throw new StrangersNotAllowedException(companyId);
        }
        if (!company.isStrangersWithMx() && company.hasCompanyMx(emailAddress)) {
            throw new UserEmailAddressException.MustNotUseCompanyMx(emailAddress);
        }
    }

    private int[] _getBirthday(JSONObject contactMapperJSONObject, JSONObject userInfoJSONObject) {
        int[] birthday = new int[]{1970, 0, 1};
        String birthdateClaimString = this._getClaimString("birthdate", contactMapperJSONObject, userInfoJSONObject);
        if (Validator.isNull((String)birthdateClaimString)) {
            return birthday;
        }
        String[] birthdateClaimStringParts = birthdateClaimString.split("-");
        if (!birthdateClaimStringParts[0].equals("0000")) {
            birthday[0] = GetterUtil.getInteger((String)birthdateClaimStringParts[0]);
        }
        if (birthdateClaimStringParts.length == 3) {
            birthday[1] = GetterUtil.getInteger((String)birthdateClaimStringParts[1]) - 1;
            birthday[2] = GetterUtil.getInteger((String)birthdateClaimStringParts[2]);
        }
        return birthday;
    }

    private JSONArray _getClaimJSONArray(String key, JSONObject mapperJSONObject, JSONObject userInfoJSONObject) {
        Object claimObject = this._getClaimObject(key, mapperJSONObject, userInfoJSONObject);
        if (claimObject == null || claimObject instanceof JSONArray) {
            return (JSONArray)claimObject;
        }
        return null;
    }

    private Object _getClaimObject(String key, JSONObject mapperJSONObject, JSONObject userInfoJSONObject) {
        String value = mapperJSONObject.getString(key);
        if (Validator.isNull((String)value)) {
            return null;
        }
        String[] valueParts = value.split("->");
        Object claimObject = userInfoJSONObject.get(valueParts[0]);
        for (int i = 1; i < valueParts.length; ++i) {
            JSONObject claimJSONObject = (JSONObject)claimObject;
            if (claimJSONObject == null) continue;
            claimObject = claimJSONObject.get(valueParts[i]);
        }
        return claimObject;
    }

    private String _getClaimString(String key, JSONObject mapperJSONObject, JSONObject userInfoJSONObject) {
        Object claimObject = this._getClaimObject(key, mapperJSONObject, userInfoJSONObject);
        if (claimObject != null && !(claimObject instanceof String)) {
            throw new IllegalArgumentException("Claim is not a string");
        }
        return (String)claimObject;
    }

    private Locale _getLocale(long companyId, JSONObject userInfoJSONObject, JSONObject userMapperJSONObject) throws Exception {
        String languageId = this._getClaimString("languageId", userMapperJSONObject, userInfoJSONObject);
        if (Validator.isNotNull((String)languageId)) {
            return new Locale(languageId);
        }
        Company company = this._companyLocalService.getCompany(companyId);
        return company.getLocale();
    }

    private long[] _getRoleIds(long companyId, JSONObject userInfoJSONObject, JSONObject usersRolesMapperJSONObject) {
        if (usersRolesMapperJSONObject == null || usersRolesMapperJSONObject.length() < 1) {
            return null;
        }
        JSONArray rolesJSONArray = this._getClaimJSONArray("roles", usersRolesMapperJSONObject, userInfoJSONObject);
        if (rolesJSONArray == null) {
            return null;
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        for (int i = 0; i < rolesJSONArray.length(); ++i) {
            Role role = this._roleLocalService.fetchRole(companyId, rolesJSONArray.getString(i));
            if (role == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No role name " + rolesJSONArray.getString(i)));
                continue;
            }
            roleIds.add(role.getRoleId());
        }
        if (roleIds.isEmpty()) {
            return null;
        }
        return ArrayUtil.toLongArray(roleIds);
    }

    private long[] _getRoleIds(long companyId, String issuer) {
        if (Validator.isNull((String)issuer) || !Objects.equals(issuer, this._props.get("open.id.connect.user.info.processor.impl.issuer"))) {
            return null;
        }
        String roleName = this._props.get("open.id.connect.user.info.processor.impl.regular.role");
        if (Validator.isNull((String)roleName)) {
            return null;
        }
        Role role = this._roleLocalService.fetchRole(companyId, roleName);
        if (role == null) {
            return null;
        }
        if (role.getType() == 1) {
            return new long[]{role.getRoleId()};
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Role " + roleName + " is not a regular role"));
        }
        return null;
    }

    private long _getUserId(long companyId, String userInfoJSON, String userInfoMapperJSON) throws Exception {
        JSONObject userInfoJSONObject;
        JSONObject userInfoMapperJSONObject = this._jsonFactory.createJSONObject(userInfoMapperJSON);
        JSONObject userMapperJSONObject = userInfoMapperJSONObject.getJSONObject("user");
        User user = this._userLocalService.fetchUserByEmailAddress(companyId, this._getClaimString("emailAddress", userMapperJSONObject, userInfoJSONObject = this._jsonFactory.createJSONObject(userInfoJSON)));
        if (user != null) {
            return user.getUserId();
        }
        return 0L;
    }

    private boolean _isMale(JSONObject contactMapperJSONObject, JSONObject userInfoJSONObject) {
        String gender = this._getClaimString("gender", contactMapperJSONObject, userInfoJSONObject);
        return Validator.isNull((String)gender) || gender.equals("male");
    }
}

