/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.service.OAuthClientEntryLocalService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectAuthenticationHandler;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.internal.AuthorizationServerMetadataResolver;
import com.liferay.portal.security.sso.openid.connect.internal.OIDCUserInfoProcessor;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectAuthenticationSession;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectSessionImpl;
import com.liferay.portal.security.sso.openid.connect.internal.session.manager.OfflineOpenIdConnectSessionManager;
import com.liferay.portal.security.sso.openid.connect.internal.util.OpenIdConnectProviderUtil;
import com.liferay.portal.security.sso.openid.connect.internal.util.OpenIdConnectRequestParametersUtil;
import com.liferay.portal.security.sso.openid.connect.internal.util.OpenIdConnectTokenRequestUtil;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.minidev.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenIdConnectAuthenticationHandler.class})
public class OpenIdConnectAuthenticationHandlerImpl
implements OpenIdConnectAuthenticationHandler {
    private static final String _OPEN_ID_CONNECT_AUTHENTICATION_SESSION = OpenIdConnectAuthenticationHandlerImpl.class.getName() + "#OPEN_ID_CONNECT_AUTHENTICATION_SESSION";
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectAuthenticationHandlerImpl.class);
    @Reference
    private AuthorizationServerMetadataResolver _authorizationServerMetadataResolver;
    @Reference
    private Language _language;
    @Reference
    private OAuthClientEntryLocalService _oAuthClientEntryLocalService;
    @Reference
    private OfflineOpenIdConnectSessionManager _offlineOpenIdConnectSessionManager;
    @Reference
    private OIDCUserInfoProcessor _oidcUserInfoProcessor;
    @Reference
    private Portal _portal;

    public void processAuthenticationResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, UnsafeConsumer<Long, Exception> userIdUnsafeConsumer) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession();
        OpenIdConnectAuthenticationSession openIdConnectAuthenticationSession = (OpenIdConnectAuthenticationSession)httpSession.getAttribute(_OPEN_ID_CONNECT_AUTHENTICATION_SESSION);
        httpSession.removeAttribute(_OPEN_ID_CONNECT_AUTHENTICATION_SESSION);
        if (openIdConnectAuthenticationSession == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"OpenId Connect authentication was not requested or removed");
            }
            return;
        }
        AuthenticationSuccessResponse authenticationSuccessResponse = this._getAuthenticationSuccessResponse(httpServletRequest);
        this._validateState(openIdConnectAuthenticationSession.getState(), authenticationSuccessResponse.getState());
        OAuthClientEntry oAuthClientEntry = this._oAuthClientEntryLocalService.getOAuthClientEntry(openIdConnectAuthenticationSession.getOAuthClientEntryId());
        OIDCClientInformation oidcClientInformation = OIDCClientInformation.parse((JSONObject)JSONObjectUtils.parse((String)oAuthClientEntry.getInfoJSON()));
        OIDCProviderMetadata oidcProviderMetadata = this._authorizationServerMetadataResolver.resolveOIDCProviderMetadata(oAuthClientEntry.getAuthServerWellKnownURI());
        OIDCTokens oidcTokens = OpenIdConnectTokenRequestUtil.request(authenticationSuccessResponse, openIdConnectAuthenticationSession.getCodeVerifier(), openIdConnectAuthenticationSession.getNonce(), oidcClientInformation, oidcProviderMetadata, this._getLoginRedirectURI(httpServletRequest), oAuthClientEntry.getTokenRequestParametersJSON());
        String userInfoJSON = null;
        if (oidcProviderMetadata.getUserInfoEndpointURI() == null) {
            UserInfo userInfo = new UserInfo(JWTClaimsSet.parse(this.getUserInfoClaims(oidcTokens.getIDToken())));
            userInfoJSON = userInfo.toJSONString();
        } else {
            userInfoJSON = this._requestUserInfoJSON(oidcTokens.getAccessToken(), oidcProviderMetadata);
        }
        long userId = this._oidcUserInfoProcessor.processUserInfo(this._portal.getCompanyId(httpServletRequest), String.valueOf(oidcProviderMetadata.getIssuer()), ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest), userInfoJSON, oAuthClientEntry.getOIDCUserInfoMapperJSON());
        userIdUnsafeConsumer.accept((Object)userId);
        httpSession = httpServletRequest.getSession();
        long openIdConnectSessionId = this._offlineOpenIdConnectSessionManager.startOpenIdConnectSession(oAuthClientEntry.getAuthServerWellKnownURI(), String.valueOf(oidcClientInformation.getID()), oidcTokens, userId);
        httpSession.setAttribute("OPEN_ID_CONNECT_SESSION", (Object)new OpenIdConnectSessionImpl(openIdConnectSessionId, oAuthClientEntry.getAuthServerWellKnownURI(), openIdConnectAuthenticationSession.getNonce(), openIdConnectAuthenticationSession.getState(), userId));
        httpSession.setAttribute("OPEN_ID_CONNECT_SESSION_ID", (Object)openIdConnectSessionId);
    }

    public void requestAuthentication(long oAuthClientEntryId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        HttpSession httpSession = httpServletRequest.getSession();
        Long openIdConnectSessionId = (Long)httpSession.getAttribute("OPEN_ID_CONNECT_SESSION_ID");
        if (openIdConnectSessionId != null) {
            httpSession.removeAttribute("OPEN_ID_CONNECT_SESSION_ID");
        }
        CodeVerifier codeVerifier = new CodeVerifier();
        OAuthClientEntry oAuthClientEntry = this._oAuthClientEntryLocalService.getOAuthClientEntry(oAuthClientEntryId);
        HashMap runtimeRequestParameters = HashMapBuilder.put((Object)"code_challenge", (Object)CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.S256, (CodeVerifier)codeVerifier)).put((Object)"nonce", (Object)new Nonce()).put((Object)"redirect_uri", (Object)this._getLoginRedirectURI(httpServletRequest)).put((Object)"state", (Object)new State()).put((Object)"ui_locales", this._getLangTags(httpServletRequest)).build();
        try {
            OIDCProviderMetadata oidcProviderMetadata = this._authorizationServerMetadataResolver.resolveOIDCProviderMetadata(oAuthClientEntry.getAuthServerWellKnownURI());
            URI authenticationRequestURI = this._getAuthenticationRequestURI(oidcProviderMetadata.getAuthorizationEndpointURI(), oAuthClientEntry.getAuthRequestParametersJSON(), oAuthClientEntry.getClientId(), runtimeRequestParameters);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Authentication request query: " + authenticationRequestURI.getQuery()));
            }
            httpServletResponse.sendRedirect(authenticationRequestURI.toString());
            httpSession.setAttribute(_OPEN_ID_CONNECT_AUTHENTICATION_SESSION, (Object)new OpenIdConnectAuthenticationSession(codeVerifier, (Nonce)runtimeRequestParameters.get("nonce"), oAuthClientEntryId, (State)runtimeRequestParameters.get("state")));
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    public void requestAuthentication(String openIdConnectProviderName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        this.requestAuthentication(OpenIdConnectProviderUtil.getOAuthClientEntryId(this._portal.getCompanyId(httpServletRequest), openIdConnectProviderName, this._oAuthClientEntryLocalService), httpServletRequest, httpServletResponse);
    }

    protected Map<String, Object> getUserInfoClaims(JWT jwt) throws ParseException {
        JWTClaimsSet jwtClaimsSet = jwt.getJWTClaimsSet();
        Map claims = jwtClaimsSet.toJSONObject();
        claims.put("email", jwtClaimsSet.getStringClaim("email"));
        claims.put("family_name", jwtClaimsSet.getStringClaim("family_name"));
        claims.put("given_name", jwtClaimsSet.getStringClaim("given_name"));
        return claims;
    }

    private URI _getAuthenticationRequestURI(URI authenticationEndpointURI, String authenticationRequestParametersJSON, String clientId, Map<String, Object> runtimeRequestParameters) throws Exception {
        JSONObject authenticationRequestParametersJSONObject = JSONObjectUtils.parse((String)authenticationRequestParametersJSON);
        AuthenticationRequest.Builder builder = new AuthenticationRequest.Builder(OpenIdConnectRequestParametersUtil.getResponseType(authenticationRequestParametersJSONObject), OpenIdConnectRequestParametersUtil.getScope(authenticationRequestParametersJSONObject), new ClientID(clientId), (URI)runtimeRequestParameters.get("redirect_uri"));
        builder = builder.endpointURI(authenticationEndpointURI).codeChallenge((CodeChallenge)runtimeRequestParameters.get("code_challenge"), CodeChallengeMethod.S256).nonce((Nonce)runtimeRequestParameters.get("nonce")).resources(OpenIdConnectRequestParametersUtil.getResourceURIs(authenticationRequestParametersJSONObject)).state((State)runtimeRequestParameters.get("state")).uiLocales((List)runtimeRequestParameters.get("ui_locales"));
        OpenIdConnectRequestParametersUtil.consumeCustomRequestParameters((arg_0, arg_1) -> ((AuthenticationRequest.Builder)builder).customParameter(arg_0, arg_1), authenticationRequestParametersJSONObject);
        return builder.build().toURI();
    }

    private AuthenticationSuccessResponse _getAuthenticationSuccessResponse(HttpServletRequest httpServletRequest) throws OpenIdConnectServiceException.AuthenticationException {
        StringBuffer requestURL = httpServletRequest.getRequestURL();
        if (Validator.isNotNull((String)httpServletRequest.getQueryString())) {
            requestURL.append("?");
            requestURL.append(httpServletRequest.getQueryString());
        }
        try {
            URI requestURI = new URI(requestURL.toString());
            AuthenticationResponse authenticationResponse = AuthenticationResponseParser.parse((URI)requestURI);
            if (authenticationResponse instanceof AuthenticationErrorResponse) {
                AuthenticationErrorResponse authenticationErrorResponse = (AuthenticationErrorResponse)authenticationResponse;
                ErrorObject errorObject = authenticationErrorResponse.getErrorObject();
                JSONObject jsonObject = errorObject.toJSONObject();
                throw new OpenIdConnectServiceException.AuthenticationException(jsonObject.toString());
            }
            return (AuthenticationSuccessResponse)authenticationResponse;
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | URISyntaxException exception) {
            throw new OpenIdConnectServiceException.AuthenticationException(StringBundler.concat((Object[])new Object[]{"Unable to process response from ", requestURL, ": ", exception.getMessage()}), exception);
        }
    }

    private List<LangTag> _getLangTags(HttpServletRequest httpServletRequest) {
        Locale locale = this._portal.getLocale(httpServletRequest);
        if (locale == null) {
            return null;
        }
        try {
            return Collections.singletonList(LangTag.parse((String)this._language.getBCP47LangTag(locale)));
        }
        catch (LangTagException langTagException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to create a lang tag with locale " + locale.getLanguage()), (Throwable)langTagException);
            }
            return null;
        }
    }

    private URI _getLoginRedirectURI(HttpServletRequest httpServletRequest) {
        try {
            return new URI(StringBundler.concat((String[])new String[]{this._portal.getPortalURL(httpServletRequest), this._portal.getPathContext(), "/c/portal/login/openidconnect"}));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new SystemException("Unable to generate OpenId Connect login redirect URI: " + uriSyntaxException.getMessage(), (Throwable)uriSyntaxException);
        }
    }

    private String _requestUserInfoJSON(AccessToken accessToken, OIDCProviderMetadata oidcProviderMetadata) throws OpenIdConnectServiceException.UserInfoException {
        UserInfoRequest userInfoRequest = new UserInfoRequest(oidcProviderMetadata.getUserInfoEndpointURI(), (AccessToken)((BearerAccessToken)accessToken));
        HTTPRequest httpRequest = userInfoRequest.toHTTPRequest();
        httpRequest.setAccept("text/html, image/gif, image/jpeg, */*; q=0.2, */*; q=0.2");
        try {
            HTTPResponse httpResponse = httpRequest.send();
            UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
            if (userInfoResponse instanceof UserInfoErrorResponse) {
                UserInfoErrorResponse userInfoErrorResponse = (UserInfoErrorResponse)userInfoResponse;
                ErrorObject errorObject = userInfoErrorResponse.getErrorObject();
                JSONObject jsonObject = errorObject.toJSONObject();
                throw new OpenIdConnectServiceException.UserInfoException(jsonObject.toString());
            }
            UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
            UserInfo userInfo = userInfoSuccessResponse.getUserInfo();
            if (userInfo == null) {
                JWT userInfoJWT = userInfoSuccessResponse.getUserInfoJWT();
                userInfo = new UserInfo(userInfoJWT.getJWTClaimsSet());
            }
            return userInfo.toJSONString();
        }
        catch (IOException ioException) {
            throw new OpenIdConnectServiceException.UserInfoException(StringBundler.concat((Object[])new Object[]{"Unable to get user information from ", oidcProviderMetadata.getUserInfoEndpointURI(), ": ", ioException.getMessage()}), (Throwable)ioException);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | ParseException exception) {
            throw new OpenIdConnectServiceException.UserInfoException(StringBundler.concat((Object[])new Object[]{"Unable to parse user information response from ", oidcProviderMetadata.getUserInfoEndpointURI(), ": ", exception.getMessage()}), exception);
        }
    }

    private void _validateState(State requestedState, State state) throws Exception {
        if (!state.equals((Object)requestedState)) {
            throw new OpenIdConnectServiceException.AuthenticationException(StringBundler.concat((String[])new String[]{"Requested value \"", requestedState.getValue(), "\" and approved state \"", state.getValue(), "\" do not match"}));
        }
    }
}

