/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnect;
import com.liferay.portal.security.sso.openid.connect.configuration.OpenIdConnectConfiguration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenIdConnect.class})
public class OpenIdConnectImpl
implements OpenIdConnect {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;

    public boolean isEnabled(long companyId) {
        try {
            OpenIdConnectConfiguration openIdConnectConfiguration = (OpenIdConnectConfiguration)this._configurationProvider.getConfiguration(OpenIdConnectConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.openid.connect"));
            return openIdConnectConfiguration.enabled();
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to get OpenId configuration for company ", companyId, ": ", configurationException.getMessage()}), (Throwable)configurationException);
            return false;
        }
    }
}

