/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.configuration.instance.lifecycle;

import com.liferay.oauth.client.persistence.constants.OAuthClientEntryConstants;
import com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata;
import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.service.OAuthClientASLocalMetadataLocalService;
import com.liferay.oauth.client.persistence.service.OAuthClientEntryLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.EveryNodeEveryStartup;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.internal.util.OpenIdConnectProviderUtil;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Deprecated
@Component(service={PortalInstanceLifecycleListener.class})
public class OpenIdConnectProviderPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener
implements EveryNodeEveryStartup {
    private static final String _CLIENT_TO = "Client to ";
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectProviderPortalInstanceLifecycleListener.class);
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private OAuthClientASLocalMetadataLocalService _oAuthClientASLocalMetadataLocalService;
    @Reference
    private OAuthClientEntryLocalService _oAuthClientEntryLocalService;
    private final Map<String, Dictionary<String, ?>> _properties = new ConcurrentHashMap();
    private ServiceRegistration<ManagedServiceFactory> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!this._clusterMasterExecutor.isMaster()) {
            return;
        }
        this._properties.forEach((pid, properties) -> {
            if (GetterUtil.getLong(properties.get("companyId")) == 0L) {
                this._updateOAuthClientEntry(company.getCompanyId(), null, (Dictionary<String, ?>)properties);
            }
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._serviceRegistration = bundleContext.registerService(ManagedServiceFactory.class, (Object)new OpenIdConnectProviderManagedServiceFactory(), MapUtil.singletonDictionary((Object)"service.pid", (Object)"com.liferay.portal.security.sso.openid.connect.internal.configuration.OpenIdConnectProviderConfiguration"));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private void _addOAuthClientEntry(Dictionary<String, ?> properties, long guestUserId) throws Exception {
        this._oAuthClientEntryLocalService.addOAuthClientEntry(guestUserId, this._generateAuthRequestParametersJSON(properties), this._updateOAuthClientASLocalMetadata(guestUserId, properties), this._generateInfoJSON(properties), OAuthClientEntryConstants.OIDC_USER_INFO_MAPPER_JSON, this._generateTokenRequestParametersJSON(properties));
    }

    private String _deleteOAuthClientASLocalMetadata(Dictionary<String, ?> properties) throws Exception {
        String discoveryEndPoint = this._getPropertyAsString("discoveryEndPoint", properties);
        if (Validator.isNotNull((String)discoveryEndPoint)) {
            return discoveryEndPoint;
        }
        String localWellKnownURI = this._generateLocalWellKnownURI(this._getPropertyAsString("issuerURL", properties), this._getPropertyAsString("tokenEndPoint", properties));
        this._oAuthClientASLocalMetadataLocalService.deleteOAuthClientASLocalMetadata(localWellKnownURI);
        return localWellKnownURI;
    }

    private void _deleteOAuthClientEntries(Dictionary<String, ?> properties) {
        block2: {
            try {
                this._companyLocalService.forEachCompanyId(companyId -> this._deleteOAuthClientEntry((long)companyId, properties));
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _deleteOAuthClientEntry(long companyId, Dictionary<String, ?> properties) {
        block2: {
            OpenIdConnectProviderUtil.removeOAuthClientEntryIdsByCompanyId(companyId);
            try {
                String authServerWellKnownURI = this._deleteOAuthClientASLocalMetadata(properties);
                this._oAuthClientEntryLocalService.deleteOAuthClientEntry(companyId, authServerWellKnownURI, this._getPropertyAsString("openIdConnectClientId", properties));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)exception);
            }
        }
    }

    private String _generateAuthRequestParametersJSON(Dictionary<String, ?> properties) {
        JSONObject requestParametersJSONObject = this._generateRequestParametersJSONObject("customAuthorizationRequestParameters", properties);
        return requestParametersJSONObject.put("response_type", "code").toString();
    }

    private String _generateClientName(Dictionary<String, ?> properties) {
        String providerName = this._getPropertyAsString("providerName", properties);
        if (Validator.isNull((String)providerName)) {
            return null;
        }
        return _CLIENT_TO + providerName;
    }

    private String _generateInfoJSON(Dictionary<String, ?> properties) {
        return JSONUtil.put((String)"client_id", (Object)this._getPropertyAsString("openIdConnectClientId", properties)).put("client_name", this._generateClientName(properties)).put("client_secret", this._getPropertyAsString("openIdConnectClientSecret", properties)).put("grant_types", JSONUtil.putAll((Object[])new Object[]{"authorization_code", "refresh_token"})).put("id_token_signed_response_alg", this._getPropertyAsString("registeredIdTokenSigningAlg", properties)).put("response_types", JSONUtil.put((Object)"code")).put("scope", this._getPropertyAsString("scopes", properties)).toString();
    }

    private String _generateLocalWellKnownURI(String issuer, String tokenEndPoint) throws Exception {
        URI issuerURI = URI.create(issuer);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        return StringBundler.concat((Object[])new Object[]{issuerURI.getScheme(), "://", issuerURI.getAuthority(), "/.well-known/openid-configuration", issuerURI.getPath(), Character.valueOf('/'), Base64.encodeToURL((byte[])messageDigest.digest(tokenEndPoint.getBytes())), "/local"});
    }

    private String _generateMetadataJSON(Dictionary<String, ?> properties) {
        return JSONUtil.put((String)"authorization_endpoint", (Object)this._getPropertyAsString("authorizationEndPoint", properties)).put("id_token_signing_alg_values_supported", this._getPropertyAsJSONArray("idTokenSigningAlgValues", properties)).put("issuer", this._getPropertyAsString("issuerURL", properties)).put("jwks_uri", this._getPropertyAsString("jwksURI", properties)).put("scopes_supported", this._getPropertyAsJSONArray("scopes", properties)).put("subject_types_supported", this._getPropertyAsJSONArray("subjectTypes", properties)).put("token_endpoint", this._getPropertyAsString("tokenEndPoint", properties)).put("userinfo_endpoint", this._getPropertyAsString("userInfoEndPoint", properties)).toString();
    }

    private JSONObject _generateRequestParametersJSONObject(String key, Dictionary<String, ?> properties) {
        JSONObject requestParametersJSONObject = JSONUtil.put((String)"scope", (Object)this._getPropertyAsString("scopes", properties));
        String[] parameters = GetterUtil.getStringValues(properties.get(key));
        if (parameters.length < 1) {
            return requestParametersJSONObject;
        }
        for (String parameter : parameters) {
            JSONArray valuesJSONArray;
            String[] parameterArray = parameter.split("=");
            if (parameterArray.length != 2) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Parameter: " + parameter + " is not valid"));
                continue;
            }
            if (parameterArray[0].equals("resource")) {
                JSONArray valuesJSONArray2 = requestParametersJSONObject.getJSONArray(parameterArray[0]);
                if (valuesJSONArray2 != null) {
                    for (String value : parameterArray[1].split(" ")) {
                        valuesJSONArray2.put(value);
                    }
                    continue;
                }
                requestParametersJSONObject.put(parameterArray[0], JSONUtil.putAll((Object[])parameterArray[1].split(" ")));
                continue;
            }
            JSONObject customRequestParametersJSONObject = requestParametersJSONObject.getJSONObject("custom_request_parameters");
            if (customRequestParametersJSONObject == null) {
                customRequestParametersJSONObject = this._jsonFactory.createJSONObject();
                requestParametersJSONObject.put("custom_request_parameters", customRequestParametersJSONObject);
            }
            if ((valuesJSONArray = customRequestParametersJSONObject.getJSONArray(parameterArray[0])) != null) {
                for (String value : parameterArray[1].split(" ")) {
                    valuesJSONArray.put(value);
                }
                continue;
            }
            customRequestParametersJSONObject.put(parameterArray[0], JSONUtil.putAll((Object[])parameterArray[1].split(" ")));
        }
        return requestParametersJSONObject;
    }

    private String _generateTokenRequestParametersJSON(Dictionary<String, ?> properties) {
        JSONObject requestParametersJSONObject = this._generateRequestParametersJSONObject("customTokenRequestParameters", properties);
        return requestParametersJSONObject.put("grant_type", "authorization_code").toString();
    }

    private JSONArray _getPropertyAsJSONArray(String key, Dictionary<String, ?> properties) {
        if (properties.get(key) == null) {
            return null;
        }
        String[] values = null;
        if (key.equals("scopes")) {
            String scopes = this._getPropertyAsString("scopes", properties);
            values = scopes.split(" ");
        } else {
            values = GetterUtil.getStringValues(properties.get(key));
        }
        if (values.length < 1) {
            return null;
        }
        return JSONUtil.putAll((Object[])values);
    }

    private String _getPropertyAsString(String key, Dictionary<String, ?> properties) {
        String value = (String)properties.get(key);
        if (value == null || value.equals("")) {
            return null;
        }
        return value;
    }

    private String _updateOAuthClientASLocalMetadata(long guestUserId, Dictionary<String, ?> properties) throws Exception {
        String discoveryEndPoint = this._getPropertyAsString("discoveryEndPoint", properties);
        if (Validator.isNotNull((String)discoveryEndPoint)) {
            return discoveryEndPoint;
        }
        String localWellKnownURI = this._generateLocalWellKnownURI(this._getPropertyAsString("issuerURL", properties), this._getPropertyAsString("tokenEndPoint", properties));
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this._oAuthClientASLocalMetadataLocalService.fetchOAuthClientASLocalMetadata(localWellKnownURI);
        if (oAuthClientASLocalMetadata == null) {
            this._oAuthClientASLocalMetadataLocalService.addOAuthClientASLocalMetadata(guestUserId, this._generateMetadataJSON(properties), "openid-configuration");
        } else {
            this._oAuthClientASLocalMetadataLocalService.updateOAuthClientASLocalMetadata(oAuthClientASLocalMetadata.getOAuthClientASLocalMetadataId(), this._generateMetadataJSON(properties), "openid-configuration");
        }
        return localWellKnownURI;
    }

    private void _updateOAuthClientEntry(long companyId, Dictionary<String, ?> oldProperties, Dictionary<String, ?> properties) {
        block9: {
            long guestUserId;
            block8: {
                guestUserId = 0L;
                try {
                    guestUserId = this._userLocalService.getGuestUserId(companyId);
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Object)("Unable to get guest user ID for company " + companyId), (Throwable)portalException);
                }
            }
            try {
                if (oldProperties != null) {
                    String oldAuthServerWellKnownURI = this._updateOAuthClientASLocalMetadata(guestUserId, oldProperties);
                    OAuthClientEntry oldOAuthClientEntry = this._oAuthClientEntryLocalService.fetchOAuthClientEntry(companyId, oldAuthServerWellKnownURI, this._getPropertyAsString("openIdConnectClientId", oldProperties));
                    if (oldOAuthClientEntry != null) {
                        this._oAuthClientEntryLocalService.updateOAuthClientEntry(oldOAuthClientEntry.getOAuthClientEntryId(), this._generateAuthRequestParametersJSON(properties), this._updateOAuthClientASLocalMetadata(guestUserId, properties), this._generateInfoJSON(properties), oldOAuthClientEntry.getOIDCUserInfoMapperJSON(), this._generateTokenRequestParametersJSON(properties));
                    } else {
                        this._addOAuthClientEntry(properties, guestUserId);
                    }
                } else {
                    this._addOAuthClientEntry(properties, guestUserId);
                }
                OpenIdConnectProviderUtil.removeOAuthClientEntryIdsByCompanyId(companyId);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Object)"Unable to update OAuth client entry", (Throwable)exception);
            }
        }
    }

    private class OpenIdConnectProviderManagedServiceFactory
    implements ManagedServiceFactory {
        private OpenIdConnectProviderManagedServiceFactory() {
        }

        public void deleted(String pid) {
            Dictionary<String, ?> properties = OpenIdConnectProviderPortalInstanceLifecycleListener.this._properties.remove(pid);
            long companyId = GetterUtil.getLong(properties.get("companyId"));
            if (companyId == 0L) {
                OpenIdConnectProviderPortalInstanceLifecycleListener.this._deleteOAuthClientEntries(properties);
            } else {
                try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)companyId);){
                    OpenIdConnectProviderPortalInstanceLifecycleListener.this._deleteOAuthClientEntry(companyId, properties);
                }
            }
        }

        public String getName() {
            return "OpenId Connect Provider Managed Service Factory";
        }

        public void updated(String pid, Dictionary<String, ?> properties) {
            long companyId = GetterUtil.getLong(properties.get("companyId"));
            Dictionary<String, ?> oldProperties = OpenIdConnectProviderPortalInstanceLifecycleListener.this._properties.put(pid, properties);
            if (companyId == 0L) {
                block9: {
                    try {
                        OpenIdConnectProviderPortalInstanceLifecycleListener.this._companyLocalService.forEachCompanyId(curCompanyId -> OpenIdConnectProviderPortalInstanceLifecycleListener.this._updateOAuthClientEntry((long)curCompanyId, oldProperties, properties));
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block9;
                        _log.debug((Throwable)exception);
                    }
                }
                return;
            }
            try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)companyId);){
                OpenIdConnectProviderPortalInstanceLifecycleListener.this._updateOAuthClientEntry(companyId, oldProperties, properties);
            }
        }
    }
}

