/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.util;

import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.service.OAuthClientEntryLocalService;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OpenIdConnectProviderUtil {
    private static final String _CLIENT_TO = "Client to ";
    private static final Map<Long, Map<String, Long>> _oAuthClientEntryIds = new ConcurrentHashMap<Long, Map<String, Long>>();

    public static long getOAuthClientEntryId(long companyId, String providerName, OAuthClientEntryLocalService oAuthClientEntryLocalService) {
        Map<String, Long> oAuthClientEntryIds = OpenIdConnectProviderUtil._getOAuthClientEntryIds(companyId, oAuthClientEntryLocalService);
        if (oAuthClientEntryIds.isEmpty()) {
            oAuthClientEntryIds = OpenIdConnectProviderUtil._getOAuthClientEntryIds(0L, oAuthClientEntryLocalService);
        }
        if (oAuthClientEntryIds.isEmpty()) {
            return 0L;
        }
        Long oAuthClientEntryId = oAuthClientEntryIds.get(providerName);
        if (oAuthClientEntryId == null) {
            return 0L;
        }
        return oAuthClientEntryId;
    }

    public static Map<String, Long> removeOAuthClientEntryIdsByCompanyId(long companyId) {
        return _oAuthClientEntryIds.remove(companyId);
    }

    private static Map<String, Long> _getOAuthClientEntryIds(long companyId, OAuthClientEntryLocalService oAuthClientEntryLocalService) {
        return _oAuthClientEntryIds.computeIfAbsent(companyId, key -> {
            HashMap<String, Long> oAuthClientEntryIds = new HashMap<String, Long>();
            for (OAuthClientEntry oAuthClientEntry : oAuthClientEntryLocalService.getCompanyOAuthClientEntries(companyId)) {
                try {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)oAuthClientEntry.getInfoJSON());
                    String clientName = jsonObject.getString("client_name", null);
                    if (clientName != null) {
                        clientName = clientName.substring(_CLIENT_TO.length());
                    }
                    oAuthClientEntryIds.put(clientName, oAuthClientEntry.getOAuthClientEntryId());
                }
                catch (JSONException jsonException) {
                    throw new RuntimeException(jsonException);
                }
            }
            return oAuthClientEntryIds;
        });
    }
}

