/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.persistence.internal.upgrade.v2_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URI;
import java.security.MessageDigest;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class OpenIdConnectSessionUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectSessionUpgradeProcess.class);
    private final ConfigurationAdmin _configurationAdmin;

    public OpenIdConnectSessionUpgradeProcess(ConfigurationAdmin configurationAdmin) {
        this._configurationAdmin = configurationAdmin;
    }

    protected void doUpgrade() throws Exception {
        block29: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select openIdConnectSessionId, configurationPid from OpenIdConnectSession");){
                ResultSet resultSet = preparedStatement.executeQuery();
                Throwable throwable = null;
                block20: while (true) {
                    try {
                        while (resultSet.next()) {
                            long openIdConnectSessionId = resultSet.getLong("openIdConnectSessionId");
                            String configurationPid = resultSet.getString("configurationPid");
                            try {
                                this._upgradeOpenIdConnectSession(openIdConnectSessionId, configurationPid);
                                continue block20;
                            }
                            catch (Exception exception) {
                                if (_log.isDebugEnabled()) {
                                    _log.debug((Throwable)exception);
                                }
                                this.runSQL("delete from OpenIdConnectSession where openIdConnectSessionId = " + openIdConnectSessionId);
                            }
                        }
                        break block29;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (resultSet != null) {
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropColumns((String)"OpenIdConnectSession", (String[])new String[]{"configurationPid", "providerName"})};
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"OpenIdConnectSession", (String[])new String[]{"authServerWellKnownURI VARCHAR(256) null", "clientId VARCHAR(256) null"})};
    }

    private String _generateLocalWellKnownURI(String issuer, String tokenEndPoint) throws Exception {
        URI issuerURI = URI.create(issuer);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        return StringBundler.concat((Object[])new Object[]{issuerURI.getScheme(), "://", issuerURI.getAuthority(), "/.well-known/openid-configuration", issuerURI.getPath(), Character.valueOf('/'), Base64.encodeToURL((byte[])messageDigest.digest(tokenEndPoint.getBytes())), "/local"});
    }

    private void _upgradeOpenIdConnectSession(long openIdConnectSessionId, String configurationPid) throws Exception {
        Configuration configuration = this._configurationAdmin.getConfiguration(configurationPid, "?");
        Dictionary properties = configuration.getProperties();
        String discoveryEndPoint = GetterUtil.getString(properties.get("discoveryEndPoint"));
        if (Validator.isNull((String)discoveryEndPoint)) {
            discoveryEndPoint = this._generateLocalWellKnownURI(GetterUtil.getString(properties.get("issuerURL")), GetterUtil.getString(properties.get("tokenEndPoint")));
        }
        String openIdConnectClientId = GetterUtil.getString(properties.get("openIdConnectClientId"));
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update OpenIdConnectSession set authServerWellKnownURI = ?, clientId = ? WHERE openIdConnectSessionId = ?");){
            preparedStatement.setString(1, discoveryEndPoint);
            preparedStatement.setString(2, openIdConnectClientId);
            preparedStatement.setLong(3, openIdConnectSessionId);
            preparedStatement.execute();
        }
    }
}

