/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.opensso.internal.auto.login;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ContactNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.security.sso.OpenSSO;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserImporter;
import com.liferay.portal.security.sso.opensso.configuration.OpenSSOConfiguration;
import com.liferay.portal.security.sso.opensso.exception.StrangersNotAllowedException;
import com.liferay.portal.util.PropsValues;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.opensso.configuration.OpenSSOConfiguration"}, immediate=true, service={AutoLogin.class})
public class OpenSSOAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(OpenSSOAutoLogin.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private OpenSSO _openSSO;
    @Reference
    private Portal _portal;
    @Reference
    private ScreenNameGenerator _screenNameGenerator;
    @Reference
    private UserImporter _userImporter;
    @Reference
    private UserLocalService _userLocalService;

    protected User addUser(long companyId, String firstName, String lastName, String emailAddress, String screenName, Locale locale) throws PortalException {
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        String middleName = "";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        return this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
    }

    protected void checkAddUser(long companyId, String emailAddress) throws PortalException {
        Company company = this._companyLocalService.getCompany(companyId);
        if (!company.isStrangers()) {
            throw new StrangersNotAllowedException(companyId);
        }
        if (!company.isStrangersWithMx() && company.hasCompanyMx(emailAddress)) {
            throw new UserEmailAddressException.MustNotUseCompanyMx(emailAddress);
        }
    }

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String currentURL;
        String screenName;
        User user;
        String lastName;
        String firstName;
        String emailAddress;
        String openSSOScreenName;
        long companyId;
        block20: {
            companyId = this._portal.getCompanyId(httpServletRequest);
            OpenSSOConfiguration openSSOConfiguration = this.getOpenSSOConfiguration(companyId);
            if (!openSSOConfiguration.enabled()) {
                return null;
            }
            if (!this._openSSO.isAuthenticated(httpServletRequest, openSSOConfiguration.serviceURL())) {
                return null;
            }
            Map nameValues = this._openSSO.getAttributes(httpServletRequest, openSSOConfiguration.serviceURL());
            openSSOScreenName = (String)nameValues.get(openSSOConfiguration.screenNameAttr());
            emailAddress = (String)nameValues.get(openSSOConfiguration.emailAddressAttr());
            firstName = (String)nameValues.get(openSSOConfiguration.firstNameAttr());
            lastName = (String)nameValues.get(openSSOConfiguration.lastNameAttr());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Validating user information for ", firstName, " ", lastName, " with screen name ", openSSOScreenName, " and email address ", emailAddress}));
            }
            user = null;
            screenName = openSSOScreenName;
            if (PrefsPropsUtil.getBoolean((long)companyId, (String)"users.screen.name.always.autogenerate") && (user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress)) != null) {
                screenName = this._screenNameGenerator.generate(companyId, user.getUserId(), emailAddress);
            }
            if (openSSOConfiguration.importFromLDAP()) {
                try {
                    String authType = PrefsPropsUtil.getString((long)companyId, (String)"company.security.auth.type", (String)PropsValues.COMPANY_SECURITY_AUTH_TYPE);
                    if (authType.equals("screenName")) {
                        user = this._userImporter.importUser(companyId, "", screenName);
                        break block20;
                    }
                    user = this._userImporter.importUser(companyId, emailAddress, "");
                }
                catch (SystemException systemException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)systemException, (Throwable)systemException);
                    }
                    break block20;
                }
            }
            if (Validator.isNull((String)emailAddress)) {
                return this.doHandleException(httpServletRequest, httpServletResponse, new Exception("Email address is null"));
            }
        }
        if (user == null) {
            user = this._userLocalService.fetchUserByScreenName(companyId, screenName);
        }
        if (user == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Locale locale = LocaleUtil.getDefault();
            if (themeDisplay != null) {
                locale = themeDisplay.getLocale();
            }
            try {
                this.checkAddUser(companyId, emailAddress);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding user " + screenName));
                }
                user = this.addUser(companyId, firstName, lastName, emailAddress, screenName, locale);
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Failed to import OpenSSO user '", openSSOScreenName, "': ", portalException.getMessage()}), (Throwable)portalException);
                }
                if (portalException instanceof ContactNameException) {
                    httpServletRequest.setAttribute("OPEN_SSO_ERROR", (Object)ContactNameException.class.getSimpleName());
                } else {
                    Class<?> clazz = ((Object)((Object)portalException)).getClass();
                    httpServletRequest.setAttribute("OPEN_SSO_ERROR", (Object)clazz.getSimpleName());
                }
                httpServletRequest.setAttribute("OPEN_SSO_SUBJECT_SCREEN_NAME", (Object)openSSOScreenName);
                return null;
            }
        }
        if ((currentURL = this._portal.getCurrentURL(httpServletRequest)).contains("/portal/login")) {
            String redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
            redirect = Validator.isNotNull((String)redirect) ? this._portal.escapeRedirect(redirect) : this._portal.getPathMain();
            httpServletRequest.setAttribute("AUTO_LOGIN_REDIRECT", (Object)redirect);
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }

    protected OpenSSOConfiguration getOpenSSOConfiguration(long companyId) throws Exception {
        return (OpenSSOConfiguration)this._configurationProvider.getConfiguration(OpenSSOConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.opensso"));
    }
}

