/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.opensso.internal.servlet.filter;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.sso.OpenSSO;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.opensso.configuration.OpenSSOConfiguration;
import com.liferay.portal.util.PropsValues;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.opensso.configuration.OpenSSOConfiguration"}, immediate=true, property={"before-filter=Auto Login Filter", "dispatcher=FORWARD", "dispatcher=REQUEST", "servlet-context-name=", "servlet-filter-name=SSO Open SSO Filter", "url-pattern=/c/portal/login", "url-pattern=/c/portal/logout"}, service={Filter.class})
public class OpenSSOFilter
extends BaseFilter {
    private static final String _SUBJECT_ID_KEY = "open.sso.subject.id";
    private static final Log _log = LogFactoryUtil.getLog(OpenSSOFilter.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private OpenSSO _openSSO;
    @Reference
    private Portal _portal;

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            OpenSSOConfiguration openSSOConfiguration = this._getOpenSSOConfiguration(this._portal.getCompanyId(httpServletRequest));
            if (openSSOConfiguration.enabled() && Validator.isNotNull((String)openSSOConfiguration.loginURL()) && Validator.isNotNull((String)openSSOConfiguration.logoutURL()) && Validator.isNotNull((String)openSSOConfiguration.serviceURL())) {
                return true;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return false;
    }

    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        String currentURL;
        OpenSSOConfiguration openSSOConfiguration = this._getOpenSSOConfiguration(this._portal.getCompanyId(httpServletRequest));
        String requestURI = GetterUtil.getString((String)httpServletRequest.getRequestURI());
        if (requestURI.endsWith("/portal/logout")) {
            HttpSession httpSession = httpServletRequest.getSession();
            httpSession.invalidate();
            httpServletResponse.sendRedirect(openSSOConfiguration.logoutURL());
            return;
        }
        boolean authenticated = false;
        try {
            authenticated = this._openSSO.isAuthenticated(httpServletRequest, openSSOConfiguration.serviceURL());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            this.processFilter(OpenSSOFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        HttpSession httpSession = httpServletRequest.getSession();
        if (authenticated) {
            String newSubjectId = this._openSSO.getSubjectId(httpServletRequest, openSSOConfiguration.serviceURL());
            String oldSubjectId = (String)httpSession.getAttribute(_SUBJECT_ID_KEY);
            if (oldSubjectId == null) {
                httpSession.setAttribute(_SUBJECT_ID_KEY, (Object)newSubjectId);
            } else if (!newSubjectId.equals(oldSubjectId)) {
                httpSession.invalidate();
                httpSession = httpServletRequest.getSession();
                httpSession.setAttribute(_SUBJECT_ID_KEY, (Object)newSubjectId);
            }
            this.processFilter(OpenSSOFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        if (this._portal.getUserId(httpServletRequest) > 0L) {
            httpSession.invalidate();
        }
        String loginURL = openSSOConfiguration.loginURL();
        if (!PropsValues.AUTH_FORWARD_BY_LAST_PATH || !loginURL.contains("/portal/login")) {
            httpServletResponse.sendRedirect(openSSOConfiguration.loginURL());
            return;
        }
        String redirect = currentURL = this._portal.getCurrentURL(httpServletRequest);
        if (currentURL.contains("/portal/login") && Validator.isNull((String)(redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect")))) {
            redirect = this._portal.getPathMain();
        }
        redirect = openSSOConfiguration.loginURL() + URLCodec.encodeURL((String)("?redirect=" + URLCodec.encodeURL((String)redirect)));
        httpServletResponse.sendRedirect(redirect);
    }

    private OpenSSOConfiguration _getOpenSSOConfiguration(long companyId) throws Exception {
        return (OpenSSOConfiguration)this._configurationProvider.getConfiguration(OpenSSOConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.opensso"));
    }
}

