/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.token.internal.auto.login;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserImporter;
import com.liferay.portal.security.sso.token.configuration.TokenConfiguration;
import com.liferay.portal.security.sso.token.security.auth.TokenRetriever;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.token.internal.configuration.TokenConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, service={AutoLogin.class})
public class TokenAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(TokenAutoLogin.class);
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    private ServiceTrackerMap<String, TokenRetriever> _tokenRetrievers;
    private UserImporter _userImporter;
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._tokenRetrievers = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, TokenRetriever.class, (String)"token.location");
    }

    @Deactivate
    protected void deactivate() {
        this._tokenRetrievers.close();
    }

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long companyId = this._portal.getCompanyId(httpServletRequest);
        TokenConfiguration tokenCompanyServiceSettings = (TokenConfiguration)this._configurationProvider.getConfiguration(TokenConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.token"));
        if (!tokenCompanyServiceSettings.enabled()) {
            return null;
        }
        String userTokenName = tokenCompanyServiceSettings.userTokenName();
        String tokenLocation = tokenCompanyServiceSettings.tokenLocation();
        TokenRetriever tokenRetriever = (TokenRetriever)this._tokenRetrievers.getService((Object)tokenLocation);
        if (tokenRetriever == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No token retriever found for " + tokenLocation));
            }
            return null;
        }
        String login = tokenRetriever.getLoginToken(httpServletRequest, userTokenName);
        if (Validator.isNull((String)login)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("No login found for " + tokenLocation));
            }
            return null;
        }
        User user = this._getUser(companyId, login, tokenCompanyServiceSettings);
        this.addRedirect(httpServletRequest);
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(unbind="-")
    protected void setUserImporter(UserImporter userImporter) {
        this._userImporter = userImporter;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    private User _getUser(long companyId, String login, TokenConfiguration tokenCompanyServiceSettings) throws Exception {
        String authType;
        User user;
        block14: {
            user = null;
            authType = PrefsPropsUtil.getString((long)companyId, (String)"company.security.auth.type", (String)PropsValues.COMPANY_SECURITY_AUTH_TYPE);
            if (tokenCompanyServiceSettings.importFromLDAP()) {
                try {
                    if (authType.equals("screenName")) {
                        user = this._userImporter.importUser(companyId, "", login);
                    } else if (authType.equals("emailAddress")) {
                        user = this._userImporter.importUser(companyId, login, "");
                    } else if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"The property \"", "company.security.auth.type", "\" must be set to either \"", "emailAddress", "\" or \"", "screenName", "\""}));
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block14;
                    _log.warn((Object)"Unable to import from LDAP", (Throwable)exception);
                }
            }
        }
        if (user != null) {
            return user;
        }
        if (authType.equals("screenName")) {
            user = this._userLocalService.getUserByScreenName(companyId, login);
        } else if (authType.equals("emailAddress")) {
            user = this._userLocalService.getUserByEmailAddress(companyId, login);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Incompatible setting for: ", "company.security.auth.type", ". Please configure to either: ", "emailAddress", " or ", "screenName"}));
        }
        return user;
    }
}

