/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.token.internal.events;

import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.token.events.LogoutProcessor;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"logout.processor.type=COOKIE"}, service={LogoutProcessor.class})
public class CookieLogoutProcessor
implements LogoutProcessor {
    public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String ... parameters) {
        String domain = CookieKeys.getDomain((HttpServletRequest)httpServletRequest);
        for (String parameter : parameters) {
            Cookie cookie = new Cookie(parameter, "");
            if (Validator.isNotNull((String)domain)) {
                cookie.setDomain(domain);
            }
            cookie.setMaxAge(0);
            cookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)cookie);
        }
    }
}

