/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.token.internal.events;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.token.configuration.TokenConfiguration;
import com.liferay.portal.security.sso.token.events.LogoutProcessor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.token.configuration.TokenConfiguration"}, property={"key=logout.events.post"}, service={LifecycleAction.class})
public class TokenLogoutAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(TokenLogoutAction.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    private ServiceTrackerMap<String, LogoutProcessor> _serviceTrackerMap;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            LogoutProcessor redirectLogoutProcessor;
            String logoutRedirectURL;
            LogoutProcessor cookieLogoutProcessor;
            TokenConfiguration tokenConfiguration = (TokenConfiguration)this._configurationProvider.getConfiguration(TokenConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(this._portal.getCompanyId(httpServletRequest), "com.liferay.portal.security.sso.token"));
            if (!tokenConfiguration.enabled()) {
                return;
            }
            Object[] authenticationCookies = tokenConfiguration.authenticationCookies();
            if (ArrayUtil.isNotEmpty((Object[])authenticationCookies) && (cookieLogoutProcessor = (LogoutProcessor)this._serviceTrackerMap.getService((Object)"COOKIE")) != null) {
                cookieLogoutProcessor.logout(httpServletRequest, httpServletResponse, (String[])authenticationCookies);
            }
            if (Validator.isNotNull((String)(logoutRedirectURL = tokenConfiguration.logoutRedirectURL())) && (redirectLogoutProcessor = (LogoutProcessor)this._serviceTrackerMap.getService((Object)"REDIRECT")) != null) {
                redirectLogoutProcessor.logout(httpServletRequest, httpServletResponse, new String[]{logoutRedirectURL});
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, LogoutProcessor.class, (String)"logout.processor.type");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

