/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.token.internal.upgrade.v2_0_0;

import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.security.sso.token.constants.LegacyTokenPropsKeys;
import java.util.Dictionary;

public class TokenConfigurationUpgradeProcess
extends UpgradeProcess {
    private static final String[][] _RENAME_PROPERTY_KEYS_ARRAY = new String[][]{{"shibboleth.auth.enabled", "enabled"}, {"shibboleth.import.from.ldap", "importFromLDAP"}, {"shibboleth.logout.url", "logoutRedirectURL"}, {"shibboleth.user.header", "userTokenName"}, {"siteminder.auth.enabled", "enabled"}, {"siteminder.import.from.ldap", "importFromLDAP"}, {"siteminder.user.header", "userTokenName"}};

    protected void doUpgrade() throws Exception {
        this._upgradeConfiguration();
    }

    private void _storeSettings(long companyId, String settingsId, Dictionary<String, String> dictionary) throws Exception {
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new CompanyServiceSettingsLocator(companyId, settingsId));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        SettingsDescriptor settingsDescriptor = SettingsFactoryUtil.getSettingsDescriptor((String)settingsId);
        for (String name : settingsDescriptor.getAllKeys()) {
            String oldValue;
            String value = dictionary.get(name);
            if (value == null || value.equals(oldValue = settings.getValue(name, null))) continue;
            modifiableSettings.setValue(name, value);
        }
        modifiableSettings.store();
    }

    private void _upgradeConfiguration() throws Exception {
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
            HashMapDictionary dictionary = new HashMapDictionary();
            for (String[] renamePropertykeys : _RENAME_PROPERTY_KEYS_ARRAY) {
                String propertyValue = PrefsPropsUtil.getString((long)companyId, (String)renamePropertykeys[0]);
                if (propertyValue == null) continue;
                dictionary.put(renamePropertykeys[1], propertyValue);
            }
            if (!dictionary.isEmpty()) {
                this._storeSettings((long)companyId, "com.liferay.portal.security.sso.token", (Dictionary<String, String>)dictionary);
            }
            CompanyLocalServiceUtil.removePreferences((long)companyId, (String[])((String[])ArrayUtil.append((Object[])LegacyTokenPropsKeys.SHIBBOLETH_KEYS, (Object[])LegacyTokenPropsKeys.SITEMINDER_KEYS)));
        });
    }
}

